/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ColumnFamily;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import javax.annotation.Nonnull;

public final class CreateTableRequest {
    private final CreateTableRequest.Builder requestBuilder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableRequest.newBuilder();

    public static CreateTableRequest of(String tableId) {
        return new CreateTableRequest(tableId);
    }

    private CreateTableRequest(String tableId) {
        this.requestBuilder.setTableId(tableId);
    }

    public CreateTableRequest addFamily(String familyId) {
        Preconditions.checkNotNull(familyId);
        this.requestBuilder.getTableBuilder().putColumnFamilies(familyId, ColumnFamily.getDefaultInstance());
        return this;
    }

    public CreateTableRequest addFamily(String familyId, GCRules.GCRule gcRule) {
        Preconditions.checkNotNull(familyId);
        this.requestBuilder.getTableBuilder().putColumnFamilies(familyId, ColumnFamily.newBuilder().setGcRule(gcRule.toProto()).build());
        return this;
    }

    public CreateTableRequest addSplit(ByteString key) {
        Preconditions.checkNotNull(key);
        this.requestBuilder.addInitialSplitsBuilder().setKey(key);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTableRequest that = (CreateTableRequest)o;
        return Objects.equal(this.requestBuilder.build(), that.requestBuilder.build());
    }

    public int hashCode() {
        return Objects.hashCode(this.requestBuilder.build());
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(instanceId);
        return this.requestBuilder.setParent(NameUtil.formatInstanceName(projectId, instanceId)).build();
    }
}

