/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

final class AddressFilter {
    private static final Attributes.Key<PathChain> PATH_CHAIN_KEY = Attributes.Key.create("com.google.bigtable.repackaged.io.grpc.xds.AddressFilter.PATH_CHAIN_KEY");

    private AddressFilter() {
    }

    static EquivalentAddressGroup setPathFilter(EquivalentAddressGroup address, List<String> names) {
        Preconditions.checkNotNull(address, "address");
        Preconditions.checkNotNull(names, "names");
        Attributes.Builder attrBuilder = address.getAttributes().toBuilder().discard(PATH_CHAIN_KEY);
        PathChain pathChain = null;
        for (String name : names) {
            if (pathChain == null) {
                pathChain = new PathChain(name);
                attrBuilder.set(PATH_CHAIN_KEY, pathChain);
                continue;
            }
            pathChain.next = new PathChain(name);
        }
        return new EquivalentAddressGroup(address.getAddresses(), attrBuilder.build());
    }

    static List<EquivalentAddressGroup> filter(List<EquivalentAddressGroup> addresses, String name) {
        Preconditions.checkNotNull(addresses, "addresses");
        Preconditions.checkNotNull(name, "name");
        ArrayList<EquivalentAddressGroup> filteredAddresses = new ArrayList<EquivalentAddressGroup>();
        for (EquivalentAddressGroup address : addresses) {
            PathChain pathChain = address.getAttributes().get(PATH_CHAIN_KEY);
            if (pathChain == null || !pathChain.name.equals(name)) continue;
            Attributes filteredAddressAttrs = address.getAttributes().toBuilder().set(PATH_CHAIN_KEY, pathChain.next).build();
            filteredAddresses.add(new EquivalentAddressGroup(address.getAddresses(), filteredAddressAttrs));
        }
        return Collections.unmodifiableList(filteredAddresses);
    }

    private static final class PathChain {
        final String name;
        @Nullable
        PathChain next;

        PathChain(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
        }

        public String toString() {
            return this.name + (this.next == null ? "" : ", " + this.next);
        }
    }
}

