/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.io.opencensus.trace.Span;
import com.google.bigtable.repackaged.io.opencensus.trace.Status;
import com.google.cloud.bigtable.hbase.adapters.read.RowCell;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;

@InternalApi(value="For internal usage only")
public class BigtableWhileMatchResultScannerAdapter {
    private static final String WHILE_MATCH_FILTER_IN_LABEL_SUFFIX = "-in";
    private static final String WHILE_MATCH_FILTER_OUT_LABEL_SUFFIX = "-out";

    public ResultScanner adapt(final ResultScanner bigtableResultScanner, final Span span) {
        return new AbstractClientScanner(){

            public Result next() throws IOException {
                Result row = bigtableResultScanner.next();
                if (row == null) {
                    span.end();
                    return null;
                }
                Result filteredResult = BigtableWhileMatchResultScannerAdapter.externalizeResult(row);
                if (filteredResult == null) {
                    this.close();
                }
                return filteredResult;
            }

            public void close() {
                try {
                    bigtableResultScanner.close();
                }
                catch (RuntimeException ex) {
                    span.setStatus(Status.UNKNOWN.withDescription(ex.getCause().getMessage()));
                    throw ex;
                }
                finally {
                    span.end();
                }
            }

            public boolean renewLease() {
                throw new UnsupportedOperationException("renewLease");
            }
        };
    }

    private static Result externalizeResult(Result result) {
        int inLabelCount = 0;
        int outLabelCount = 0;
        ImmutableList.Builder filteredCells = ImmutableList.builder();
        for (Cell cell : result.rawCells()) {
            if (cell instanceof RowCell) {
                RowCell rowCell = (RowCell)cell;
                for (String label : rowCell.getLabels()) {
                    if (label.endsWith(WHILE_MATCH_FILTER_IN_LABEL_SUFFIX)) {
                        ++inLabelCount;
                        continue;
                    }
                    if (!label.endsWith(WHILE_MATCH_FILTER_OUT_LABEL_SUFFIX)) continue;
                    ++outLabelCount;
                }
                if (!rowCell.getLabels().isEmpty()) continue;
                filteredCells.add(rowCell);
                continue;
            }
            filteredCells.add(cell);
        }
        if (inLabelCount != outLabelCount) {
            return null;
        }
        return Result.create((List)((Object)filteredCells.build()));
    }
}

