/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.workflow;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.HopWorkflowFileType;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.apache.hop.ui.workflow.actions.ActionBaseDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.workflow.ActionWorkflow;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class ActionWorkflowDialog
extends ActionBaseDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionWorkflow.class;
    protected ActionWorkflow action;
    private static final String[] FILE_FILTERLOGNAMES = new String[]{BaseMessages.getString(PKG, (String)"ActionWorkflow.Fileformat.TXT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWorkflow.Fileformat.LOG", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWorkflow.Fileformat.All", (String[])new String[0])};

    public ActionWorkflowDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, action, workflowMeta, variables);
        this.action = (ActionWorkflow)action;
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        this.backupChanged = this.action.hasChanged();
        this.createElements();
        this.getData();
        this.setActive();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    protected void createElements() {
        super.createElements();
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionWorkflow.Header", (String[])new String[0]));
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"ActionWorkflow.WorkflowFile.Label", (String[])new String[0]));
        this.wPassParams.setText(BaseMessages.getString(PKG, (String)"ActionWorkflow.PassAllParameters.Label", (String[])new String[0]));
        this.wWaitingToFinish = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wWaitingToFinish);
        this.wWaitingToFinish.setText(BaseMessages.getString(PKG, (String)"ActionWorkflow.WaitToFinish.Label", (String[])new String[0]));
        FormData fdWait = new FormData();
        fdWait.top = new FormAttachment((Control)this.wEveryRow, 10);
        fdWait.left = new FormAttachment(0, 0);
        this.wWaitingToFinish.setLayoutData((Object)fdWait);
        Composite cRunConfiguration = new Composite(this.wOptions, 0);
        cRunConfiguration.setLayout((Layout)new FormLayout());
        this.props.setLook((Control)cRunConfiguration);
        FormData fdLocal = new FormData();
        fdLocal.top = new FormAttachment(0);
        fdLocal.right = new FormAttachment(100);
        fdLocal.left = new FormAttachment(0);
        this.wbGetParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ActionWorkflowDialog.this.getParameters(null);
            }
        });
        this.wbBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWorkflowDialog.this.pickFileVFS();
            }
        });
        this.wbLogFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWorkflowDialog.this.selectLogFile(FILE_FILTERLOGNAMES);
            }
        });
    }

    protected ActionBase getAction() {
        return this.action;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ui/images/workflow.svg", (int)48, (int)48);
    }

    protected String[] getParameters() {
        return this.action.parameters;
    }

    protected void getParameters(WorkflowMeta inputWorkflowMeta) {
        try {
            if (inputWorkflowMeta == null) {
                ActionWorkflow jej = new ActionWorkflow();
                this.getInfo(jej);
                inputWorkflowMeta = jej.getWorkflowMeta(this.getMetadataProvider(), this.variables);
            }
            String[] parameters = inputWorkflowMeta.listParameters();
            String[] existing = this.wParameters.getItems(1);
            for (int i = 0; i < parameters.length; ++i) {
                if (Const.indexOfString((String)parameters[i], (String[])existing) >= 0) continue;
                TableItem item = new TableItem(this.wParameters.table, 0);
                item.setText(1, parameters[i]);
            }
            this.wParameters.removeEmptyRows();
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ActionWorkflowDialog.Exception.UnableToLoadWorkflow.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionWorkflowDialog.Exception.UnableToLoadWorkflow.Message", (String[])new String[0]), e);
        }
    }

    protected void pickFileVFS() {
        HopWorkflowFileType workflowFileType = new HopWorkflowFileType();
        String filename = BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wPath, (IVariables)this.variables, (String[])workflowFileType.getFilterExtensions(), (String[])workflowFileType.getFilterNames(), (boolean)true);
        if (filename != null) {
            this.replaceNameWithBaseFilename(filename);
        }
    }

    public void setActive() {
        super.setActive();
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.action.getName(), (String)""));
        this.wPath.setText(Const.NVL((String)this.action.getFilename(), (String)""));
        if (this.action.parameters != null) {
            for (int i = 0; i < this.action.parameters.length; ++i) {
                TableItem ti = this.wParameters.table.getItem(i);
                if (Utils.isEmpty((CharSequence)this.action.parameters[i])) continue;
                ti.setText(1, Const.NVL((String)this.action.parameters[i], (String)""));
                ti.setText(2, Const.NVL((String)this.action.parameterFieldNames[i], (String)""));
                ti.setText(3, Const.NVL((String)this.action.parameterValues[i], (String)""));
            }
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        this.wPassParams.setSelection(this.action.isPassingAllParameters());
        this.wPrevToParams.setSelection(this.action.paramsFromPrevious);
        this.wEveryRow.setSelection(this.action.execPerRow);
        this.wSetLogfile.setSelection(this.action.setLogfile);
        if (this.action.logfile != null) {
            this.wLogfile.setText(this.action.logfile);
        }
        if (this.action.logext != null) {
            this.wLogext.setText(this.action.logext);
        }
        this.wAddDate.setSelection(this.action.addDate);
        this.wAddTime.setSelection(this.action.addTime);
        if (this.action.logFileLevel != null) {
            this.wLoglevel.select(this.action.logFileLevel.getLevel());
        } else {
            this.wLoglevel.select(ActionWorkflow.DEFAULT_LOG_LEVEL.getLevel());
        }
        this.wAppendLogfile.setSelection(this.action.setAppendLogfile);
        this.wCreateParentFolder.setSelection(this.action.createParentFolder);
        this.wWaitingToFinish.setSelection(this.action.isWaitingToFinish());
        try {
            List runConfigurations = this.getMetadataProvider().getSerializer(WorkflowRunConfiguration.class).listObjectNames();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiRunConfiguration.id, (Object)new Object[]{runConfigurations, "workflow"});
            }
            catch (HopException hopException) {
                // empty catch block
            }
            this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
            this.wRunConfiguration.setText(Const.NVL((String)this.action.getRunConfiguration(), (String)""));
            if (Utils.isEmpty((CharSequence)this.action.getRunConfiguration())) {
                this.wRunConfiguration.select(0);
            } else {
                this.wRunConfiguration.setText(this.action.getRunConfiguration());
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting workflow run configurations", (Throwable)e);
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    protected void cancel() {
        this.action.setChanged(this.backupChanged);
        this.action = null;
        this.dispose();
    }

    @VisibleForTesting
    protected void getInfo(ActionWorkflow aw) {
        String param;
        int i;
        String jobPath = this.getPath();
        aw.setName(this.getName());
        aw.setFileName(jobPath);
        aw.setRunConfiguration(this.wRunConfiguration.getText());
        int nrItems = this.wParameters.nrNonEmpty();
        int nr = 0;
        for (i = 0; i < nrItems; ++i) {
            param = this.wParameters.getNonEmpty(i).getText(1);
            if (param == null || param.length() == 0) continue;
            ++nr;
        }
        aw.parameters = new String[nr];
        aw.parameterFieldNames = new String[nr];
        aw.parameterValues = new String[nr];
        nr = 0;
        for (i = 0; i < nrItems; ++i) {
            param = this.wParameters.getNonEmpty(i).getText(1);
            String fieldName = this.wParameters.getNonEmpty(i).getText(2);
            String value = this.wParameters.getNonEmpty(i).getText(3);
            aw.parameters[nr] = param;
            aw.parameterFieldNames[nr] = !Utils.isEmpty((CharSequence)Const.trim((String)fieldName)) ? fieldName : "";
            aw.parameterValues[nr] = !Utils.isEmpty((CharSequence)Const.trim((String)value)) ? value : "";
            ++nr;
        }
        aw.setPassingAllParameters(this.wPassParams.getSelection());
        aw.setLogfile = this.wSetLogfile.getSelection();
        aw.addDate = this.wAddDate.getSelection();
        aw.addTime = this.wAddTime.getSelection();
        aw.logfile = this.wLogfile.getText();
        aw.logext = this.wLogext.getText();
        aw.logFileLevel = this.wLoglevel.getSelectionIndex() >= 0 ? LogLevel.values()[this.wLoglevel.getSelectionIndex()] : LogLevel.BASIC;
        aw.paramsFromPrevious = this.wPrevToParams.getSelection();
        aw.execPerRow = this.wEveryRow.getSelection();
        aw.setAppendLogfile = this.wAppendLogfile.getSelection();
        aw.setWaitingToFinish(this.wWaitingToFinish.getSelection());
        aw.createParentFolder = this.wCreateParentFolder.getSelection();
        aw.setRunConfiguration(this.wRunConfiguration.getText());
    }

    public void ok() {
        if (Utils.isEmpty((CharSequence)this.getName())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.getInfo(this.action);
        this.action.setChanged();
        this.dispose();
    }

    @VisibleForTesting
    protected String getName() {
        return this.wName.getText();
    }

    @VisibleForTesting
    protected String getPath() {
        return this.wPath.getText();
    }
}

