/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.input;

import org.apache.hop.core.Const;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.input.MappingInputMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class MappingInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = MappingInputMeta.class;
    private TableView wFields;
    private MappingInputMeta input;

    public MappingInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (MappingInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MappingInputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MappingInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"MappingInputDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"MappingInputDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.input.getFieldName().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingInputDialog.ColumnInfo.Name", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingInputDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingInputDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MappingInputDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            if (this.input.getFieldName()[i] == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, this.input.getFieldName()[i]);
            String type = ValueMetaFactory.getValueMetaName((int)this.input.getFieldType()[i]);
            int length = this.input.getFieldLength()[i];
            int prec = this.input.getFieldPrecision()[i];
            if (type != null) {
                item.setText(2, type);
            }
            if (length >= 0) {
                item.setText(3, "" + length);
            }
            if (prec < 0) continue;
            item.setText(4, "" + prec);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        int nrFields = this.wFields.nrNonEmpty();
        this.input.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = item.getText(1);
            this.input.getFieldType()[i] = ValueMetaFactory.getIdForValueMeta((String)item.getText(2));
            this.input.getFieldLength()[i] = Const.toInt((String)item.getText(3), (int)-1);
            this.input.getFieldPrecision()[i] = Const.toInt((String)item.getText(4), (int)-1);
        }
        this.dispose();
    }
}

