/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseDataUpdater;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.client.stream.AdaptiveQueue;
import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedList;

public class NonBlockingInputStream
extends ClickHouseInputStream {
    private static final Logger log = LoggerFactory.getLogger(NonBlockingInputStream.class);
    private final AdaptiveQueue<byte[]> queue;
    private final int timeout;
    private byte[] buffer;
    private int position;

    public NonBlockingInputStream(AdaptiveQueue<byte[]> queue, int timeout, Runnable postCloseAction) {
        super(null, postCloseAction);
        this.queue = ClickHouseChecker.nonNull(queue, "Queue");
        this.timeout = timeout > 0 ? timeout : 0;
        this.buffer = null;
        this.position = 0;
    }

    @Override
    protected void ensureOpen() throws IOException {
        if (this.closed) {
            log.debug((Object)"Blocking input stream(queue: %d, buffer: %d) has been closed", this.queue.size(), this.buffer != null ? this.buffer.length - this.position : 0);
        }
        super.ensureOpen();
        if (this.buffer == null || this.buffer != ClickHouseByteBuffer.EMPTY_BYTES && this.position >= this.buffer.length) {
            this.updateBuffer();
        }
    }

    protected int updateBuffer() throws IOException {
        byte[] b;
        long startTime;
        AdaptiveQueue<byte[]> q = this.queue;
        long t = this.timeout;
        long l = startTime = t < 1L ? 0L : System.currentTimeMillis();
        while ((b = q.poll()) == null) {
            if (this.closed) {
                throw new IOException("Cannot operate on a closed input stream");
            }
            if (t <= 0L || System.currentTimeMillis() - startTime < t) continue;
            throw new IOException(ClickHouseUtils.format("Read timed out after %d ms", t));
        }
        this.buffer = b;
        this.position = 0;
        int remain = b.length;
        if (remain > 0 && this.copyTo != null) {
            this.copyTo.write(b, 0, remain);
        }
        return remain;
    }

    @Override
    public int available() throws IOException {
        if (this.closed || this.buffer == ClickHouseByteBuffer.EMPTY_BYTES) {
            return 0;
        }
        int remain = this.buffer != null ? this.buffer.length - this.position : 0;
        return remain > 0 ? remain : this.updateBuffer();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.buffer = ClickHouseByteBuffer.EMPTY_BYTES;
        super.close();
    }

    @Override
    public int peek() throws IOException {
        this.ensureOpen();
        return this.buffer != ClickHouseByteBuffer.EMPTY_BYTES ? 0xFF & this.buffer[this.position] : -1;
    }

    @Override
    public long pipe(ClickHouseOutputStream output) throws IOException {
        long count = 0L;
        if (output == null || output.isClosed()) {
            return count;
        }
        this.ensureOpen();
        byte[] b = this.buffer;
        int l = b.length;
        int p = this.position;
        int remain = l - p;
        if (remain > 0) {
            output.transferBytes(b, p, remain);
            count += (long)remain;
            while ((remain = this.updateBuffer()) > 0) {
                b = this.buffer;
                output.transferBytes(b, 0, remain);
                count += (long)remain;
            }
        }
        this.close();
        return count;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.buffer != ClickHouseByteBuffer.EMPTY_BYTES ? 0xFF & this.buffer[this.position++] : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Non-null byte array is required");
        }
        if (this.buffer == b) {
            throw new IllegalArgumentException("Please pass a different byte array instead of the same internal buffer for reading");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.ensureOpen();
        int remain = this.buffer.length - this.position;
        if (remain < 1) {
            return -1;
        }
        if (remain >= len) {
            System.arraycopy(this.buffer, this.position, b, off, len);
            this.position += len;
            return len;
        }
        System.arraycopy(this.buffer, this.position, b, off, remain);
        off += remain;
        len -= remain;
        int count = remain;
        while (len > 0 && (remain = this.updateBuffer()) > 0) {
            if (remain >= len) {
                System.arraycopy(this.buffer, this.position, b, off, len);
                this.position += len;
                return count + len;
            }
            System.arraycopy(this.buffer, this.position, b, off, remain);
            off += remain;
            len -= remain;
            count += remain;
        }
        return count;
    }

    @Override
    public ClickHouseByteBuffer readBuffer(int length) throws IOException {
        if (length < 1) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        int limit = this.buffer.length;
        if (this.position >= limit) {
            this.closeQuietly();
            throw new EOFException();
        }
        int newLimit = this.position + length;
        if (limit >= newLimit) {
            this.byteBuffer.update(this.buffer, this.position, length);
            this.position = newLimit;
        } else {
            this.byteBuffer.update(this.readBytes(length));
        }
        return this.byteBuffer;
    }

    @Override
    public ClickHouseByteBuffer readCustom(ClickHouseDataUpdater reader) throws IOException {
        if (reader == null) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int offset = this.position;
        int length = 0;
        boolean more = true;
        while (more) {
            int limit = this.buffer.length;
            int remain = limit - this.position;
            if (remain < 1) {
                this.closeQuietly();
                more = false;
                continue;
            }
            int read = reader.update(this.buffer, this.position, limit);
            if (read == -1) {
                length += remain;
                this.position = limit;
                list.add(this.buffer);
                if (this.updateBuffer() >= 1) continue;
                this.closeQuietly();
                more = false;
                continue;
            }
            if (read > 0) {
                length += read;
                this.position += read;
                list.add(this.buffer);
            }
            more = false;
        }
        return this.byteBuffer.update(list, offset, length);
    }

    @Override
    public byte readByte() throws IOException {
        this.ensureOpen();
        if (this.position >= this.buffer.length) {
            this.closeQuietly();
            throw new EOFException();
        }
        return this.buffer[this.position++];
    }

    @Override
    public byte[] readBytes(int length) throws IOException {
        if (length < 1) {
            return ClickHouseByteBuffer.EMPTY_BYTES;
        }
        this.ensureOpen();
        byte[] bytes = new byte[length];
        byte[] b = this.buffer;
        int count = 0;
        int l = this.buffer.length;
        int p = this.position;
        int remain = l - p;
        while (length > 0) {
            if (remain < 1) {
                this.closeQuietly();
                throw count == 0 ? new EOFException() : new IOException(ClickHouseUtils.format("Reached end of input stream after reading %d of %d bytes", count, bytes.length));
            }
            if (remain >= length) {
                System.arraycopy(b, p, bytes, count, length);
                this.position = p + length;
                count += length;
                length = 0;
                continue;
            }
            System.arraycopy(b, p, bytes, count, remain);
            count += remain;
            length -= remain;
            remain = this.updateBuffer();
            p = this.position;
            b = this.buffer;
        }
        return bytes;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (this.buffer == ClickHouseByteBuffer.EMPTY_BYTES) {
            return 0L;
        }
        if (n == Long.MAX_VALUE) {
            long counter = (long)this.buffer.length - (long)this.position;
            while (this.updateBuffer() > 0) {
                counter += (long)this.buffer.length;
            }
            return counter;
        }
        return super.skip(n);
    }
}

