/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.beam.runners.core.ReduceFn;
import org.apache.beam.runners.core.StateAccessor;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.state.ReadableState;
import org.apache.beam.sdk.state.ValueState;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class PaneInfoTracker {
    private TimerInternals timerInternals;
    @VisibleForTesting
    static final StateTag<ValueState<PaneInfo>> PANE_INFO_TAG = StateTags.makeSystemTagInternal(StateTags.value("pane", PaneInfo.PaneInfoCoder.INSTANCE));

    public PaneInfoTracker(TimerInternals timerInternals) {
        this.timerInternals = timerInternals;
    }

    public void clear(StateAccessor<?> state) {
        state.access(PANE_INFO_TAG).clear();
    }

    public void prefetchPaneInfo(ReduceFn.Context context) {
        context.state().access(PANE_INFO_TAG).readLater();
    }

    public ReadableState<PaneInfo> getNextPaneInfo(ReduceFn.Context context, final boolean isFinal) {
        final Object key = context.key();
        final ReadableState previousPaneFuture = (ReadableState)context.state().access(PANE_INFO_TAG);
        final Instant windowMaxTimestamp = context.window().maxTimestamp();
        return new ReadableState<PaneInfo>(){

            @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
            public ReadableState<PaneInfo> readLater() {
                previousPaneFuture.readLater();
                return this;
            }

            public PaneInfo read() {
                PaneInfo previousPane = (PaneInfo)previousPaneFuture.read();
                return PaneInfoTracker.this.describePane(key, windowMaxTimestamp, previousPane, isFinal);
            }
        };
    }

    public void storeCurrentPaneInfo(ReduceFn.Context context, PaneInfo currentPane) {
        context.state().access(PANE_INFO_TAG).write((Object)currentPane);
    }

    private <W> PaneInfo describePane(Object key, Instant windowMaxTimestamp, PaneInfo previousPane, boolean isFinal) {
        PaneInfo.Timing timing;
        boolean isEarlyForInput;
        boolean isFirst = previousPane == null;
        PaneInfo.Timing previousTiming = isFirst ? null : previousPane.getTiming();
        long index = isFirst ? 0L : previousPane.getIndex() + 1L;
        long nonSpeculativeIndex = isFirst ? 0L : previousPane.getNonSpeculativeIndex() + 1L;
        Instant outputWM = this.timerInternals.currentOutputWatermarkTime();
        Instant inputWM = this.timerInternals.currentInputWatermarkTime();
        boolean isLateForOutput = outputWM != null && windowMaxTimestamp.isBefore((ReadableInstant)outputWM);
        boolean onlyEarlyPanesSoFar = previousTiming == null || previousTiming == PaneInfo.Timing.EARLY;
        boolean bl = isEarlyForInput = !inputWM.isAfter((ReadableInstant)windowMaxTimestamp);
        if (isLateForOutput || !onlyEarlyPanesSoFar) {
            timing = PaneInfo.Timing.LATE;
        } else if (isEarlyForInput) {
            timing = PaneInfo.Timing.EARLY;
            nonSpeculativeIndex = -1L;
        } else {
            timing = PaneInfo.Timing.ON_TIME;
        }
        WindowTracing.debug((String)"describePane: {} pane (prev was {}) for key:{}; windowMaxTimestamp:{}; inputWatermark:{}; outputWatermark:{}; isLateForOutput:{}", (Object[])new Object[]{timing, previousTiming, key, windowMaxTimestamp, inputWM, outputWM, isLateForOutput});
        if (previousPane != null) {
            switch (previousTiming) {
                case EARLY: {
                    Preconditions.checkState((timing == PaneInfo.Timing.EARLY || timing == PaneInfo.Timing.ON_TIME || timing == PaneInfo.Timing.LATE ? 1 : 0) != 0, (String)"EARLY cannot transition to %s", (Object)timing);
                    break;
                }
                case ON_TIME: {
                    Preconditions.checkState((timing == PaneInfo.Timing.LATE ? 1 : 0) != 0, (String)"ON_TIME cannot transition to %s", (Object)timing);
                    break;
                }
                case LATE: {
                    Preconditions.checkState((timing == PaneInfo.Timing.LATE ? 1 : 0) != 0, (String)"LATE cannot transtion to %s", (Object)timing);
                    break;
                }
            }
            Preconditions.checkState((!previousPane.isLast() ? 1 : 0) != 0, (Object)"Last pane was not last after all.");
        }
        return PaneInfo.createPane((boolean)isFirst, (boolean)isFinal, (PaneInfo.Timing)timing, (long)index, (long)nonSpeculativeIndex);
    }
}

