/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.fn;

import com.google.api.services.bigquery.model.TableRow;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HopToBQTableRowFn
implements SerializableFunction<HopRow, TableRow> {
    private String counterName;
    private String rowMetaJson;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private transient IRowMeta rowMeta;
    private transient Counter initCounter;
    private transient Counter readCounter;
    private transient Counter outputCounter;
    private transient Counter errorCounter;
    private transient SimpleDateFormat simpleDateFormat;
    private static final Logger LOG = LoggerFactory.getLogger(HopToBQTableRowFn.class);

    public HopToBQTableRowFn(String counterName, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.counterName = counterName;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    public TableRow apply(HopRow inputRow) {
        try {
            if (this.rowMeta == null) {
                this.readCounter = Metrics.counter((String)"read", (String)this.counterName);
                this.outputCounter = Metrics.counter((String)"output", (String)this.counterName);
                this.errorCounter = Metrics.counter((String)"error", (String)this.counterName);
                BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
                this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                this.simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                Metrics.counter((String)"init", (String)this.counterName).inc();
            }
            this.readCounter.inc();
            TableRow tableRow = new TableRow();
            block10: for (int i = 0; i < this.rowMeta.size(); ++i) {
                Object valueData;
                IValueMeta valueMeta = this.rowMeta.getValueMeta(i);
                if (valueMeta.isNull(valueData = inputRow.getRow()[i])) continue;
                switch (valueMeta.getType()) {
                    case 2: {
                        tableRow.put(valueMeta.getName(), (Object)valueMeta.getString(valueData));
                        continue block10;
                    }
                    case 5: {
                        tableRow.put(valueMeta.getName(), (Object)valueMeta.getInteger(valueData));
                        continue block10;
                    }
                    case 3: {
                        Date date = valueMeta.getDate(valueData);
                        String formattedDate = this.simpleDateFormat.format(date);
                        tableRow.put(valueMeta.getName(), (Object)formattedDate);
                        continue block10;
                    }
                    case 4: {
                        tableRow.put(valueMeta.getName(), (Object)valueMeta.getBoolean(valueData));
                        continue block10;
                    }
                    case 1: {
                        tableRow.put(valueMeta.getName(), (Object)valueMeta.getNumber(valueData));
                        continue block10;
                    }
                    case 9: {
                        if (valueMeta.getNumber(valueData) != null) {
                            tableRow.put(valueMeta.getName(), (Object)Math.round(valueMeta.getNumber(valueData) / 1000.0));
                            continue block10;
                        }
                        tableRow.put(valueMeta.getName(), (Object)valueMeta.getNumber(valueData));
                        continue block10;
                    }
                    default: {
                        throw new RuntimeException("Data type conversion from Hop to BigQuery TableRow not supported yet: " + valueMeta.toString());
                    }
                }
            }
            this.outputCounter.inc();
            return tableRow;
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.info("Conversion error HopRow to BigQuery TableRow : " + e.getMessage());
            throw new RuntimeException("Error converting HopRow to BigQuery TableRow", e);
        }
    }
}

