/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kinesis;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.StringToHopRowFn;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KinesisRecordToHopRowFn
extends DoFn<KinesisRecord, HopRow> {
    private final String rowMetaJson;
    private final String transformName;
    private final List<String> transformPluginClasses;
    private final List<String> xpPluginClasses;
    private final String uniqueIdField;
    private final String partitionKeyField;
    private final String sequenceNumberField;
    private final String subSequenceNumberField;
    private final String shardIdField;
    private final String streamNameField;
    private static final Logger LOG = LoggerFactory.getLogger(StringToHopRowFn.class);
    private final Counter numErrors = Metrics.counter((String)"main", (String)"BeamKinesisRecordToHopRowFnErrors");
    private transient IRowMeta rowMeta;
    private transient Counter inputCounter;
    private transient Counter writtenCounter;

    public KinesisRecordToHopRowFn(String transformName, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses, String uniqueIdField, String partitionKeyField, String sequenceNumberField, String subSequenceNumberField, String shardIdField, String streamNameField) {
        this.transformName = transformName;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
        this.uniqueIdField = uniqueIdField;
        this.partitionKeyField = partitionKeyField;
        this.sequenceNumberField = sequenceNumberField;
        this.subSequenceNumberField = subSequenceNumberField;
        this.shardIdField = shardIdField;
        this.streamNameField = streamNameField;
    }

    @DoFn.Setup
    public void setUp() {
        try {
            this.inputCounter = Metrics.counter((String)"input", (String)this.transformName);
            this.writtenCounter = Metrics.counter((String)"written", (String)this.transformName);
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            this.rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
            Metrics.counter((String)"init", (String)this.transformName).inc();
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Error in setup of KinesisRecord to HopRow conversion function", (Throwable)e);
            throw new RuntimeException("Error in setup of KinesisRecord to HopRow conversion function", e);
        }
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext processContext) {
        try {
            KinesisRecord kinesisRecord = (KinesisRecord)processContext.element();
            assert (kinesisRecord != null);
            this.inputCounter.inc();
            Object[] outputRow = new Object[this.rowMeta.size()];
            int index = 0;
            if (StringUtils.isNotEmpty((String)this.uniqueIdField)) {
                String uniqueId = new String(kinesisRecord.getUniqueId(), StandardCharsets.UTF_8);
                outputRow[index++] = uniqueId;
            }
            String data = new String(kinesisRecord.getDataAsBytes(), StandardCharsets.UTF_8);
            outputRow[index++] = data;
            if (StringUtils.isNotEmpty((String)this.partitionKeyField)) {
                outputRow[index++] = kinesisRecord.getPartitionKey();
            }
            if (StringUtils.isNotEmpty((String)this.sequenceNumberField)) {
                outputRow[index++] = kinesisRecord.getSequenceNumber();
            }
            if (StringUtils.isNotEmpty((String)this.subSequenceNumberField)) {
                outputRow[index++] = kinesisRecord.getSubSequenceNumber();
            }
            if (StringUtils.isNotEmpty((String)this.shardIdField)) {
                outputRow[index++] = kinesisRecord.getShardId();
            }
            if (StringUtils.isNotEmpty((String)this.streamNameField)) {
                outputRow[index] = kinesisRecord.getStreamName();
            }
            processContext.output((Object)new HopRow(outputRow));
            this.writtenCounter.inc();
        }
        catch (Exception e) {
            this.numErrors.inc();
            LOG.error("Error in KinesisRecord to HopRow conversion function", (Throwable)e);
            throw new RuntimeException("Error in KinesisRecord to HopRow conversion function", e);
        }
    }
}

