/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.lang.reflect.Constructor;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.types.DataType;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag;

public class EncoderFactory {
    private static final Constructor<StaticInvoke> STATIC_INVOKE_CONSTRUCTOR = StaticInvoke.class.getConstructors()[0];

    static <T> ExpressionEncoder<T> create(Expression serializer, Expression deserializer, Class<? super T> clazz) {
        return new ExpressionEncoder(serializer, deserializer, ClassTag.apply(clazz));
    }

    static Expression invokeIfNotNull(Class<?> cls, String fun, DataType type, Expression ... args) {
        try {
            switch (STATIC_INVOKE_CONSTRUCTOR.getParameterCount()) {
                case 6: {
                    return (Expression)STATIC_INVOKE_CONSTRUCTOR.newInstance(cls, type, fun, new WrappedArray.ofRef((Object[])args), true, true);
                }
                case 8: {
                    return (Expression)STATIC_INVOKE_CONSTRUCTOR.newInstance(cls, type, fun, new WrappedArray.ofRef((Object[])args), Nil$.MODULE$, true, true, true);
                }
            }
            throw new RuntimeException("Unsupported version of Spark");
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

