/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.transforms.SerializableFunction;

class TableRowWriter<T>
extends BigQueryRowWriter<T> {
    private static final Coder<TableRow> CODER = TableRowJsonCoder.of();
    private static final byte[] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
    private final SerializableFunction<T, TableRow> toRow;

    TableRowWriter(String basename, SerializableFunction<T, TableRow> toRow) throws Exception {
        super(basename, "text/plain");
        this.toRow = toRow;
    }

    @Override
    void write(T value) throws Exception {
        TableRow tableRow = (TableRow)this.toRow.apply(value);
        CODER.encode((Object)tableRow, this.getOutputStream(), Coder.Context.OUTER);
        this.getOutputStream().write(NEWLINE);
    }
}

