/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.propertyinput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IEnumHasCode;
import org.apache.hop.metadata.api.IEnumHasCodeAndDescription;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.propertyinput.PropertyInput;
import org.apache.hop.pipeline.transforms.propertyinput.PropertyInputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;

@Transform(id="PropertyInput", image="propertyinput.svg", name="i18n::PropertyInput.Name", description="i18n::PropertyInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::PropertyInputMeta.keyword"}, documentationUrl="/pipeline/transforms/propertyinput.html")
public class PropertyInputMeta
extends BaseTransformMeta<PropertyInput, PropertyInputData> {
    private static final Class<?> PKG = PropertyInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String YES = "Y";
    @HopMetadataProperty(key="encoding")
    private String encoding;
    @HopMetadataProperty(key="file_type", storeWithCode=true)
    private FileType fileType;
    @HopMetadataProperty(key="include")
    private boolean includingFilename;
    @HopMetadataProperty(key="resetrownumber")
    private boolean resettingRowNumber;
    @HopMetadataProperty(key="resolvevaluevariable")
    private boolean resolvingValueVariable;
    @HopMetadataProperty(key="include_field")
    private String filenameField;
    @HopMetadataProperty(key="rownum")
    private boolean includeRowNumber;
    @HopMetadataProperty(key="rownum_field")
    private String rowNumberField;
    @HopMetadataProperty(key="limit")
    private long rowLimit;
    @HopMetadataProperty(key="filefield")
    private boolean fileField;
    @HopMetadataProperty(key="isaddresult")
    private boolean addResult;
    @HopMetadataProperty(key="filename_Field")
    private String dynamicFilenameField;
    @HopMetadataProperty(key="ini_section")
    private boolean includeIniSection;
    @HopMetadataProperty(key="ini_section_field")
    private String iniSectionField;
    @HopMetadataProperty(key="section")
    private String section;
    @HopMetadataProperty(key="shortFileFieldName")
    private String shortFileFieldName;
    @HopMetadataProperty(key="pathFieldName")
    private String pathFieldName;
    @HopMetadataProperty(key="hiddenFieldName")
    private String hiddenFieldName;
    @HopMetadataProperty(key="lastModificationTimeFieldName")
    private String lastModificationTimeFieldName;
    @HopMetadataProperty(key="uriNameFieldName")
    private String uriNameFieldName;
    @HopMetadataProperty(key="rootUriNameFieldName")
    private String rootUriNameFieldName;
    @HopMetadataProperty(key="extensionFieldName")
    private String extensionFieldName;
    @HopMetadataProperty(key="sizeFieldName")
    private String sizeFieldName;
    @HopMetadataProperty(key="file")
    private List<PIFile> files = new ArrayList<PIFile>();
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<PIField> inputFields = new ArrayList<PIField>();

    public PropertyInputMeta() {
    }

    public PropertyInputMeta(PropertyInputMeta m) {
        this();
        this.encoding = m.encoding;
        this.fileType = m.fileType;
        this.includingFilename = m.includingFilename;
        this.resettingRowNumber = m.resettingRowNumber;
        this.resolvingValueVariable = m.resolvingValueVariable;
        this.filenameField = m.filenameField;
        this.includeRowNumber = m.includeRowNumber;
        this.rowNumberField = m.rowNumberField;
        this.rowLimit = m.rowLimit;
        this.fileField = m.fileField;
        this.addResult = m.addResult;
        this.dynamicFilenameField = m.dynamicFilenameField;
        this.includeIniSection = m.includeIniSection;
        this.iniSectionField = m.iniSectionField;
        this.section = m.section;
        this.shortFileFieldName = m.shortFileFieldName;
        this.pathFieldName = m.pathFieldName;
        this.hiddenFieldName = m.hiddenFieldName;
        this.lastModificationTimeFieldName = m.lastModificationTimeFieldName;
        this.uriNameFieldName = m.uriNameFieldName;
        this.rootUriNameFieldName = m.rootUriNameFieldName;
        this.extensionFieldName = m.extensionFieldName;
        this.sizeFieldName = m.sizeFieldName;
        m.files.forEach(f -> this.files.add(new PIFile((PIFile)f)));
        m.inputFields.forEach(f -> this.inputFields.add(new PIField((PIField)f)));
    }

    public PropertyInputMeta clone() {
        return new PropertyInputMeta(this);
    }

    public void setDefault() {
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.sizeFieldName = null;
        this.fileType = FileType.PROPERTY;
        this.section = "";
        this.encoding = DEFAULT_ENCODING;
        this.includeIniSection = false;
        this.iniSectionField = "";
        this.resolvingValueVariable = false;
        this.addResult = true;
        this.fileField = false;
        this.includingFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.dynamicFilenameField = "";
        this.rowLimit = 0L;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v;
        IValueMeta v2;
        for (PIField field : this.inputFields) {
            try {
                v2 = field.createValueMeta();
                v2.setOrigin(name);
                if (v2.getType() == 0) {
                    v2.setTrimType(2);
                }
                r.addValueMeta(v2);
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        String realFilenameField = variables.resolve(this.filenameField);
        if (this.includingFilename && !Utils.isEmpty((CharSequence)realFilenameField)) {
            ValueMetaString v3 = new ValueMetaString(realFilenameField);
            v3.setLength(500);
            v3.setPrecision(-1);
            v3.setOrigin(name);
            r.addValueMeta((IValueMeta)v3);
        }
        String realRowNumberField = variables.resolve(this.rowNumberField);
        if (this.includeRowNumber && !Utils.isEmpty((CharSequence)realRowNumberField)) {
            v2 = new ValueMetaInteger(realRowNumberField);
            v2.setLength(10, 0);
            v2.setOrigin(name);
            r.addValueMeta(v2);
        }
        String realSectionField = variables.resolve(this.iniSectionField);
        if (this.includeIniSection && !Utils.isEmpty((CharSequence)realSectionField)) {
            v = new ValueMetaString(realSectionField);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getShortFileFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getShortFileFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getExtensionFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getExtensionFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getPathFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getPathFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getSizeFieldName())) {
            v = new ValueMetaInteger(variables.resolve(this.getSizeFieldName()));
            v.setOrigin(name);
            v.setLength(9);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getHiddenFieldName())) {
            v = new ValueMetaBoolean(variables.resolve(this.getHiddenFieldName()));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getLastModificationTimeFieldName())) {
            v = new ValueMetaDate(variables.resolve(this.getLastModificationTimeFieldName()));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getUriNameFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getUriNameFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.getRootUriNameFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getRootUriNameFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public String[] getFilesNames() {
        String[] names = new String[this.files.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.files.get(i).getName();
        }
        return names;
    }

    public String[] getFilesMasks() {
        String[] masks = new String[this.files.size()];
        for (int i = 0; i < masks.length; ++i) {
            masks[i] = this.files.get(i).getMask();
        }
        return masks;
    }

    public String[] getFilesExcludeMasks() {
        String[] masks = new String[this.files.size()];
        for (int i = 0; i < masks.length; ++i) {
            masks[i] = this.files.get(i).getExcludeMask();
        }
        return masks;
    }

    public String[] getFilesRequired() {
        String[] masks = new String[this.files.size()];
        for (int i = 0; i < masks.length; ++i) {
            masks[i] = this.files.get(i).isRequired() ? YES : "N";
        }
        return masks;
    }

    public FileInputList getFiles(IVariables variables) {
        boolean[] subDirectories = new boolean[this.files.size()];
        return FileInputList.createFileList((IVariables)variables, (String[])this.getFilesNames(), (String[])this.getFilesMasks(), (String[])this.getFilesExcludeMasks(), (String[])this.getFilesRequired(), (boolean[])subDirectories);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        FileInputList fileInputList = this.getFiles(variables);
        if (fileInputList == null || fileInputList.getFiles().size() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.NoFiles", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.fileField) {
                for (PIFile file : this.files) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(file.getName()));
                    file.setName(iResourceNaming.nameResource(fileObject, variables, Utils.isEmpty((CharSequence)file.getMask())));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public void setFileType(FileType fileType) {
        this.fileType = fileType;
    }

    public boolean isIncludingFilename() {
        return this.includingFilename;
    }

    public void setIncludingFilename(boolean includingFilename) {
        this.includingFilename = includingFilename;
    }

    public boolean isResettingRowNumber() {
        return this.resettingRowNumber;
    }

    public void setResettingRowNumber(boolean resettingRowNumber) {
        this.resettingRowNumber = resettingRowNumber;
    }

    public boolean isResolvingValueVariable() {
        return this.resolvingValueVariable;
    }

    public void setResolvingValueVariable(boolean resolvingValueVariable) {
        this.resolvingValueVariable = resolvingValueVariable;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean isIncludeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public boolean isFileField() {
        return this.fileField;
    }

    public void setFileField(boolean fileField) {
        this.fileField = fileField;
    }

    public boolean isAddResult() {
        return this.addResult;
    }

    public void setAddResult(boolean addResult) {
        this.addResult = addResult;
    }

    public String getDynamicFilenameField() {
        return this.dynamicFilenameField;
    }

    public void setDynamicFilenameField(String dynamicFilenameField) {
        this.dynamicFilenameField = dynamicFilenameField;
    }

    public boolean isIncludeIniSection() {
        return this.includeIniSection;
    }

    public void setIncludeIniSection(boolean includeIniSection) {
        this.includeIniSection = includeIniSection;
    }

    public String getIniSectionField() {
        return this.iniSectionField;
    }

    public void setIniSectionField(String iniSectionField) {
        this.iniSectionField = iniSectionField;
    }

    public String getSection() {
        return this.section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public String getShortFileFieldName() {
        return this.shortFileFieldName;
    }

    public void setShortFileFieldName(String shortFileFieldName) {
        this.shortFileFieldName = shortFileFieldName;
    }

    public String getPathFieldName() {
        return this.pathFieldName;
    }

    public void setPathFieldName(String pathFieldName) {
        this.pathFieldName = pathFieldName;
    }

    public String getHiddenFieldName() {
        return this.hiddenFieldName;
    }

    public void setHiddenFieldName(String hiddenFieldName) {
        this.hiddenFieldName = hiddenFieldName;
    }

    public String getLastModificationTimeFieldName() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationTimeFieldName(String lastModificationTimeFieldName) {
        this.lastModificationTimeFieldName = lastModificationTimeFieldName;
    }

    public String getUriNameFieldName() {
        return this.uriNameFieldName;
    }

    public void setUriNameFieldName(String uriNameFieldName) {
        this.uriNameFieldName = uriNameFieldName;
    }

    public String getRootUriNameFieldName() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriNameFieldName(String rootUriNameFieldName) {
        this.rootUriNameFieldName = rootUriNameFieldName;
    }

    public String getExtensionFieldName() {
        return this.extensionFieldName;
    }

    public void setExtensionFieldName(String extensionFieldName) {
        this.extensionFieldName = extensionFieldName;
    }

    public String getSizeFieldName() {
        return this.sizeFieldName;
    }

    public void setSizeFieldName(String sizeFieldName) {
        this.sizeFieldName = sizeFieldName;
    }

    public List<PIFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<PIFile> files) {
        this.files = files;
    }

    public List<PIField> getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(List<PIField> inputFields) {
        this.inputFields = inputFields;
    }

    public static enum FileType implements IEnumHasCodeAndDescription
    {
        PROPERTY("property", BaseMessages.getString(PKG, (String)"PropertyInputMeta.FileType.Property", (String[])new String[0])),
        INI("ini", BaseMessages.getString(PKG, (String)"PropertyInputMeta.FileType.Ini", (String[])new String[0]));

        private final String code;
        private final String description;

        private FileType(String code, String description) {
            this.code = code;
            this.description = description;
        }

        public static String[] getDescriptions() {
            return IEnumHasCodeAndDescription.getDescriptions(FileType.class);
        }

        public static FileType lookupDescription(String description) {
            return (FileType)IEnumHasCodeAndDescription.lookupDescription(FileType.class, (String)description, (IEnumHasCodeAndDescription)PROPERTY);
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static final class PIField {
        @HopMetadataProperty(key="name")
        private String name;
        @HopMetadataProperty(key="column", storeWithCode=true)
        private KeyValue column;
        @HopMetadataProperty(key="type")
        private String type;
        @HopMetadataProperty(key="format")
        private String format;
        @HopMetadataProperty(key="length")
        private int length;
        @HopMetadataProperty(key="precision")
        private int precision;
        @HopMetadataProperty(key="currency")
        private String currency;
        @HopMetadataProperty(key="decimal")
        private String decimal;
        @HopMetadataProperty(key="group")
        private String group;
        @HopMetadataProperty(key="trim_type", storeWithCode=true)
        private IValueMeta.TrimType trimType = IValueMeta.TrimType.NONE;
        @HopMetadataProperty(key="repeat")
        private boolean repeating;

        public PIField() {
        }

        public PIField(PIField f) {
            this();
            this.name = f.name;
            this.column = f.column;
            this.type = f.type;
            this.format = f.format;
            this.length = f.length;
            this.precision = f.precision;
            this.currency = f.currency;
            this.decimal = f.decimal;
            this.group = f.group;
            this.trimType = f.trimType;
            this.repeating = f.repeating;
        }

        public PIField(String name) {
            this();
            this.name = name;
        }

        public int getHopType() {
            return ValueMetaFactory.getIdForValueMeta((String)this.type);
        }

        public IValueMeta createValueMeta() throws HopPluginException {
            IValueMeta v = ValueMetaFactory.createValueMeta((String)this.name, (int)this.getHopType());
            v.setConversionMask(this.format);
            v.setLength(this.length, this.precision);
            v.setCurrencySymbol(this.currency);
            v.setDecimalSymbol(this.decimal);
            v.setGroupingSymbol(this.group);
            v.setTrimType(this.trimType.getType());
            return v;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public KeyValue getColumn() {
            return this.column;
        }

        public void setColumn(KeyValue column) {
            this.column = column;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public int getPrecision() {
            return this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public String getDecimal() {
            return this.decimal;
        }

        public void setDecimal(String decimal) {
            this.decimal = decimal;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public IValueMeta.TrimType getTrimType() {
            return this.trimType;
        }

        public void setTrimType(IValueMeta.TrimType trimType) {
            this.trimType = trimType;
        }

        public boolean isRepeating() {
            return this.repeating;
        }

        public void setRepeating(boolean repeating) {
            this.repeating = repeating;
        }
    }

    public static final class PIFile {
        @HopMetadataProperty(key="name")
        private String name;
        @HopMetadataProperty(key="filemask")
        private String mask;
        @HopMetadataProperty(key="exclude_filemask")
        private String excludeMask;
        @HopMetadataProperty(key="file_required")
        private boolean required;
        @HopMetadataProperty(key="include_subfolders")
        private boolean includingSubFolders;

        public PIFile() {
        }

        public PIFile(PIFile f) {
            this();
            this.name = f.name;
            this.mask = f.mask;
            this.excludeMask = f.excludeMask;
            this.required = f.required;
            this.includingSubFolders = f.includingSubFolders;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMask() {
            return this.mask;
        }

        public void setMask(String mask) {
            this.mask = mask;
        }

        public String getExcludeMask() {
            return this.excludeMask;
        }

        public void setExcludeMask(String excludeMask) {
            this.excludeMask = excludeMask;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean isIncludingSubFolders() {
            return this.includingSubFolders;
        }

        public void setIncludingSubFolders(boolean includingSubFolders) {
            this.includingSubFolders = includingSubFolders;
        }
    }

    public static enum KeyValue implements IEnumHasCode
    {
        KEY("key"),
        VALUE("value");

        private final String code;

        private KeyValue(String code) {
            this.code = code;
        }

        public static String[] getCodes() {
            return IEnumHasCode.getCodes(KeyValue.class);
        }

        public static KeyValue lookupCode(String code) {
            return (KeyValue)IEnumHasCode.lookupCode(KeyValue.class, (String)code, (IEnumHasCode)KEY);
        }

        public String getCode() {
            return this.code;
        }
    }
}

