/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.profiling;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="execution-data-profile", name="Execution Data Profile", description="Describes how transform output data is profiled", image="ui/images/analyzer.svg", documentationUrl="/metadata-types/execution-data-profile.html")
public class ExecutionDataProfile
extends HopMetadataBase
implements IHopMetadata,
Cloneable {
    public static final String GUI_PLUGIN_ELEMENT_PARENT_ID = "ExecutionDataSamplerParent";
    @HopMetadataProperty
    private String description;
    @HopMetadataProperty(groupKey="samplers", key="sampler")
    private List<IExecutionDataSampler> samplers;

    public ExecutionDataProfile() {
        this.samplers = new ArrayList<IExecutionDataSampler>();
    }

    public ExecutionDataProfile(String name) {
        super(name);
        this.samplers = new ArrayList<IExecutionDataSampler>();
    }

    public ExecutionDataProfile(String name, String description, List<IExecutionDataSampler> samplers) {
        super(name);
        this.description = description;
        this.samplers = samplers;
    }

    public ExecutionDataProfile(ExecutionDataProfile profile) {
        this(profile.name);
        this.description = profile.description;
        for (IExecutionDataSampler sampler : profile.samplers) {
            this.samplers.add(sampler.clone());
        }
    }

    protected ExecutionDataProfile clone() {
        return new ExecutionDataProfile(this);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<IExecutionDataSampler> getSamplers() {
        return this.samplers;
    }

    public void setSamplers(List<IExecutionDataSampler> samplers) {
        this.samplers = samplers;
    }
}

