/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.history.AuditEvent;
import org.apache.hop.history.AuditState;
import org.apache.hop.history.IAuditManager;
import org.apache.hop.history.local.LocalAuditManager;

public class AuditManager {
    private static AuditManager instance;
    private IAuditManager activeAuditManager = new LocalAuditManager();

    private AuditManager() {
    }

    public static final AuditManager getInstance() {
        if (instance == null) {
            instance = new AuditManager();
        }
        return instance;
    }

    public static final IAuditManager getActive() {
        return AuditManager.getInstance().getActiveAuditManager();
    }

    public IAuditManager getActiveAuditManager() {
        return this.activeAuditManager;
    }

    public void setActiveAuditManager(IAuditManager activeAuditManager) {
        this.activeAuditManager = activeAuditManager;
    }

    public static final void registerEvent(String group, String type, String name, String operation) throws HopException {
        AuditManager.getActive().storeEvent(new AuditEvent(group, type, name, operation, new Date()));
    }

    public static final List<AuditEvent> findEvents(String group, String type, String operation, int maxNrEvents, boolean unique) throws HopException {
        List<AuditEvent> events = AuditManager.getActive().findEvents(group, type, unique);
        HashSet<String> names = new HashSet<String>();
        if (operation == null) {
            return events;
        }
        ArrayList<AuditEvent> operationEvents = new ArrayList<AuditEvent>();
        for (AuditEvent event : events) {
            if (!event.getOperation().equalsIgnoreCase(operation)) continue;
            if (unique) {
                if (!names.contains(event.getName())) {
                    operationEvents.add(event);
                    names.add(event.getName());
                }
            } else {
                operationEvents.add(event);
            }
            if (maxNrEvents <= 0 || operationEvents.size() < maxNrEvents) continue;
            break;
        }
        return operationEvents;
    }

    public static final void storeState(ILogChannel log, String group, String type, String name, Map<String, Object> stateProperties) {
        AuditState auditState = new AuditState(name, stateProperties);
        try {
            AuditManager.getActive().storeState(group, type, auditState);
        }
        catch (Exception e) {
            log.logError("Error writing audit state of type " + type, (Throwable)e);
        }
    }

    public static final AuditState retrieveState(ILogChannel log, String group, String type, String name) {
        try {
            return AuditManager.getActive().retrieveState(group, type, name);
        }
        catch (Exception e) {
            log.logError("Error retrieving state of type " + type);
            return null;
        }
    }

    public static final void clearEvents() throws HopException {
        AuditManager.getActive().clearEvents();
    }
}

