/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.action;

import java.util.HashMap;
import java.util.Map;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.debug.action.ActionDebugLevel;
import org.apache.hop.debug.action.ActionDebugLevelDialog;
import org.apache.hop.debug.util.DebugLevelUtil;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.context.HopGuiWorkflowActionContext;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;

@GuiPlugin
public class ActionDebugGuiPlugin {
    @GuiContextAction(id="workflow-graph-action-11001-clear-logging", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Delete, name="Clear Custom Logging", tooltip="Clear custom log settings ", image="ui/images/debug.svg", category="Logging", categoryOrder="7")
    public void clearCustomActionLogging(HopGuiWorkflowActionContext context) {
        WorkflowMeta workflowMeta = context.getWorkflowMeta();
        ActionMeta action = context.getActionMeta();
        Map attributesMap = workflowMeta.getAttributesMap();
        Map debugGroupAttributesMap = (Map)attributesMap.get("debug_plugin");
        DebugLevelUtil.clearDebugLevel(debugGroupAttributesMap, action.toString());
        workflowMeta.setChanged();
    }

    @GuiContextAction(id="workflow-graph-action-11000-clear-logging", parentId="HopGuiWorkflowActionContext", type=GuiActionType.Modify, name="Edit Custom Logging", tooltip="Edit the custom log settings for this action", image="ui/images/debug.svg", category="Logging", categoryOrder="7")
    public void applyCustomActionLogging(HopGuiWorkflowActionContext context) {
        HopGui hopGui = HopGui.getInstance();
        try {
            ActionDebugLevelDialog dialog;
            ActionDebugLevel debugLevel;
            WorkflowMeta workflowMeta = context.getWorkflowMeta();
            ActionMeta action = context.getActionMeta();
            Map attributesMap = workflowMeta.getAttributesMap();
            HashMap<String, String> debugGroupAttributesMap = (HashMap<String, String>)attributesMap.get("debug_plugin");
            if (debugGroupAttributesMap == null) {
                debugGroupAttributesMap = new HashMap<String, String>();
                attributesMap.put("debug_plugin", debugGroupAttributesMap);
            }
            if ((debugLevel = DebugLevelUtil.getActionDebugLevel(debugGroupAttributesMap, action.toString())) == null) {
                debugLevel = new ActionDebugLevel();
            }
            if ((dialog = new ActionDebugLevelDialog(hopGui.getShell(), debugLevel)).open()) {
                DebugLevelUtil.storeActionDebugLevel(debugGroupAttributesMap, action.toString(), debugLevel);
            }
            workflowMeta.setChanged();
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), "Error", "Error changing action log settings", e);
        }
    }
}

