/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.beam.sdk.schemas.utils.AutoValueUtils;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class AutoValueSchema
extends GetterBasedSchemaProvider {
    private static void validateFieldNumbers(List<FieldValueTypeInformation> types) {
        for (int i = 0; i < types.size(); ++i) {
            FieldValueTypeInformation type = types.get(i);
            Integer number = type.getNumber();
            if (number == null) {
                throw new RuntimeException("Unexpected null number for " + type.getName());
            }
            Preconditions.checkState((number == i ? 1 : 0) != 0, (Object)("Expected field number " + i + " for field + " + type.getName() + " instead got " + number));
        }
    }

    @Override
    public List<FieldValueGetter> fieldValueGetters(Class<?> targetClass, Schema schema) {
        return JavaBeanUtils.getGetters(targetClass, schema, AbstractGetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
    }

    @Override
    public List<FieldValueTypeInformation> fieldValueTypeInformations(Class<?> targetClass, Schema schema) {
        return JavaBeanUtils.getFieldTypes(targetClass, schema, AbstractGetterTypeSupplier.INSTANCE);
    }

    @Override
    public SchemaUserTypeCreator schemaTypeCreator(Class<?> targetClass, Schema schema) {
        Method annotated = ReflectUtils.getAnnotatedCreateMethod(targetClass);
        if (annotated != null) {
            return JavaBeanUtils.getStaticCreator(targetClass, annotated, schema, AbstractGetterTypeSupplier.INSTANCE, new ByteBuddyUtils.DefaultTypeConversionsFactory());
        }
        SchemaUserTypeCreator creatorFactory = AutoValueUtils.getBuilderCreator(targetClass, schema, AbstractGetterTypeSupplier.INSTANCE);
        if (creatorFactory != null) {
            return creatorFactory;
        }
        creatorFactory = AutoValueUtils.getConstructorCreator(targetClass, schema, AbstractGetterTypeSupplier.INSTANCE);
        if (creatorFactory == null) {
            throw new RuntimeException("Could not find a way to create AutoValue class " + targetClass);
        }
        return creatorFactory;
    }

    @Override
    public <T> @Nullable Schema schemaFor(TypeDescriptor<T> typeDescriptor) {
        return JavaBeanUtils.schemaFromJavaBeanClass(typeDescriptor.getRawType(), AbstractGetterTypeSupplier.INSTANCE);
    }

    @VisibleForTesting
    public static class AbstractGetterTypeSupplier
    implements FieldValueTypeSupplier {
        public static final AbstractGetterTypeSupplier INSTANCE = new AbstractGetterTypeSupplier();

        @Override
        public List<FieldValueTypeInformation> get(Class<?> clazz) {
            Class targetClass = AutoValueUtils.getBaseAutoValueClass(clazz);
            List methods = ReflectUtils.getMethods(targetClass).stream().filter(ReflectUtils::isGetter).filter(m -> Modifier.isAbstract(m.getModifiers())).filter(m -> !Modifier.isPrivate(m.getModifiers())).filter(m -> !Modifier.isProtected(m.getModifiers())).filter(m -> !m.isAnnotationPresent(SchemaIgnore.class)).collect(Collectors.toList());
            ArrayList types = Lists.newArrayListWithCapacity((int)methods.size());
            for (int i = 0; i < methods.size(); ++i) {
                types.add(FieldValueTypeInformation.forGetter((Method)methods.get(i), i));
            }
            types.sort(Comparator.comparing(FieldValueTypeInformation::getNumber));
            AutoValueSchema.validateFieldNumbers(types);
            return types;
        }
    }
}

