/*
 * Decompiled with CFR 0.152.
 */
package org.kie.memorycompiler.resources;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.memorycompiler.resources.ResourceReader;

public class MemoryResourceReader
implements ResourceReader {
    private Map<String, byte[]> resources = new ConcurrentHashMap<String, byte[]>();
    private Set<String> modifiedResourcesSinceLastMark;

    @Override
    public boolean isAvailable(String pResourceName) {
        if (this.resources == null) {
            return false;
        }
        return this.resources.containsKey(pResourceName);
    }

    public void add(String pResourceName, byte[] pContent) {
        this.resources.put(pResourceName, pContent);
        if (this.modifiedResourcesSinceLastMark != null) {
            this.modifiedResourcesSinceLastMark.add(pResourceName);
        }
    }

    public void remove(String pResourceName) {
        if (this.resources != null) {
            this.resources.remove(pResourceName);
        }
    }

    @Override
    public void mark() {
        this.modifiedResourcesSinceLastMark = new HashSet<String>();
    }

    @Override
    public Collection<String> getModifiedResourcesSinceLastMark() {
        return this.modifiedResourcesSinceLastMark;
    }

    @Override
    public byte[] getBytes(String pResourceName) {
        return this.resources.get(pResourceName);
    }

    @Override
    public Collection<String> getFileNames() {
        if (this.resources == null) {
            return Collections.emptySet();
        }
        return this.resources.keySet();
    }

    public String[] list() {
        if (this.resources == null) {
            return new String[0];
        }
        return this.resources.keySet().toArray(new String[this.resources.size()]);
    }
}

