/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ConversionMaps;
import com.ibm.as400.access.SystemProperties;
import com.ibm.as400.access.Trace;
import java.util.Locale;

public class ExecutionEnvironment {
    private ExecutionEnvironment() {
    }

    public static int getBestGuessAS400Ccsid() {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Getting best guess CCSID.");
        }
        try {
            String string = SystemProperties.getProperty("com.ibm.as400.access.AS400.fallbackCCSID");
            if (string != null) {
                Trace.log(1, "Fallback CCSID specified:", string);
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    Trace.log(2, "Ignoring invalid fallback CCSID value.", (Throwable)numberFormatException);
                }
            } else {
                Trace.log(1, "Fallback CCSID not specified, using Locale.");
            }
            String string2 = Locale.getDefault().toString();
            if (Trace.isTraceOn()) {
                Trace.log(1, "Default Locale: " + string2);
            }
            while (true) {
                if ((string = (String)ConversionMaps.localeCcsidMap_.get(string2)) != null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "Best guess for Locale: " + string2 + ", CCSID: " + string);
                    }
                    return Integer.parseInt(string);
                }
                string2 = string2.substring(0, string2.lastIndexOf(95));
            }
        }
        catch (Exception exception) {
            Trace.log(1, "Exception taking best guess CCSID, default to 37:", (Throwable)exception);
            return 37;
        }
    }

    public static int getCcsid() {
        return 13488;
    }

    static int getCcsid(String string) {
        return Integer.parseInt((String)ConversionMaps.encodingCcsid_.get(string));
    }

    static String getEncoding(int n) {
        return (String)ConversionMaps.ccsidEncoding_.get(String.valueOf(n));
    }

    public static String getNlv(Locale locale) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Getting NLV.");
        }
        try {
            String string = locale.toString();
            if (Trace.isTraceOn()) {
                Trace.log(1, "NLV Locale: " + string);
            }
            while (true) {
                String string2;
                if ((string2 = (String)ConversionMaps.localeNlvMap_.get(string)) != null) {
                    if (Trace.isTraceOn()) {
                        Trace.log(1, "NLV for Locale: " + string + ", NLV: " + string2);
                    }
                    return string2;
                }
                string = string.substring(0, string.lastIndexOf(95));
            }
        }
        catch (Exception exception) {
            Trace.log(1, "Exception getting NLV, default to 2924:", (Throwable)exception);
            return "2924";
        }
    }
}

