/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.NLSTableDownload;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class GenerateConverterTable {
    private static final String copyright = "Copyright (C) 1997-2016 International Business Machines Corporation and others.";
    private static final int MAX_SURROGATE_LENGTH = 2000;
    private static final int MAX_TO_EBCDIC_LENGTH = 20000;
    static AS400 sys = null;
    static Connection connection_ = null;
    static boolean compress_ = true;
    static boolean codePointPerLine_ = false;
    static boolean ascii_ = false;
    static boolean bidi_ = false;
    static boolean showOffsets_ = false;
    static boolean useJdbc_ = false;
    private static final char repSig = '\uffff';
    private static final char cic_ = '\uffff';
    private static final char rampSig = '\ufffe';
    private static final char ric_ = '\ufffe';
    private static final char hbSig = '\u0000';
    private static final char pad = '\u0000';
    static int numRepeats;
    static int numRamps;
    static int hbRepeats;
    static int charRepeats;
    static /* synthetic */ Class class$com$ibm$as400$access$Copyright;

    public static void main(String[] stringArray) {
        if (stringArray.length < 4) {
            System.out.println("Usage: java com.ibm.as400.access.GenerateConverterTable system uid pwd [-nocompress] [-ascii] [-bidi] [-showOffsets] [-codePointPerLine] [-useJdbc] ccsid [ccsid2] [ccsid3] [ccsid4] ...");
            System.exit(0);
        }
        try {
            sys = new AS400(stringArray[0], stringArray[1], stringArray[2]);
            sys.connectService(6);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
        int n = 3;
        if (stringArray[n].equals("-nocompress")) {
            compress_ = false;
            ++n;
        }
        if (stringArray[n].equals("-ascii")) {
            ascii_ = true;
            ++n;
        }
        if (stringArray[n].equals("-bidi")) {
            bidi_ = true;
            ++n;
        }
        if (stringArray[n].equals("-showOffsets")) {
            showOffsets_ = true;
            ++n;
        }
        if (stringArray[n].equals("-codePointPerLine")) {
            codePointPerLine_ = true;
            ++n;
        }
        if (stringArray[n].equals("-useJdbc")) {
            useJdbc_ = true;
            try {
                Class.forName("com.ibm.as400.access.AS400JDBCDriver");
                connection_ = DriverManager.getConnection("jdbc:as400:" + stringArray[0], stringArray[1], stringArray[2]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(0);
            }
            ++n;
        }
        for (int i = n; i < stringArray.length; ++i) {
            GenerateConverterTable.go(new Integer(stringArray[i]));
        }
    }

    static String formattedChar(char c) {
        int n = 0xFFFF & c;
        String string = "\\u";
        if (n < 16) {
            string = string + "0";
        }
        if (n < 256) {
            string = string + "0";
        }
        if (n < 4096) {
            string = string + "0";
        }
        string = string + Integer.toHexString(n).toUpperCase();
        return string;
    }

    static void go(int n) {
        Object object;
        int n2;
        int n3;
        int n4;
        Object object2;
        Object object3 = new char[]{};
        char[] cArray = new char[]{};
        Object object4 = null;
        boolean bl = false;
        int n5 = 2;
        int n6 = n;
        try {
            int n7;
            Object object5;
            block81: {
                if (useJdbc_) {
                    if (ConvTable.isMixedCCSID(n6)) {
                        GenerateConverterTable.go(1000000 + n);
                        GenerateConverterTable.go(2000000 + n);
                        return;
                    }
                    Class.forName("com.ibm.as400.access.AS400JDBCDriver");
                    try {
                        bl = n > 2000000 ? true : (n > 1000000 ? false : GenerateConverterTable.jdbcIsDBCS(connection_, n));
                        if (bl) {
                            object3 = GenerateConverterTable.jdbcToUnicodeDBCS(connection_, n);
                            cArray = GenerateConverterTable.jdbcToEbcdicDBCS(connection_, n);
                            break block81;
                        }
                        object3 = GenerateConverterTable.jdbcToUnicode(connection_, n);
                        cArray = GenerateConverterTable.jdbcToEbcdic(connection_, n);
                    }
                    catch (Exception exception) {
                        System.out.println("Error downloading table using JDBC ");
                        exception.printStackTrace(System.out);
                        System.exit(1);
                    }
                } else {
                    AS400ImplRemote aS400ImplRemote = (AS400ImplRemote)sys.getImpl();
                    object2 = new NLSTableDownload(aS400ImplRemote);
                    ((NLSTableDownload)object2).connect();
                    if (n == 1089) {
                        System.out.println("Special case for ccsid 1089.");
                        System.out.println("Retrieving " + n + "->61952 table...");
                        object3 = ((NLSTableDownload)object2).download(n, 61952, 1);
                    } else if (n == 61175) {
                        System.out.println("Special case for ccsid 61175.");
                        System.out.println("Retrieving 1026->13488 table and adjusting...");
                        object3 = ((NLSTableDownload)object2).download(1026, 13488, 1);
                        object3[252] = object3[127];
                        object3[127] = 34;
                    } else if (n == 1376) {
                        object3 = null;
                    } else if (n == 1371) {
                        object3 = null;
                        n5 = 3;
                    } else {
                        System.out.println("Retrieving " + n + "->13488 table...");
                        object3 = ((NLSTableDownload)object2).download(n, 13488, 1);
                    }
                    if (object3 == null || ((char[])object3).length == 0) {
                        object5 = "";
                        object5 = object3 == null ? "tableToUnicode is null" : "tableToUnicode.length is 0";
                        if (n == 1175) {
                            System.out.println("Aborting since CCSD 1175 failed to download");
                            throw new Exception("Aborting since CCSD 1175 failed to download");
                        }
                        System.out.println(n + " must be double-byte because download failed (" + (String)object5 + "). Performing secondary retrieve of " + n + "->1200 table...");
                        bl = true;
                        ((NLSTableDownload)object2).disconnect();
                        ((NLSTableDownload)object2).connect();
                        object3 = ((NLSTableDownload)object2).download(n, 1200, n5);
                    }
                    ((NLSTableDownload)object2).disconnect();
                    ((NLSTableDownload)object2).connect();
                    if (n == 1089) {
                        System.out.println("Special case for ccsid 1089.");
                        System.out.println("Retrieving 61952->" + n + " table...");
                        cArray = ((NLSTableDownload)object2).download(61952, n, 2);
                    } else {
                        System.out.println("Retrieving 1200->" + n + " table...");
                        cArray = ((NLSTableDownload)object2).download(1200, n, 2);
                    }
                }
            }
            System.out.println("  Size: " + ((char[])object3).length);
            if (((char[])object3).length > 65536) {
                System.out.println("Size is > 65536.  Fixing table");
                int n8 = 0;
                object5 = new char[65536];
                n4 = 0;
                n3 = 0;
                for (int i = 0; n8 < ((char[])object3).length && i < 65536; ++i) {
                    n2 = 0xFFFF & object3[n8];
                    while (n2 >= 65024 && n2 <= 65039) {
                        n2 = 0xFFFF & object3[++n8];
                    }
                    if (i > 60586 && i <= 60624) {
                        System.out.println("Next=0x" + Integer.toHexString(i) + " to=" + Integer.toHexString(n2));
                    }
                    n7 = 0;
                    if (n8 + 1 < ((char[])object3).length) {
                        n7 = 0xFFFF & object3[n8 + 1];
                    }
                    if (n2 >= 55296 && n2 <= 57343 || n7 >= 65024 && n7 <= 65039 || n7 == 12442 && n2 != 12441 || n2 != 65533 && n7 == 768 || n2 != 4093 && n2 != 768 && n7 == 769 || n2 == 741 && n7 == 745 || n2 == 745 && n7 == 741) {
                        object5[i] = 55296;
                        n4 = i;
                        n3 = 55296;
                        if (object4 == null) {
                            object4 = new char[65536][];
                        }
                        char[] cArray2 = new char[2];
                        object4[i] = cArray2;
                        cArray2[0] = (char)(0xFFFF & object3[n8]);
                        cArray2[1] = (char)(0xFFFF & object3[n8 + 1]);
                        n8 += 2;
                        continue;
                    }
                    object5[i] = (char)n2;
                    if (n2 != 65533) {
                        n4 = i;
                        n3 = n2;
                    }
                    ++n8;
                }
                object3 = object5;
            }
            System.out.println("  Size: " + cArray.length);
            if (n5 == 3) {
                int n9;
                char[] cArray3 = new char[65536];
                object2 = new byte[cArray.length * 2];
                for (n9 = 0; n9 < cArray.length; ++n9) {
                    object2[2 * n9] = (byte)(0xFF & cArray[n9] >> 8);
                    object2[2 * n9 + 1] = (byte)(cArray[n9] & 0xFF);
                }
                n9 = 1;
                n4 = 0;
                for (n3 = 0; n3 < ((Object)object2).length; ++n3) {
                    n2 = 0xFF & object2[n3];
                    while (n3 > 15 && n3 < ((Object)object2).length && (n2 == 14 || n2 == 15)) {
                        if (n2 == 14) {
                            n9 = 0;
                            ++n3;
                        } else {
                            n9 = 1;
                            ++n3;
                        }
                        if (n3 >= ((Object)object2).length) continue;
                        n2 = 0xFF & object2[n3];
                    }
                    if (n3 >= ((Object)object2).length) continue;
                    if (n9 != 0) {
                        if (n4 >= cArray3.length) continue;
                        cArray3[n4] = (char)n2;
                        ++n4;
                        continue;
                    }
                    if (++n3 >= ((Object)object2).length) continue;
                    n7 = 0xFF & object2[n3];
                    if (n4 >= cArray3.length) continue;
                    if (n4 == 1073) {
                        cArray3[n4] = (char)((n2 << 8) + n7);
                        ++n4;
                        continue;
                    }
                    cArray3[n4] = (char)((n2 << 8) + n7);
                    ++n4;
                }
                while (n4 < cArray3.length) {
                    cArray3[n4] = 65278;
                    ++n4;
                }
                cArray = cArray3;
            }
            sys.disconnectAllServices();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        if (n == 290) {
            object3[225] = 8364;
            char c = cArray[4182];
            cArray[4182] = c = (char)(0xE100 | c & 0xFF);
        }
        GenerateConverterTable.verifyRoundTrip(object3, cArray, bl, n);
        System.out.println("****************************************");
        System.out.println("Verify round 2 ");
        System.out.println("****************************************");
        GenerateConverterTable.verifyRoundTrip(object3, cArray, bl, n);
        if (bl && compress_) {
            System.out.println("Compressing " + n + "->13488 conversion table...");
            char[] cArray4 = GenerateConverterTable.compress(object3);
            System.out.println("Old compression length: " + cArray4.length + " characters.");
            object2 = GenerateConverterTable.compressBetter(object3);
            System.out.println("New compression length: " + ((Object)object2).length + " characters.");
            if (((Object)object2).length > cArray4.length) {
                System.out.println("WARNING: New algorithm WORSE than old algorithm!");
            }
            System.out.println("Verifying compressed table...");
            cArray4 = GenerateConverterTable.decompressBetter((char[])object2);
            if (cArray4.length != ((char[])object3).length) {
                int n10;
                System.out.println("Verification failed, lengths not equal: " + cArray4.length + " != " + ((char[])object3).length);
                for (n10 = 0; n10 < cArray4.length && cArray4[n10] == object3[n10]; ++n10) {
                }
                System.out.println("First mismatch at index " + n10 + ": " + cArray4[n10] + " != " + object3[n10]);
            } else {
                boolean bl2 = false;
                for (n4 = 0; n4 < cArray4.length; ++n4) {
                    if (cArray4[n4] == object3[n4]) continue;
                    bl2 = true;
                    System.out.println(n4 + ": " + Integer.toHexString(cArray4[n4]) + " != " + Integer.toHexString(object3[n4]));
                }
                if (bl2) {
                    System.out.println("Mismatches found in table.");
                } else {
                    object3 = object2;
                    System.out.println("Table verified.");
                }
            }
        }
        int n11 = n;
        if (n5 == 3) {
            n11 = n + 1100000;
            System.out.println("Create file using " + n11 + " since MIXED CCSID ");
        }
        object2 = new StringBuffer();
        try {
            object = "ConvTable" + n11 + ".java";
            FileWriter fileWriter = new FileWriter((String)object);
            GenerateConverterTable.writeHeader(fileWriter, n11, sys.getSystemName());
            if (ascii_) {
                fileWriter.write("class ConvTable" + n11 + " extends ConvTableAsciiMap\n{\n");
            } else if (bidi_) {
                fileWriter.write("class ConvTable" + n11 + " extends ConvTableBidiMap\n{\n");
            } else if (bl) {
                fileWriter.write("class ConvTable" + n11 + " extends ConvTableDoubleMap\n{\n");
            } else {
                fileWriter.write("class ConvTable" + n11 + " extends ConvTableSingleMap\n{\n");
            }
            fileWriter.write("  private static char[] toUnicodeArray_;  \n");
            fileWriter.write("  private static final String copyright = \"Copyright (C) 1997-2016 International Business Machines Corporation and others.\";\n");
            fileWriter.write("  // toUnicode_ length is " + ((char[])object3).length + "\n");
            fileWriter.write("  private static final String toUnicode_ = \n");
            System.out.print("Writing table for conversion from " + n + " to 13488... to " + (String)object + "\n");
            GenerateConverterTable.writeTable(fileWriter, object3, 0, ((char[])object3).length);
            fileWriter.write("\n");
            fileWriter.write("\n");
            n3 = 0;
            if (object4 != null) {
                char[] cArray5;
                char[] cArray6;
                int n12;
                fileWriter.write("\n");
                for (n2 = 0; n2 < ((char[][])object4).length; ++n2) {
                    char[] cArray7 = object4[n2];
                    if (cArray7 == null) continue;
                    ++n3;
                }
                n2 = 0;
                char[][] cArrayArray = new char[n3][];
                for (n12 = 0; n12 < ((char[][])object4).length; ++n12) {
                    cArray6 = object4[n12];
                    if (cArray6 == null) continue;
                    cArray5 = new char[]{(char)n12, cArray6[0], cArray6[1]};
                    cArrayArray[n2] = cArray5;
                    ++n2;
                }
                fileWriter.write("  // Number of surrogateMappings is " + n3 + "\n");
                if (n3 < 2000) {
                    fileWriter.write("  private static final char[][] toUnicodeSurrogateMappings = { \n");
                    System.out.print("Writing surrogate table for conversion from " + n + " to 13488... to " + (String)object + "\n");
                    for (n12 = 0; n12 < cArrayArray.length; ++n12) {
                        cArray6 = object4[n12];
                        if (cArray6 == null) continue;
                        fileWriter.write("{'" + GenerateConverterTable.formattedChar(cArray6[0]) + "','" + GenerateConverterTable.formattedChar(cArray6[1]) + "','" + GenerateConverterTable.formattedChar(cArray6[2]) + "'},\n");
                    }
                    fileWriter.write("};\n");
                    fileWriter.write("\n");
                    fileWriter.write("\n");
                } else {
                    fileWriter.write("  private static char[][] toUnicodeSurrogateMappings = new char[" + n3 + "][];\n");
                    for (n12 = 0; n12 < n3; n12 += 2000) {
                        fileWriter.write("  private static void initToUnicodeSurrogateMappings" + n12 + "() { \n");
                        fileWriter.write("  char[][] toUnicodeSurrogateMappingsPiece = {\n");
                        for (int i = 0; i < 2000 && i + n12 < n3; ++i) {
                            cArray5 = cArrayArray[n12 + i];
                            if (cArray5 == null) continue;
                            fileWriter.write("    {'" + GenerateConverterTable.formattedChar(cArray5[0]) + "','" + GenerateConverterTable.formattedChar(cArray5[1]) + "','" + GenerateConverterTable.formattedChar(cArray5[2]) + "'},\n");
                        }
                        fileWriter.write("  };\n");
                        fileWriter.write("    for (int j = 0; j < toUnicodeSurrogateMappingsPiece.length ; j++) {\n");
                        fileWriter.write("      toUnicodeSurrogateMappings[" + n12 + "+j]= new char[3];\n");
                        fileWriter.write("      toUnicodeSurrogateMappings[" + n12 + "+j][0] = toUnicodeSurrogateMappingsPiece[j][0];\n");
                        fileWriter.write("      toUnicodeSurrogateMappings[" + n12 + "+j][1] = toUnicodeSurrogateMappingsPiece[j][1];\n");
                        fileWriter.write("      toUnicodeSurrogateMappings[" + n12 + "+j][2] = toUnicodeSurrogateMappingsPiece[j][2];\n");
                        fileWriter.write("    }\n");
                        fileWriter.write("  }\n");
                        fileWriter.write("\n");
                        ((StringBuffer)object2).append("   initToUnicodeSurrogateMappings" + n12 + "();\n");
                    }
                }
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (compress_) {
            System.out.println("Compressing 13488->" + n + " conversion table...");
            object = GenerateConverterTable.compress(cArray);
            System.out.println("Old compression length: " + ((Object)object).length + " characters.");
            char[] cArray8 = GenerateConverterTable.compressBetter(cArray);
            System.out.println("New compression length: " + cArray8.length + " characters.");
            if (cArray8.length > ((Object)object).length) {
                System.out.println("WARNING: New algorithm WORSE than old algorithm!");
            }
            System.out.println("Verifying compressed table...");
            object = GenerateConverterTable.decompressBetter(cArray8);
            if (((Object)object).length != cArray.length) {
                System.out.println("Verification failed, lengths not equal: " + ((Object)object).length + " != " + cArray.length);
                for (n3 = 0; n3 < ((Object)object).length && object[n3] == cArray[n3]; ++n3) {
                }
                System.out.println("First mismatch at index " + n3 + ": " + (int)object[n3] + " != " + cArray[n3]);
                cArray = cArray8;
            } else {
                n3 = 0;
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    if (object[n2] == cArray[n2]) continue;
                    n3 = 1;
                    System.out.println(n2 + ": " + Integer.toHexString((int)object[n2]) + " != " + Integer.toHexString(cArray[n2]));
                }
                if (n3 != 0) {
                    System.out.println("Mismatches found in table.");
                } else {
                    cArray = cArray8;
                    System.out.println("Table verified.");
                }
            }
        }
        try {
            object = "ConvTable" + n11 + ".java";
            FileWriter fileWriter = new FileWriter((String)object, true);
            System.out.print("Writing table for conversion from 13488 to " + n + "... to " + (String)object + "\n");
            fileWriter.write("  private static char[] fromUnicodeArray_; \n");
            fileWriter.write("  // fromUnicode length = " + cArray.length + "\n");
            if (cArray.length < 20000) {
                fileWriter.write("  private static final String fromUnicode_ = \n");
                GenerateConverterTable.writeTable(fileWriter, cArray, 0, cArray.length);
                fileWriter.write("\n");
            } else {
                n3 = cArray.length / 4;
                fileWriter.write("  private static final String fromUnicode0_ = \n");
                GenerateConverterTable.writeTable(fileWriter, cArray, 0, n3);
                fileWriter.write("\n");
                fileWriter.write("  private static final String fromUnicode1_ = \n");
                GenerateConverterTable.writeTable(fileWriter, cArray, n3, n3);
                fileWriter.write("\n");
                fileWriter.write("  private static final String fromUnicode2_ = \n");
                GenerateConverterTable.writeTable(fileWriter, cArray, 2 * n3, n3);
                fileWriter.write("\n");
                fileWriter.write("  private static final String fromUnicode3_ = \n");
                GenerateConverterTable.writeTable(fileWriter, cArray, 3 * n3, cArray.length - 3 * n3);
                fileWriter.write("\n");
            }
            fileWriter.write("  static {\n");
            fileWriter.write("    toUnicodeArray_ = toUnicode_.toCharArray();\n");
            if (cArray.length < 20000) {
                fileWriter.write("    fromUnicodeArray_ = fromUnicode_.toCharArray();\n");
            } else {
                fileWriter.write("    StringBuffer sb = new StringBuffer(); \n");
                fileWriter.write("    sb.append(fromUnicode0_); \n");
                fileWriter.write("    sb.append(fromUnicode1_); \n");
                fileWriter.write("    sb.append(fromUnicode2_); \n");
                fileWriter.write("    sb.append(fromUnicode3_); \n");
                fileWriter.write("    fromUnicodeArray_ = sb.toString().toCharArray();\n");
            }
            fileWriter.write(((StringBuffer)object2).toString());
            fileWriter.write("  }\n");
            fileWriter.write("\n  ConvTable" + n11 + "()\n  {\n");
            fileWriter.write("    super(" + n11 + ", ");
            fileWriter.write("toUnicodeArray_, ");
            if (object4 != null) {
                fileWriter.write("fromUnicodeArray_,");
                fileWriter.write("toUnicodeSurrogateMappings);\n");
            } else {
                fileWriter.write("fromUnicodeArray_);\n");
            }
            fileWriter.write("  }\n\n");
            fileWriter.write("\n  ConvTable" + n11 + "(int ccsid)\n  {\n");
            fileWriter.write("    super(ccsid, ");
            fileWriter.write("toUnicodeArray_, ");
            if (object4 != null) {
                fileWriter.write("fromUnicodeArray_,");
                fileWriter.write("toUnicodeSurrogateMappings);\n");
            } else {
                fileWriter.write("fromUnicodeArray_);\n");
            }
            fileWriter.write("  }\n}\n");
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.print("Done.\n");
    }

    private static void writeTable(FileWriter fileWriter, char[] cArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2; i += 16) {
            if (showOffsets_) {
                fileWriter.write("/* " + Integer.toHexString(i) + " */ \"");
            } else {
                fileWriter.write("    \"");
            }
            for (int j = 0; j < 16 && i + j < n + n2; ++j) {
                char c = cArray[i + j];
                if (c == '\b') {
                    fileWriter.write("\\b");
                } else if (c == '\t') {
                    fileWriter.write("\\t");
                } else if (c == '\n') {
                    fileWriter.write("\\n");
                } else if (c == '\f') {
                    fileWriter.write("\\f");
                } else if (c == '\r') {
                    fileWriter.write("\\r");
                } else if (c == '\"') {
                    fileWriter.write("\\\"");
                } else if (c == '\'') {
                    fileWriter.write("\\'");
                } else if (c == '\\') {
                    fileWriter.write("\\\\");
                } else {
                    String string = "\\u";
                    if (c < '\u0010') {
                        string = string + "0";
                    }
                    if (c < '\u0100') {
                        string = string + "0";
                    }
                    if (c < '\u1000') {
                        string = string + "0";
                    }
                    string = string + Integer.toHexString(c).toUpperCase();
                    fileWriter.write(string);
                }
                if (!codePointPerLine_ || j >= 15) continue;
                if (showOffsets_) {
                    fileWriter.write("\" +\n/* " + Integer.toHexString(i + j + 1) + " */ \"");
                    continue;
                }
                fileWriter.write("\" +\n    \"");
            }
            if (i + 16 < n + n2) {
                fileWriter.write("\" +\n");
                continue;
            }
            fileWriter.write("\";\n");
        }
    }

    private static boolean verifyRoundTrip(char[] cArray, char[] cArray2, boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string = "X";
        if (bl) {
            string = "GX";
        }
        if (!bl && (n6 = 0xFFFF & cArray2[13]) >> 8 != 63) {
            System.out.println("Fixing sub char in tableToEbcdic == sub was 0x" + Integer.toHexString(n6 >> 8));
            n6 = 0x3F00 | 0xFF & n6;
            cArray2[13] = (char)n6;
        }
        System.out.println("Checking round trip for CCSID " + n);
        n6 = 1;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (n5 = 0; n5 < cArray.length; ++n5) {
            n4 = 0xFFFF & cArray[n5];
            if (n4 == 65533 || n4 == 55296) continue;
            if (bl) {
                n3 = 0xFFFF & cArray2[n4];
            } else {
                n2 = 0xFFFF & cArray2[n4 / 2];
                n3 = n4 % 2 == 0 ? n2 >> 8 : n2 & 0xFF;
            }
            if (n5 == n3) continue;
            if (n4 != 26 && (n3 == 65278 || n3 == 63)) {
                stringBuffer.append("Fixing up EBCDIC RoundTrip Failure " + string + "'" + Integer.toHexString(n5) + "'" + " -> UX'" + Integer.toHexString(n4) + "'" + " -> " + string + "'" + Integer.toHexString(n3) + "'\n");
                if (bl) {
                    cArray2[n4] = (char)n5;
                } else {
                    n2 = 0xFFFF & cArray2[n4 / 2];
                    n2 = n4 % 2 == 0 ? n5 << 8 | n2 & 0xFF : n2 & 0xFF00 | n5;
                    cArray2[n4 / 2] = (char)n2;
                }
                n6 = 0;
                continue;
            }
            n2 = 0;
            try {
                n2 = 0xFFFF & cArray[n3];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("ERROR.. ArrayIndexOutOfBounds");
                System.out.println("ebcdicChar=0x" + Integer.toHexString(n3));
                System.out.println("i=" + n5);
                System.out.println("unicodeChar=0x" + Integer.toHexString(n4));
                throw arrayIndexOutOfBoundsException;
            }
            if (n2 == n4) {
                stringBuffer2.append("Secondary EBCDIC mapping " + string + "'" + Integer.toHexString(n5) + "'" + " -> UX'" + Integer.toHexString(n4) + "'" + " -> " + string + "'" + Integer.toHexString(n3) + "'" + " -> UX'" + Integer.toHexString(n2) + "'\n");
                continue;
            }
            stringBuffer3.append("EBCDIC RoundTrip Failure2 " + string + "'" + Integer.toHexString(n5) + "'" + " -> UX'" + Integer.toHexString(n4) + "'" + " -> " + string + "'" + Integer.toHexString(n3) + "'" + " -> UX'" + Integer.toHexString(n2) + "'\n");
            n6 = 0;
        }
        System.out.println(stringBuffer2);
        System.out.println(stringBuffer);
        System.out.println(stringBuffer3);
        stringBuffer.setLength(0);
        stringBuffer2.setLength(0);
        stringBuffer3.setLength(0);
        for (n5 = 0; n5 < cArray2.length; ++n5) {
            if (bl) {
                n4 = 0xFFFF & cArray2[n5];
            } else {
                n3 = 0xFFFF & cArray2[n5 / 2];
                n4 = n5 % 2 == 0 ? n3 >> 8 : n3 & 0xFF;
            }
            if (n4 == 65278 || n4 == 63 || n5 == (n3 = 0xFFFF & cArray[n4])) continue;
            if (n3 == 65533) {
                stringBuffer.append("Unicode RoundTrip Failure UX'" + Integer.toHexString(n5) + "'" + " -> " + string + "'" + Integer.toHexString(n4) + "'" + " -> UX'" + Integer.toHexString(n3) + "'\n");
                n6 = 0;
                continue;
            }
            if (bl) {
                n2 = 0xFFFF & cArray2[n3];
            } else {
                int n7 = 0xFFFF & cArray2[n3 / 2];
                n2 = n3 % 2 == 0 ? n7 >> 8 : n7 & 0xFF;
            }
            if (n2 == n4) {
                stringBuffer2.append("Secondary Unicode mapping UX'" + Integer.toHexString(n5) + "'" + " -> " + string + "'" + Integer.toHexString(n4) + "'" + " -> UX'" + Integer.toHexString(n3) + "'" + " -> " + string + "'" + Integer.toHexString(n2) + "'\n");
                continue;
            }
            stringBuffer3.append("Unicode RoundTrip Failure2 UX'" + Integer.toHexString(n5) + "'" + " -> " + string + "'" + Integer.toHexString(n4) + "'" + " -> UX'" + Integer.toHexString(n3) + "'" + " -> " + string + "'" + Integer.toHexString(n2) + "'\n");
            n6 = 0;
        }
        System.out.println(stringBuffer2);
        System.out.println(stringBuffer);
        System.out.println(stringBuffer3);
        return n6 != 0;
    }

    static int repeatCheck(char[] cArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < cArray.length && cArray[n2] == cArray[n2 - 1]; ++n2) {
        }
        return n2 - n;
    }

    static final int rampCheck(char[] cArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < cArray.length && cArray[n2] == cArray[n2 - 1] + '\u0001'; ++n2) {
        }
        return n2 - n;
    }

    static int hbCheck(char[] cArray, int n) {
        int n2;
        for (n2 = n + 1; n2 < cArray.length; ++n2) {
            if (GenerateConverterTable.repeatCheck(cArray, n2) > 6) {
                return n2 - n;
            }
            if (GenerateConverterTable.rampCheck(cArray, n2) > 6) {
                return n2 - n;
            }
            if ((cArray[n2] & 0xFF00) == (cArray[n2 - 1] & 0xFF00)) continue;
            return n2 - n;
        }
        return n2 - n;
    }

    static char[] compressBetter(char[] cArray) {
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            int n = GenerateConverterTable.repeatCheck(cArray, i);
            if (n > 3) {
                ++numRepeats;
                stringBuffer.append('\uffff');
                stringBuffer.append((char)n);
                stringBuffer.append(cArray[i]);
                i += n - 1;
                continue;
            }
            int n2 = GenerateConverterTable.rampCheck(cArray, i);
            if (n2 > 3) {
                ++numRamps;
                stringBuffer.append('\ufffe');
                stringBuffer.append((char)n2);
                stringBuffer.append(cArray[i]);
                i += n2 - 1;
                continue;
            }
            int n3 = GenerateConverterTable.hbCheck(cArray, i);
            if (--n3 >= 6) {
                ++hbRepeats;
                stringBuffer.append('\u0000');
                if (n3 % 2 == 1) {
                    --n3;
                }
                stringBuffer.append((char)(n3 / 2));
                stringBuffer.append(cArray[i++]);
                for (int j = 0; j < n3 / 2; ++j) {
                    char c = (char)((0xFF & cArray[i + j * 2]) * 256 + (0xFF & cArray[i + j * 2 + 1]));
                    stringBuffer.append(c);
                }
                i = i + n3 - 1;
                continue;
            }
            stringBuffer.append(cArray[i]);
            ++charRepeats;
            if (cArray[i] != '\uffff' && cArray[i] != '\ufffe' && cArray[i] != '\u0000') continue;
            stringBuffer.append('\u0000');
        }
        System.out.println("Compression stats: " + numRepeats + " repeats, " + numRamps + " ramps, " + hbRepeats + " highbytes, " + charRepeats + " regular.");
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        return stringBuffer.toString().toCharArray();
    }

    static char[] decompressBetter(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            int n;
            char c;
            int n2;
            if (cArray[i] == '\uffff') {
                if (cArray[i + 1] == '\u0000') {
                    stringBuffer.append('\uffff');
                    ++i;
                    continue;
                }
                ++numRepeats;
                n2 = cArray[i + 1];
                c = cArray[i + 2];
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append(c);
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\ufffe') {
                if (cArray[i + 1] == '\u0000') {
                    stringBuffer.append('\ufffe');
                    ++i;
                    continue;
                }
                ++numRamps;
                n2 = cArray[i + 1];
                c = cArray[i + 2];
                for (n = 0; n < n2; ++n) {
                    stringBuffer.append((char)(n + c));
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\u0000') {
                if (cArray[i + 1] == '\u0000') {
                    stringBuffer.append('\u0000');
                    ++i;
                    continue;
                }
                ++hbRepeats;
                n2 = 0xFFFF & cArray[++i];
                c = cArray[++i];
                n = (char)(0xFF00 & c);
                stringBuffer.append(c);
                ++i;
                for (int j = 0; j < n2; ++j) {
                    char c2 = cArray[i + j];
                    char c3 = (char)(n + ((0xFF00 & c2) >>> 8));
                    char c4 = (char)(n + (0xFF & c2));
                    stringBuffer.append(c3);
                    stringBuffer.append(c4);
                }
                i = i + n2 - 1;
                continue;
            }
            stringBuffer.append(cArray[i]);
            ++charRepeats;
        }
        System.out.println("Decompression stats: " + numRepeats + " repeats, " + numRamps + " ramps, " + hbRepeats + " highbytes, " + charRepeats + " regular.");
        numRepeats = 0;
        numRamps = 0;
        hbRepeats = 0;
        charRepeats = 0;
        return stringBuffer.toString().toCharArray();
    }

    static char[] compress(char[] cArray) {
        int n;
        if (cArray.length < 3) {
            return cArray;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c = cArray[0];
        char c2 = cArray[1];
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 2; n < cArray.length; ++n) {
            if (!bl && !bl2) {
                if (cArray[n] == c2 && cArray[n] == c) {
                    bl = true;
                    stringBuffer.append('\uffff');
                    stringBuffer.append(c);
                    n2 = 3;
                } else if (cArray[n] == c2 + '\u0001' && cArray[n] == c + 2) {
                    bl2 = true;
                    stringBuffer.append('\ufffe');
                    stringBuffer.append(c);
                } else if (c == '\uffff') {
                    stringBuffer.append('\uffff');
                } else if (c == '\ufffe') {
                    stringBuffer.append('\ufffe');
                } else {
                    stringBuffer.append(c);
                }
                c = c2;
                c2 = cArray[n];
                continue;
            }
            if (bl) {
                if (cArray[n] == c2 && cArray[n] == c) {
                    ++n2;
                    c = c2;
                    c2 = cArray[n];
                    continue;
                }
                bl = false;
                int n3 = n2;
                if (n2 == 8) {
                    n3 = 8;
                } else if (n2 == 9) {
                    n3 = 9;
                } else if (n2 == 10) {
                    n3 = 10;
                } else if (n2 == 12) {
                    n3 = 12;
                } else if (n2 == 13) {
                    n3 = 13;
                } else if (n2 == 34) {
                    n3 = 34;
                } else if (n2 == 39) {
                    n3 = 39;
                } else if (n2 == 92) {
                    n3 = 92;
                }
                stringBuffer.append((char)n3);
                c = cArray[n++];
                c2 = cArray[n];
                continue;
            }
            if (cArray[n] == c2 + '\u0001' && cArray[n] == c + 2) {
                c = c2;
                c2 = cArray[n];
                continue;
            }
            bl2 = false;
            stringBuffer.append(c2);
            c = cArray[n++];
            c2 = cArray[n];
        }
        if (bl) {
            n = (char)n2;
            if (n2 == 8) {
                n = 8;
            } else if (n2 == 9) {
                n = 9;
            } else if (n2 == 10) {
                n = 10;
            } else if (n2 == 12) {
                n = 12;
            } else if (n2 == 13) {
                n = 13;
            } else if (n2 == 34) {
                n = 34;
            } else if (n2 == 39) {
                n = 39;
            } else if (n2 == 92) {
                n = 92;
            }
            stringBuffer.append((char)n);
        }
        if (bl2) {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString().toCharArray();
    }

    static void writeHeader(FileWriter fileWriter, int n, String string) throws Exception {
        int n2 = string.indexOf(46);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        Date date = new Date();
        Class clazz = class$com$ibm$as400$access$Copyright == null ? (class$com$ibm$as400$access$Copyright = GenerateConverterTable.class$("com.ibm.as400.access.Copyright")) : class$com$ibm$as400$access$Copyright;
        Field field = clazz.getField("version");
        String string2 = (String)field.get(null);
        fileWriter.write("///////////////////////////////////////////////////////////////////////////////\n");
        fileWriter.write("//\n");
        fileWriter.write("// JTOpen (IBM Toolbox for Java - OSS version)\n");
        fileWriter.write("//\n");
        fileWriter.write("// Filename:  ConvTable" + n + ".java\n");
        fileWriter.write("//\n");
        fileWriter.write("// The source code contained herein is licensed under the IBM Public License\n");
        fileWriter.write("// Version 1.0, which has been approved by the Open Source Initiative.\n");
        fileWriter.write("// Copyright (C) 1997-2016 International Business Machines Corporation and\n");
        fileWriter.write("// others.  All rights reserved.\n");
        fileWriter.write("//\n");
        fileWriter.write("// Generated " + date + " from " + string + "\n");
        StringBuffer stringBuffer = new StringBuffer();
        if (!compress_) {
            stringBuffer.append(" -nocompress");
        }
        if (ascii_) {
            stringBuffer.append(" -ascii");
        }
        if (bidi_) {
            stringBuffer.append(" -bidi");
        }
        if (showOffsets_) {
            stringBuffer.append(" -showOffsets");
        }
        if (codePointPerLine_) {
            stringBuffer.append(" -codePointPerLine");
        }
        if (useJdbc_) {
            stringBuffer.append(" -useJdbc");
        }
        if (stringBuffer.length() > 0) {
            fileWriter.write("// Generation Options:" + stringBuffer.toString() + "\n");
        }
        fileWriter.write("// Using " + string2 + "\n");
        fileWriter.write("///////////////////////////////////////////////////////////////////////////////\n\n");
        fileWriter.write("package com.ibm.as400.access;\n\n");
    }

    static boolean jdbcIsDBCS(Connection connection, int n) throws SQLException {
        boolean bl;
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("CREATE TABLE QTEMP.GENERATE" + n + "(C1 VARCHAR(80) CCSID " + n + ")");
            bl = false;
        }
        catch (SQLException sQLException) {
            int n2 = sQLException.getErrorCode();
            if (n2 == -189) {
                statement.executeUpdate("CREATE TABLE QTEMP.GENERATE" + n + "(C1 VARGRAPHIC(80) CCSID " + n + ")");
                bl = true;
            }
            throw sQLException;
        }
        statement.close();
        return bl;
    }

    private static char[] jdbcToEbcdic(Connection connection, int n) throws Exception {
        int n2;
        if (n > 1000000) {
            n -= 1000000;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select cast(CAST(CAST(? AS DBCLOB(1M) CCSID 1200) AS CLOB(1M) CCSID " + n + ") as BLOB(1M)) from sysibm.sysdummy1");
        char[] cArray = new char[65536];
        for (n2 = 0; n2 < 55296; ++n2) {
            cArray[n2] = (char)n2;
        }
        for (n2 = 55296; n2 < 63744; ++n2) {
            cArray[n2] = 26;
        }
        for (n2 = 63744; n2 < 65536; ++n2) {
            cArray[n2] = (char)n2;
        }
        Clob clob = ((AS400JDBCConnection)connection).createClob();
        clob.setString(1L, new String(cArray));
        preparedStatement.setClob(1, clob);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        byte[] byArray = resultSet.getBytes(1);
        if (byArray.length != 65536) {
            byArray = GenerateConverterTable.removeDoubleByteEbcdic(byArray);
        }
        resultSet.close();
        preparedStatement.close();
        char[] cArray2 = new char[byArray.length / 2];
        for (int i = 0; i < byArray.length; i += 2) {
            cArray2[i / 2] = (char)(byArray[i] << 8 | 0xFF & byArray[i + 1]);
        }
        return cArray2;
    }

    private static byte[] removeDoubleByteEbcdic(byte[] byArray) throws Exception {
        int n;
        byte[] byArray2 = new byte[65536];
        for (n = 0; n < 64; ++n) {
            byArray2[n] = byArray[n];
        }
        n = 64;
        boolean bl = true;
        for (int i = 64; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (bl) {
                if (by == 14) {
                    bl = false;
                    continue;
                }
                if (by == 15) {
                    throw new Exception("Illegal 0x0f found in singleByte mode");
                }
                byArray2[n] = by;
                ++n;
                continue;
            }
            if (by == 15) {
                bl = true;
                continue;
            }
            if (by == 14) {
                throw new Exception("Illegal 0x0e found in doubleByte mode");
            }
            byArray2[n] = 63;
            ++n;
            ++i;
        }
        if (n != 65536) {
            throw new Exception("To index is " + n + " should be 65536");
        }
        return byArray2;
    }

    private static char[] removeSingleByteEbcdic(byte[] byArray, boolean bl) throws Exception {
        char[] cArray = new char[65536];
        boolean bl2 = false;
        if (bl) {
            bl2 = true;
        }
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (bl2) {
                if (by == 14) {
                    bl2 = false;
                    continue;
                }
                if (by == 15) {
                    throw new Exception("Illegal 0x0f found in singleByte mode");
                }
                cArray[n] = 65278;
                ++n;
                continue;
            }
            if (by == 15 && bl) {
                bl2 = true;
                continue;
            }
            if (by == 14 && bl) {
                throw new Exception("Illegal 0x0e found in doubleByte mode");
            }
            cArray[n] = (char)(by << 8 | 0xFF & byArray[i + 1]);
            ++n;
            ++i;
        }
        if (n != 65536) {
            throw new Exception("To index is " + n + " should be 65536");
        }
        return cArray;
    }

    private static char[] jdbcToUnicode(Connection connection, int n) throws SQLException {
        if (n > 1000000) {
            n -= 1000000;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select cast(CAST(CAST(? AS VARCHAR(256) FOR BIT DATA) AS VARCHAR(256) CCSID " + n + ") as VARGRAPHIC(256) CCSID 1200) from sysibm.sysdummy1");
        byte[] byArray = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byArray[i] = i == 14 ? 63 : (i == 15 ? 63 : (byte)i);
        }
        preparedStatement.setBytes(1, byArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        preparedStatement.close();
        char[] cArray = string.toCharArray();
        cArray[14] = 14;
        cArray[15] = 15;
        return cArray;
    }

    private static char[] jdbcToEbcdicDBCS(Connection connection, int n) throws Exception {
        char[] cArray;
        int n2;
        boolean bl = false;
        if (n > 2000000) {
            n -= 2000000;
            bl = true;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select cast(CAST(CAST(? AS DBCLOB(1M) CCSID 1200) AS CLOB(1M) CCSID " + n + ") as BLOB(1M)) from sysibm.sysdummy1");
        char[] cArray2 = new char[65536];
        for (n2 = 0; n2 < 55296; ++n2) {
            cArray2[n2] = n2 <= 128 ? 26 : (char)n2;
        }
        for (n2 = 55296; n2 < 57344; ++n2) {
            cArray2[n2] = 65533;
        }
        for (n2 = 57344; n2 < 65536; ++n2) {
            cArray2[n2] = n2 >= 65024 && n2 <= 65295 ? 65533 : (char)n2;
        }
        Clob clob = ((AS400JDBCConnection)connection).createClob();
        clob.setString(1L, new String(cArray2));
        preparedStatement.setClob(1, clob);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        byte[] byArray = resultSet.getBytes(1);
        resultSet.close();
        preparedStatement.close();
        if (byArray.length != 131072) {
            cArray = GenerateConverterTable.removeSingleByteEbcdic(byArray, bl);
        } else {
            cArray = new char[byArray.length / 2];
            for (int i = 0; i < byArray.length; i += 2) {
                cArray[i / 2] = (char)(byArray[i] << 8 | 0xFF & byArray[i + 1]);
            }
        }
        return cArray;
    }

    private static char[] jdbcToUnicodeDBCS(Connection connection, int n) throws SQLException {
        boolean bl = false;
        String string = "select cast(CAST(CAST(? AS CLOB(1M) FOR BIT DATA ) AS DBCLOB(1M) CCSID " + n + ") as DBCLOB(1M) CCSID 1200) from sysibm.sysdummy1";
        if (n > 2000000) {
            bl = true;
            string = "select cast(CAST(CAST(? AS VARCHAR(16390) FOR BIT DATA) AS VARCHAR(16390) CCSID " + (n -= 2000000) + ") as VARGRAPHIC(8200) CCSID 1200) from sysibm.sysdummy1";
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        int n2 = 32;
        int n3 = 65536 / n2;
        byte[] byArray = bl ? new byte[n2 * 2 + 2] : new byte[n2 * 2];
        int n4 = 0;
        if (bl) {
            byArray[0] = 14;
            byArray[n2 * 2 + 1] = 15;
            n4 = 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n5 = i * n2 + j;
                if (bl && (n5 < 256 || n5 / 256 == 14 || n5 / 256 == 15 || n5 % 256 == 14 || n5 % 256 == 15)) {
                    n5 = 65278;
                }
                byArray[n4 + 2 * j] = (byte)(n5 / 256);
                byArray[n4 + 2 * j + 1] = (byte)n5;
            }
            if (n4 == 1) {
                byArray[n2 * 2 + 1] = 15;
            }
            preparedStatement.setBytes(1, byArray);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            String string2 = resultSet.getString(1);
            if (string2 == null) {
                System.out.println("ERROR: got null processing block " + i + " of size " + n2);
                System.out.println("INPUT BYTES: = " + GenerateConverterTable.dumpBytes(" ", byArray));
            } else if (string2.length() != n2) {
                // empty if block
            }
            stringBuffer.append(string2);
            resultSet.close();
        }
        preparedStatement.close();
        return stringBuffer.toString().toCharArray();
    }

    private static String dumpUnicodeString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string2.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            stringBuffer.append(string);
            int n = 0xFFFF & cArray[i];
            if (n < 16) {
                stringBuffer.append("0");
            }
            if (n < 256) {
                stringBuffer.append("0");
            }
            if (n < 4096) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    private static String dumpBytes(String string, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(string);
            int n = 0xFF & byArray[i];
            if (n < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(n));
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

