/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import com.ibm.as400.util.commtrace.AH;
import com.ibm.as400.util.commtrace.BitBuf;
import com.ibm.as400.util.commtrace.Data;
import com.ibm.as400.util.commtrace.Destination;
import com.ibm.as400.util.commtrace.ESP;
import com.ibm.as400.util.commtrace.FormatProperties;
import com.ibm.as400.util.commtrace.Formatter;
import com.ibm.as400.util.commtrace.Fragmentation;
import com.ibm.as400.util.commtrace.HopByHop;
import com.ibm.as400.util.commtrace.ICMP4Header;
import com.ibm.as400.util.commtrace.ICMP6Header;
import com.ibm.as400.util.commtrace.IP4Header;
import com.ibm.as400.util.commtrace.IP6Header;
import com.ibm.as400.util.commtrace.Routing;
import com.ibm.as400.util.commtrace.TCPHeader;
import com.ibm.as400.util.commtrace.UDPHeader;
import com.ibm.as400.util.commtrace.UnknownHeader;
import java.io.StringWriter;
import java.lang.reflect.Field;

public abstract class Header {
    BitBuf rawheader;
    BitBuf rawpayload;
    Header next;
    int type;
    public static final int ICMP6 = 58;
    public static final int IP6 = 41;
    public static final int ICMP4 = 1;
    public static final int IP4 = 23;
    public static final int TCP = 6;
    public static final int UDP = 17;
    public static final int EXTHOPBYHOP = 0;
    public static final int EXTROUTE = 43;
    public static final int EXTFRAG = 44;
    public static final int EXTESP = 50;
    public static final int EXTAH = 51;
    public static final int EXTDEST = 60;
    public static final int UNK = 255;
    static /* synthetic */ Class class$com$ibm$as400$util$commtrace$Field;

    Header(BitBuf bitBuf) {
        this.rawheader = bitBuf;
        this.rawheader = bitBuf.slice(0, this.getHeaderLen());
        this.rawpayload = bitBuf.slice(this.getHeaderLen());
        this.next = this.getNextHeader();
    }

    static Header createHeader(byte by, BitBuf bitBuf) {
        int n = by & 0xFF;
        if (bitBuf.getBitSize() == 0) {
            return null;
        }
        if (n == 58) {
            return new ICMP6Header(bitBuf);
        }
        if (n == 41) {
            return new IP6Header(bitBuf);
        }
        if (n == 1) {
            return new ICMP4Header(bitBuf);
        }
        if (n == 23) {
            return new IP4Header(bitBuf);
        }
        if (n == 6) {
            return new TCPHeader(bitBuf);
        }
        if (n == 17) {
            return new UDPHeader(bitBuf);
        }
        if (n == 0) {
            return new HopByHop(bitBuf);
        }
        if (n == 43) {
            return new Routing(bitBuf);
        }
        if (n == 44) {
            return new Fragmentation(bitBuf);
        }
        if (n == 50) {
            return new ESP(bitBuf);
        }
        if (n == 51) {
            return new AH(bitBuf);
        }
        if (n == 59) {
            return null;
        }
        if (n == 60) {
            return new Destination(bitBuf);
        }
        return new UnknownHeader(bitBuf);
    }

    String fielddump() {
        StringWriter stringWriter = new StringWriter();
        Field[] fieldArray = this.getClass().getFields();
        stringWriter.write("Fields from " + this.getName() + ":\n");
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!(class$com$ibm$as400$util$commtrace$Field == null ? Header.class$("com.ibm.as400.util.commtrace.Field") : class$com$ibm$as400$util$commtrace$Field).isAssignableFrom(fieldArray[i].getType())) continue;
            try {
                stringWriter.write("\t" + fieldArray[i].getName() + ":  " + fieldArray[i].get(this) + "\n");
                continue;
            }
            catch (Throwable throwable) {
                stringWriter.write("\n\nfielddump: Caught exception:  " + throwable.toString() + "\n");
            }
        }
        return stringWriter.toString();
    }

    public byte[] getHeaderData() {
        return this.rawheader.getBytes();
    }

    public int getHeaderLen() {
        return 0;
    }

    public String getName() {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
    }

    public Header getNextHeader() {
        return null;
    }

    public String printHexHeader() {
        String string = this.getName();
        int n = string.indexOf("$");
        if (n != -1) {
            string = string.substring(n + 1);
            string = string + " Header";
        }
        Object[] objectArray = new Object[]{string, this.rawheader.toHexString(32, "\n\t\t\t ")};
        return Formatter.jsprintf("\t    {0} :  {1}\n", objectArray);
    }

    public byte[] getPayLoad() {
        return this.rawpayload.getBytes();
    }

    String printnext() {
        if (this.next == null) {
            return "";
        }
        return this.next.toString();
    }

    String printnext(FormatProperties formatProperties) {
        if (this.next == null) {
            return "";
        }
        return this.next.toString(formatProperties);
    }

    public String toString() {
        return this.fielddump() + this.printnext();
    }

    public String toString(FormatProperties formatProperties) {
        return this.fielddump() + this.printnext(formatProperties);
    }

    public String toHexString() {
        return this.rawheader.toHexString();
    }

    public String getPayloadHexString() {
        return this.rawpayload.toHexString();
    }

    public byte[] getPayloadBytes() {
        return this.rawpayload.getBytes();
    }

    public String getPayload() {
        return new Data(this.rawpayload).toString();
    }

    public int getType() {
        return this.type;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

