/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.wire;

import java.util.Map;
import java.util.function.Predicate;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ModelCoders;

public class LengthPrefixUnknownCoders {
    public static String addLengthPrefixedCoder(String coderId, RunnerApi.Components.Builder components, boolean replaceWithByteArrayCoder) {
        String lengthPrefixedByteArrayCoderId = LengthPrefixUnknownCoders.addLengthPrefixByteArrayCoder(components);
        String urn = components.getCodersOrThrow(coderId).getSpec().getUrn();
        if (ModelCoders.LENGTH_PREFIX_CODER_URN.equals(urn)) {
            return replaceWithByteArrayCoder ? lengthPrefixedByteArrayCoderId : coderId;
        }
        if (ModelCoders.urns().contains(urn)) {
            return LengthPrefixUnknownCoders.addForModelCoder(coderId, components, replaceWithByteArrayCoder);
        }
        return replaceWithByteArrayCoder ? lengthPrefixedByteArrayCoderId : LengthPrefixUnknownCoders.addWrappedWithLengthPrefixCoder(coderId, components);
    }

    private static String addForModelCoder(String coderId, RunnerApi.Components.Builder components, boolean replaceWithByteArrayCoder) {
        RunnerApi.Coder coder = components.getCodersOrThrow(coderId);
        RunnerApi.Coder.Builder builder = coder.toBuilder().clearComponentCoderIds();
        for (String componentCoderId : coder.getComponentCoderIdsList()) {
            builder.addComponentCoderIds(LengthPrefixUnknownCoders.addLengthPrefixedCoder(componentCoderId, components, replaceWithByteArrayCoder));
        }
        return LengthPrefixUnknownCoders.addCoder(builder.build(), components, coderId + "-length_prefix");
    }

    private static String addWrappedWithLengthPrefixCoder(String coderId, RunnerApi.Components.Builder components) {
        RunnerApi.Coder.Builder lengthPrefixed = RunnerApi.Coder.newBuilder().addComponentCoderIds(coderId);
        lengthPrefixed.getSpecBuilder().setUrn(ModelCoders.LENGTH_PREFIX_CODER_URN).build();
        return LengthPrefixUnknownCoders.addCoder(lengthPrefixed.build(), components, coderId + "-length_prefix");
    }

    private static String addLengthPrefixByteArrayCoder(RunnerApi.Components.Builder components) {
        RunnerApi.Coder.Builder byteArrayCoder = RunnerApi.Coder.newBuilder();
        byteArrayCoder.getSpecBuilder().setUrn(ModelCoders.BYTES_CODER_URN);
        String byteArrayCoderId = LengthPrefixUnknownCoders.addCoder(byteArrayCoder.build(), components, "byte_array");
        RunnerApi.Coder.Builder lengthPrefixByteArrayCoder = RunnerApi.Coder.newBuilder();
        lengthPrefixByteArrayCoder.addComponentCoderIds(byteArrayCoderId).getSpecBuilder().setUrn(ModelCoders.LENGTH_PREFIX_CODER_URN);
        return LengthPrefixUnknownCoders.addCoder(lengthPrefixByteArrayCoder.build(), components, "length_prefix_byte_array");
    }

    private static String addCoder(RunnerApi.Coder coder, RunnerApi.Components.Builder components, String uniqueIdPrefix) {
        for (Map.Entry entry : components.getCodersMap().entrySet()) {
            if (!((RunnerApi.Coder)entry.getValue()).equals((Object)coder)) continue;
            return (String)entry.getKey();
        }
        String id = LengthPrefixUnknownCoders.generateUniqueId(uniqueIdPrefix, arg_0 -> ((RunnerApi.Components.Builder)components).containsCoders(arg_0));
        components.putCoders(id, coder);
        return id;
    }

    static String generateUniqueId(String prefix, Predicate<String> isExistingId) {
        int i = 0;
        while (isExistingId.test(prefix + i)) {
            ++i;
        }
        return prefix + i;
    }
}

