/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FileSystemUtils {
    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized String wildcardToRegexp(@UnknownKeyFor @NonNull @Initialized String globExp) {
        StringBuilder dst = new StringBuilder();
        char[] src = globExp.replace("**/*", "**").toCharArray();
        int i = 0;
        block6: while (i < src.length) {
            char c = src[i++];
            switch (c) {
                case '*': {
                    if (i < src.length && src[i] == '*') {
                        dst.append(".*");
                        ++i;
                        continue block6;
                    }
                    dst.append("[^/]*");
                    continue block6;
                }
                case '?': {
                    dst.append("[^/]");
                    continue block6;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    dst.append('\\').append(c);
                    continue block6;
                }
                case '\\': {
                    i = FileSystemUtils.doubleSlashes(dst, src, i);
                    continue block6;
                }
            }
            dst.append(c);
        }
        return dst.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized int doubleSlashes(@UnknownKeyFor @NonNull @Initialized StringBuilder dst, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] src, @UnknownKeyFor @NonNull @Initialized int i) {
        dst.append('\\');
        if (i + 1 < src.length) {
            dst.append('\\');
            dst.append(src[i]);
            ++i;
        } else {
            dst.append('\\');
        }
        return i;
    }
}

