/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SourceMetrics {
    private static final @UnknownKeyFor @NonNull @Initialized String SOURCE_NAMESPACE = "source";
    private static final @UnknownKeyFor @NonNull @Initialized String SOURCE_SPLITS_NAMESPACE = "source.splits";
    private static final @UnknownKeyFor @NonNull @Initialized String SEPARATOR = ".";
    private static final @UnknownKeyFor @NonNull @Initialized String ELEMENTS_READ = "elements_read";
    private static final @UnknownKeyFor @NonNull @Initialized String BYTES_READ = "bytes_read";
    private static final @UnknownKeyFor @NonNull @Initialized String BACKLOG_BYTES = "backlog_bytes";
    private static final @UnknownKeyFor @NonNull @Initialized String BACKLOG_ELEMENTS = "backlog_elements";
    private static final @UnknownKeyFor @NonNull @Initialized Counter ELEMENTS_READ_COUNTER = Metrics.counter("source", "elements_read");
    private static final @UnknownKeyFor @NonNull @Initialized Counter BYTES_READ_COUNTER = Metrics.counter("source", "bytes_read");
    private static final @UnknownKeyFor @NonNull @Initialized Gauge BACKLOG_BYTES_GAUGE = Metrics.gauge("source", "backlog_bytes");
    private static final @UnknownKeyFor @NonNull @Initialized Gauge BACKLOG_ELEMENTS_GAUGE = Metrics.gauge("source", "backlog_elements");

    public static @UnknownKeyFor @NonNull @Initialized Counter elementsRead() {
        return ELEMENTS_READ_COUNTER;
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter elementsReadBySplit(@UnknownKeyFor @NonNull @Initialized String splitId) {
        return Metrics.counter(SOURCE_SPLITS_NAMESPACE, SourceMetrics.renderName(splitId, ELEMENTS_READ));
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter bytesRead() {
        return BYTES_READ_COUNTER;
    }

    public static @UnknownKeyFor @NonNull @Initialized Counter bytesReadBySplit(@UnknownKeyFor @NonNull @Initialized String splitId) {
        return Metrics.counter(SOURCE_SPLITS_NAMESPACE, SourceMetrics.renderName(splitId, BYTES_READ));
    }

    public static @UnknownKeyFor @NonNull @Initialized Gauge backlogBytes() {
        return BACKLOG_BYTES_GAUGE;
    }

    public static @UnknownKeyFor @NonNull @Initialized Gauge backlogBytesOfSplit(@UnknownKeyFor @NonNull @Initialized String splitId) {
        return Metrics.gauge(SOURCE_SPLITS_NAMESPACE, SourceMetrics.renderName(splitId, BACKLOG_BYTES));
    }

    public static @UnknownKeyFor @NonNull @Initialized Gauge backlogElements() {
        return BACKLOG_ELEMENTS_GAUGE;
    }

    public static @UnknownKeyFor @NonNull @Initialized Gauge backlogElementsOfSplit(@UnknownKeyFor @NonNull @Initialized String splitId) {
        return Metrics.gauge(SOURCE_SPLITS_NAMESPACE, SourceMetrics.renderName(splitId, BACKLOG_ELEMENTS));
    }

    private static @UnknownKeyFor @NonNull @Initialized String renderName(String ... nameParts) {
        return Joiner.on((String)SEPARATOR).join((Object[])nameParts);
    }
}

