/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
public class DoFnOutputReceivers {
    public static <T> @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> windowedReceiver(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @Nullable @UnknownKeyFor @Initialized TupleTag<T> outputTag) {
        return new WindowedContextOutputReceiver<T>(context, outputTag);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver windowedMultiReceiver(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders) {
        return new WindowedContextMultiOutputReceiver(context, outputCoders);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver windowedMultiReceiver(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context) {
        return new WindowedContextMultiOutputReceiver(context);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> rowReceiver(/*
     * Issues handling annotations - annotations may be inaccurate
     */
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @Nullable @UnknownKeyFor @Initialized TupleTag<T> outputTag, @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> schemaCoder) {
        return new RowOutputReceiver<T>(context, outputTag, schemaCoder);
    }

    private static class WindowedContextMultiOutputReceiver
    implements DoFn.MultiOutputReceiver {
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context;
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders;

        public WindowedContextMultiOutputReceiver(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders) {
            this.context = context;
            this.outputCoders = outputCoders;
        }

        public WindowedContextMultiOutputReceiver(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context) {
            this.context = context;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> get(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag) {
            return DoFnOutputReceivers.windowedReceiver(this.context, tag);
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> getRowReceiver(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag) {
            Coder outputCoder = (Coder)((Map)Preconditions.checkNotNull(this.outputCoders)).get(tag);
            Preconditions.checkState((outputCoder != null ? 1 : 0) != 0, (Object)("No output tag for " + tag));
            Preconditions.checkState((boolean)(outputCoder instanceof SchemaCoder), (Object)("Output with tag " + tag + " must have a schema in order to call getRowReceiver"));
            return DoFnOutputReceivers.rowReceiver(this.context, tag, (SchemaCoder)outputCoder);
        }
    }

    private static class WindowedContextOutputReceiver<@UnknownKeyFor T>
    implements DoFn.OutputReceiver<T> {
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context;
        @Nullable @UnknownKeyFor @Initialized TupleTag<T> outputTag;

        public WindowedContextOutputReceiver(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @Nullable @UnknownKeyFor @Initialized TupleTag<T> outputTag) {
            this.context = context;
            this.outputTag = outputTag;
        }

        @Override
        public void output(T output) {
            if (this.outputTag != null) {
                this.context.output(this.outputTag, output);
            } else {
                this.context.output(output);
            }
        }

        @Override
        public void outputWithTimestamp(T output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            if (this.outputTag != null) {
                this.context.outputWithTimestamp(this.outputTag, output, timestamp);
            } else {
                this.context.outputWithTimestamp(output, timestamp);
            }
        }
    }

    private static class RowOutputReceiver<@UnknownKeyFor T>
    implements DoFn.OutputReceiver<Row> {
        @UnknownKeyFor @NonNull @Initialized WindowedContextOutputReceiver<T> outputReceiver;
        @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> schemaCoder;

        public RowOutputReceiver(/*
         * Issues handling annotations - annotations may be inaccurate
         */
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized WindowedContext context, @Nullable @UnknownKeyFor @Initialized TupleTag<T> outputTag, @UnknownKeyFor @NonNull @Initialized SchemaCoder<T> schemaCoder) {
            this.outputReceiver = new WindowedContextOutputReceiver<T>(context, outputTag);
            this.schemaCoder = (SchemaCoder)Preconditions.checkNotNull(schemaCoder);
        }

        @Override
        public void output(@UnknownKeyFor @NonNull @Initialized Row output) {
            this.outputReceiver.output(this.schemaCoder.getFromRowFunction().apply(output));
        }

        @Override
        public void outputWithTimestamp(@UnknownKeyFor @NonNull @Initialized Row output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
            this.outputReceiver.outputWithTimestamp(this.schemaCoder.getFromRowFunction().apply(output), timestamp);
        }
    }
}

