/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleMapWithFailures;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class MapKeys<@UnknownKeyFor K1, @UnknownKeyFor K2, @UnknownKeyFor V>
extends PTransform<PCollection<KV<K1, V>>, PCollection<KV<K2, V>>> {
    private final transient @UnknownKeyFor @NonNull @Initialized TypeDescriptor<K2> outputType;
    private final @Nullable @UnknownKeyFor @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<@UnknownKeyFor @NonNull @Initialized KV<K1, V>, @UnknownKeyFor @NonNull @Initialized KV<K2, V>>> fn;

    public <NewValueT, NewKeyT> @UnknownKeyFor @NonNull @Initialized MapKeys<NewKeyT, K2, NewValueT> via(@UnknownKeyFor @NonNull @Initialized SerializableFunction<NewKeyT, K2> fn) {
        return new MapKeys<K1, K2, V>(Contextful.fn((element, c) -> KV.of(fn.apply(element.getKey()), element.getValue()), Requirements.empty()), this.outputType);
    }

    public static <K2> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized MapKeys<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, K2, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> into(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<K2> outputType) {
        return new MapKeys(null, outputType);
    }

    private MapKeys(@Nullable @UnknownKeyFor @Initialized Contextful<@UnknownKeyFor @NonNull @Initialized Contextful.Fn<@UnknownKeyFor @NonNull @Initialized KV<K1, V>, @UnknownKeyFor @NonNull @Initialized KV<K2, V>>> fn, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<K2> outputType) {
        this.fn = fn;
        this.outputType = outputType;
    }

    @RequiresNonNull(value={"fn"})
    public <FailureT> @UnknownKeyFor @NonNull @Initialized SimpleMapWithFailures<@UnknownKeyFor @NonNull @Initialized KV<K1, V>, @UnknownKeyFor @NonNull @Initialized KV<K2, V>, FailureT> exceptionsInto(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<FailureT> failureTypeDescriptor) {
        return new SimpleMapWithFailures("MapKeysWithFailures", this.fn, this.getKvTypeDescriptor(), null, failureTypeDescriptor);
    }

    @RequiresNonNull(value={"fn"})
    public <FailureT> @UnknownKeyFor @NonNull @Initialized SimpleMapWithFailures<@UnknownKeyFor @NonNull @Initialized KV<K1, V>, @UnknownKeyFor @NonNull @Initialized KV<K2, V>, FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized InferableFunction< @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<@UnknownKeyFor @NonNull @Initialized KV<K1, V>>, FailureT> exceptionHandler) {
        return new SimpleMapWithFailures<KV<K1, V>, KV<K2, V>, FailureT>("MapKeysWithFailures", this.fn, this.getKvTypeDescriptor(), exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K2, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K1, V>> input) {
        return (PCollection)((Object)input.apply("MapKeys", MapElements.into(this.getKvTypeDescriptor()).via((Contextful)Preconditions.checkNotNull(this.fn, (Object)"Must specify a function on MapKeys using .via()"))));
    }

    private @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized KV<K2, V>> getKvTypeDescriptor() {
        return new TypeDescriptor<KV<K2, V>>(){}.where(new TypeParameter<K2>(){}, this.outputType);
    }
}

