/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.ArrayUtils;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.resources.PipelineResources;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.SideInputValues;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianIntegerCoder;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.BigEndianShortCoder;
import org.apache.beam.sdk.coders.BigIntegerCoder;
import org.apache.beam.sdk.coders.BitSetCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.CollectionCoder;
import org.apache.beam.sdk.coders.DelegateCoder;
import org.apache.beam.sdk.coders.DequeCoder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.DurationCoder;
import org.apache.beam.sdk.coders.FloatCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.LengthPrefixCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.coders.ShardedKeyCoder;
import org.apache.beam.sdk.coders.SnappyCoder;
import org.apache.beam.sdk.coders.SortedMapCoder;
import org.apache.beam.sdk.coders.StringDelegateCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.TextualIntegerCoder;
import org.apache.beam.sdk.coders.TimestampPrefixingWindowCoder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.KryoRegistrator;
import org.apache.spark.serializer.KryoSerializer;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.v2.DataWritingSparkTaskResult;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSessionFactory {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SparkSessionFactory.class);
    private static final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> SPARK_JAR_EXCLUDES = Lists.newArrayList((Object[])new String[]{"jre/lib/ext/", "/org/slf4j/", "/org.slf4j/", "/log4j/", "/io/dropwizard/metrics/", "/io.dropwizard.metrics/", "/org/apache/spark/", "/org.apache.spark/", "/org/apache/hadoop/", "/org.apache.hadoop/", "/org/scala-lang/", "/org.scala-lang/", "/com.esotericsoftware/kryo-shaded", "/com/esotericsoftware/kryo-shaded"});

    public static @UnknownKeyFor @NonNull @Initialized SparkSession getOrCreateSession(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions options) {
        if (options.getUseActiveSparkSession()) {
            return SparkSession.active();
        }
        return SparkSessionFactory.sessionBuilder(options.getSparkMaster(), options).getOrCreate();
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized SparkSession.Builder sessionBuilder(@UnknownKeyFor @NonNull @Initialized String master) {
        return SparkSessionFactory.sessionBuilder(master, null);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized SparkSession.Builder sessionBuilder(@UnknownKeyFor @NonNull @Initialized String master, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized SparkStructuredStreamingPipelineOptions options) {
        int partitions;
        String serializer;
        SparkConf sparkConf = new SparkConf().setIfMissing("spark.master", master);
        master = sparkConf.get("spark.master");
        if (options != null) {
            if (options.getAppName() != null) {
                sparkConf.setAppName(options.getAppName());
            }
            if (options.getFilesToStage() != null && !options.getFilesToStage().isEmpty()) {
                PipelineResources.prepareFilesForStaging((FileStagingOptions)options);
                Object[] filesToStage = SparkSessionFactory.filterFilesToStage(options, Collections.emptyList());
                Object[] jars = SparkSessionFactory.getSparkJars(sparkConf);
                sparkConf.setJars((String[])(jars.length > 0 ? (String[])ArrayUtils.addAll((Object[])jars, (Object[])filesToStage) : filesToStage));
            } else if (!sparkConf.contains("spark.jars") && !master.startsWith("local[")) {
                PipelineResources.prepareFilesForStaging((FileStagingOptions)options);
                sparkConf.setJars(SparkSessionFactory.filterFilesToStage(options, SPARK_JAR_EXCLUDES));
                sparkConf.setIfMissing("spark.executor.userClassPathFirst", "true");
            }
        }
        if ((serializer = sparkConf.get("spark.serializer", KryoSerializer.class.getName())).equals(KryoSerializer.class.getName())) {
            boolean unsafe = sparkConf.getBoolean("spark.kryo.unsafe", true);
            sparkConf.set("spark.serializer", serializer);
            sparkConf.set("spark.kryo.unsafe", Boolean.toString(unsafe));
            sparkConf.set("spark.kryo.registrator", SparkKryoRegistrator.class.getName());
            LOG.info("Configured `spark.serializer` to use KryoSerializer [unsafe={}]", (Object)unsafe);
        }
        if ((partitions = SparkSessionFactory.localNumPartitions(master)) > 0) {
            sparkConf.setIfMissing("spark.sql.shuffle.partitions", Integer.toString(partitions));
        }
        return SparkSession.builder().config(sparkConf);
    }

    private static @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] filterFilesToStage(@UnknownKeyFor @NonNull @Initialized SparkStructuredStreamingPipelineOptions opts, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> excludes) {
        Collection files = opts.getFilesToStage();
        if (files == null || files.isEmpty()) {
            return org.apache.commons.lang3.ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (!excludes.isEmpty()) {
            files = Collections2.filter((Collection)files, f -> !excludes.stream().anyMatch(f::contains));
        }
        return files.toArray(org.apache.commons.lang3.ArrayUtils.EMPTY_STRING_ARRAY);
    }

    private static @UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] getSparkJars(@UnknownKeyFor @NonNull @Initialized SparkConf conf) {
        return conf.contains("spark.jars") ? conf.get("spark.jars").split(",") : org.apache.commons.lang3.ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private static @UnknownKeyFor @NonNull @Initialized int localNumPartitions(@UnknownKeyFor @NonNull @Initialized String master) {
        return master.startsWith("local[") ? NumberUtils.toInt((String)StringUtils.substringBetween((String)master, (String)"local[", (String)"]")) : 0;
    }

    public static class SparkKryoRegistrator
    implements KryoRegistrator {
        public void registerClasses(@UnknownKeyFor @NonNull @Initialized Kryo kryo) {
            kryo.register(InternalRow.class);
            kryo.register(InternalRow[].class);
            kryo.register(byte[][].class);
            kryo.register(HashMap.class);
            kryo.register(ArrayList.class);
            kryo.register(DataWritingSparkTaskResult.class);
            kryo.register(SerializablePipelineOptions.class, (Serializer)new JavaSerializer());
            kryo.register(SideInputValues.ByWindow.class);
            kryo.register(SideInputValues.Global.class);
            this.tryToRegister(kryo, "org.apache.beam.sdk.extensions.avro.coders.AvroCoder");
            this.tryToRegister(kryo, "org.apache.beam.sdk.extensions.avro.coders.AvroGenericCoder");
            kryo.register(BigDecimalCoder.class);
            kryo.register(BigEndianIntegerCoder.class);
            kryo.register(BigEndianLongCoder.class);
            kryo.register(BigEndianShortCoder.class);
            kryo.register(BigIntegerCoder.class);
            kryo.register(BitSetCoder.class);
            kryo.register(BooleanCoder.class);
            kryo.register(ByteArrayCoder.class);
            kryo.register(ByteCoder.class);
            kryo.register(CollectionCoder.class);
            kryo.register(DelegateCoder.class);
            kryo.register(DequeCoder.class);
            kryo.register(DoubleCoder.class);
            kryo.register(DurationCoder.class);
            kryo.register(FloatCoder.class);
            kryo.register(InstantCoder.class);
            kryo.register(IterableCoder.class);
            kryo.register(KvCoder.class);
            kryo.register(LengthPrefixCoder.class);
            kryo.register(ListCoder.class);
            kryo.register(MapCoder.class);
            kryo.register(NullableCoder.class);
            kryo.register(RowCoder.class);
            kryo.register(SerializableCoder.class);
            kryo.register(SetCoder.class);
            kryo.register(ShardedKeyCoder.class);
            kryo.register(SnappyCoder.class);
            kryo.register(SortedMapCoder.class);
            kryo.register(StringDelegateCoder.class);
            kryo.register(StringUtf8Coder.class);
            kryo.register(TextualIntegerCoder.class);
            kryo.register(TimestampPrefixingWindowCoder.class);
            kryo.register(VarIntCoder.class);
            kryo.register(VarLongCoder.class);
            kryo.register(VoidCoder.class);
            kryo.register(GlobalWindow.Coder.class);
            kryo.register(IntervalWindow.IntervalWindowCoder.class);
            kryo.register(WindowedValue.FullWindowedValueCoder.class);
            kryo.register(WindowedValue.ParamWindowedValueCoder.class);
            kryo.register(WindowedValue.ValueOnlyWindowedValueCoder.class);
            kryo.register(OffsetRange.Coder.class);
            kryo.register(UnionCoder.class);
            kryo.register(PCollectionViews.ValueOrMetadataCoder.class);
            kryo.register(FileBasedSink.FileResultCoder.class);
            kryo.register(CoGbkResult.CoGbkResultCoder.class);
            kryo.register(CoGbkResultSchema.class);
            kryo.register(TupleTag.class);
            kryo.register(TupleTagList.class);
        }

        private void tryToRegister(@UnknownKeyFor @NonNull @Initialized Kryo kryo, @UnknownKeyFor @NonNull @Initialized String className) {
            try {
                kryo.register(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                LOG.info("Class {}} was not found on classpath", (Object)className);
            }
        }
    }
}

