/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.DoFnRunner;
import org.apache.beam.runners.core.DoFnRunners;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StepContext;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.DoFnRunnerWithMetrics;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.CachedSideInputReader;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.functions.NoOpStepContext;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import scala.Serializable;

abstract class DoFnRunnerFactory<@UnknownKeyFor InT, @UnknownKeyFor T>
implements Serializable {
    DoFnRunnerFactory() {
    }

    abstract @UnknownKeyFor @NonNull @Initialized DoFnRunnerWithTeardown<InT, T> create(@UnknownKeyFor @NonNull @Initialized PipelineOptions var1, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator var2, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager var3);

    abstract <T2> @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, T2> fuse(@UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<T, T2> var1);

    static <InT, T> @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, T> simple(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends InT>, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InT, T>> appliedPT, @UnknownKeyFor @NonNull @Initialized PCollection<InT> input, @UnknownKeyFor @NonNull @Initialized SideInputReader sideInputReader, @UnknownKeyFor @NonNull @Initialized boolean filterMainOutput) {
        return new SimpleRunnerFactory<InT, T>(appliedPT, input, sideInputReader, filterMainOutput);
    }

    private static class FusedRunnerFactory<@UnknownKeyFor InT, @UnknownKeyFor T>
    extends DoFnRunnerFactory<InT, T> {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> factories;

        FusedRunnerFactory(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> factories) {
            this.factories = factories;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized DoFnRunnerWithTeardown<InT, T> create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager output) {
            return new FusedRunner(options, metrics, output, this.factories);
        }

        @Override
        <T2> @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, T2> fuse(@UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<T, T2> next) {
            this.factories.add(next);
            return this;
        }

        private static class FusedRunner<@UnknownKeyFor InT, @UnknownKeyFor T>
        implements DoFnRunnerWithTeardown<InT, T> {
            final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized DoFnRunnerWithTeardown<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> @UnknownKeyFor @NonNull @Initialized [] runners;

            FusedRunner(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager output, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> factories) {
                this.runners = new DoFnRunnerWithTeardown[factories.size()];
                this.runners[this.runners.length - 1] = factories.get(this.runners.length - 1).create(options, metrics, output);
                for (int i = this.runners.length - 2; i >= 0; --i) {
                    this.runners[i] = factories.get(i).create(options, metrics, new FusedOutput(this.runners[i + 1]));
                }
            }

            public void startBundle() {
                for (int i = 0; i < this.runners.length; ++i) {
                    this.runners[i].startBundle();
                }
            }

            public void processElement(@UnknownKeyFor @NonNull @Initialized WindowedValue<InT> elem) {
                this.runners[0].processElement(elem);
            }

            public <KeyT> void onTimer(@UnknownKeyFor @NonNull @Initialized String timerId, @UnknownKeyFor @NonNull @Initialized String timerFamilyId, KeyT key, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, @UnknownKeyFor @NonNull @Initialized Instant outputTimestamp, @UnknownKeyFor @NonNull @Initialized TimeDomain timeDomain) {
                throw new UnsupportedOperationException();
            }

            public <KeyT> void onWindowExpiration(@UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized Instant timestamp, KeyT key) {
                throw new UnsupportedOperationException();
            }

            public void finishBundle() {
                for (int i = 0; i < this.runners.length; ++i) {
                    this.runners[i].finishBundle();
                }
            }

            public @UnknownKeyFor @NonNull @Initialized DoFn<InT, T> getFn() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void teardown() {
                for (int i = 0; i < this.runners.length; ++i) {
                    this.runners[i].teardown();
                }
            }

            private static class FusedOutput
            implements DoFnRunners.OutputManager {
                final /*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized DoFnRunnerWithTeardown<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> runner;

                FusedOutput(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                @UnknownKeyFor @NonNull @Initialized DoFnRunnerWithTeardown<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> runner) {
                    this.runner = runner;
                }

                public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
                    this.runner.processElement(output);
                }
            }
        }
    }

    private static class SimpleRunnerFactory<@UnknownKeyFor InT, @UnknownKeyFor T>
    extends DoFnRunnerFactory<InT, T> {
        private final @UnknownKeyFor @NonNull @Initialized String stepName;
        private final @UnknownKeyFor @NonNull @Initialized DoFn<InT, T> doFn;
        private final @UnknownKeyFor @NonNull @Initialized DoFnSchemaInformation doFnSchema;
        private final @UnknownKeyFor @NonNull @Initialized Coder<InT> coder;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> windowingStrategy;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<T> mainOutput;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputs;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> outputCoders;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sideInputs;
        private final @UnknownKeyFor @NonNull @Initialized SideInputReader sideInputReader;
        private final @UnknownKeyFor @NonNull @Initialized boolean filterMainOutput;

        SimpleRunnerFactory(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends InT>, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<InT, T>> appliedPT, @UnknownKeyFor @NonNull @Initialized PCollection<InT> input, @UnknownKeyFor @NonNull @Initialized SideInputReader sideInputReader, @UnknownKeyFor @NonNull @Initialized boolean filterMainOutput) {
            this.stepName = appliedPT.getFullName();
            this.doFn = ((ParDo.MultiOutput)appliedPT.getTransform()).getFn();
            this.doFnSchema = ParDoTranslation.getSchemaInformation(appliedPT);
            this.coder = input.getCoder();
            this.windowingStrategy = input.getWindowingStrategy();
            this.mainOutput = ((ParDo.MultiOutput)appliedPT.getTransform()).getMainOutputTag();
            this.additionalOutputs = SimpleRunnerFactory.additionalOutputs((ParDo.MultiOutput)appliedPT.getTransform());
            this.outputCoders = SimpleRunnerFactory.coders(appliedPT.getOutputs(), this.mainOutput);
            this.sideInputs = ((ParDo.MultiOutput)appliedPT.getTransform()).getSideInputs();
            this.sideInputReader = sideInputReader;
            this.filterMainOutput = filterMainOutput;
        }

        @Override
        <T2> @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, T2> fuse(@UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<T, T2> next) {
            return new FusedRunnerFactory(Lists.newArrayList((Object[])new DoFnRunnerFactory[]{this, next}));
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized DoFnRunnerWithTeardown<InT, T> create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager output) {
            DoFnRunner simpleRunner = DoFnRunners.simpleRunner((PipelineOptions)options, this.doFn, (SideInputReader)CachedSideInputReader.of(this.sideInputReader, this.sideInputs.values()), (DoFnRunners.OutputManager)(this.filterMainOutput ? new FilteredOutput(output, this.mainOutput) : output), this.mainOutput, this.additionalOutputs, (StepContext)new NoOpStepContext(), this.coder, this.outputCoders, this.windowingStrategy, (DoFnSchemaInformation)this.doFnSchema, this.sideInputs);
            DoFnRunnerWithMetrics runner = new DoFnRunnerWithMetrics(this.stepName, simpleRunner, metrics);
            DoFnInvokers.tryInvokeSetupFor(this.doFn, (PipelineOptions)options);
            try {
                runner.startBundle();
            }
            catch (RuntimeException re) {
                DoFnInvokers.invokerFor(this.doFn).invokeTeardown();
                throw re;
            }
            return runner;
        }

        private static /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> coders(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> pCols, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> main) {
            if (pCols.size() == 1) {
                return Collections.singletonMap(main, ((PCollection)Iterables.getOnlyElement(pCols.values())).getCoder());
            }
            HashMap coders = Maps.newHashMapWithExpectedSize((int)pCols.size());
            for (Map.Entry<TupleTag<?>, PCollection<?>> e : pCols.entrySet()) {
                coders.put(e.getKey(), e.getValue().getCoder());
            }
            return coders;
        }

        private static /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> additionalOutputs(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized ParDo.MultiOutput<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> transform) {
            List tags = transform.getAdditionalOutputTags().getAll();
            return tags.isEmpty() ? Collections.emptyList() : new ArrayList(tags);
        }

        private static class FilteredOutput
        implements DoFnRunners.OutputManager {
            final // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager outputManager;
            final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> tupleTag;

            FilteredOutput(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFnRunners.OutputManager outputManager, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> tupleTag) {
                this.outputManager = outputManager;
                this.tupleTag = tupleTag;
            }

            public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
                if (this.tupleTag.equals(tag)) {
                    this.outputManager.output(tag, output);
                }
            }
        }
    }

    static interface DoFnRunnerWithTeardown<@UnknownKeyFor InT, @UnknownKeyFor T>
    extends DoFnRunner<InT, T> {
        public void teardown();
    }
}

