/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.lang.reflect.Constructor;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.types.DataType;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Option;
import scala.reflect.ClassTag;

public class EncoderFactory {
    private static final @UnknownKeyFor @NonNull @Initialized Constructor<@UnknownKeyFor @NonNull @Initialized StaticInvoke> STATIC_INVOKE_CONSTRUCTOR = StaticInvoke.class.getConstructors()[0];
    private static final @UnknownKeyFor @NonNull @Initialized Constructor<@UnknownKeyFor @NonNull @Initialized Invoke> INVOKE_CONSTRUCTOR = Invoke.class.getConstructors()[0];
    private static final @UnknownKeyFor @NonNull @Initialized Constructor<@UnknownKeyFor @NonNull @Initialized NewInstance> NEW_INSTANCE_CONSTRUCTOR = NewInstance.class.getConstructors()[0];

    static <T> @UnknownKeyFor @NonNull @Initialized ExpressionEncoder<T> create(@UnknownKeyFor @NonNull @Initialized Expression serializer, @UnknownKeyFor @NonNull @Initialized Expression deserializer, @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @Nullable @Initialized ? super T> clazz) {
        return new ExpressionEncoder(serializer, deserializer, ClassTag.apply(clazz));
    }

    static @UnknownKeyFor @NonNull @Initialized Expression invokeIfNotNull(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cls, @UnknownKeyFor @NonNull @Initialized String fun, @UnknownKeyFor @NonNull @Initialized DataType type, Expression ... args) {
        return EncoderFactory.invoke(cls, fun, type, true, args);
    }

    static @UnknownKeyFor @NonNull @Initialized Expression invoke(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cls, @UnknownKeyFor @NonNull @Initialized String fun, @UnknownKeyFor @NonNull @Initialized DataType type, Expression ... args) {
        return EncoderFactory.invoke(cls, fun, type, false, args);
    }

    private static @UnknownKeyFor @NonNull @Initialized Expression invoke(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cls, @UnknownKeyFor @NonNull @Initialized String fun, @UnknownKeyFor @NonNull @Initialized DataType type, @UnknownKeyFor @NonNull @Initialized boolean propagateNull, Expression ... args) {
        try {
            switch (STATIC_INVOKE_CONSTRUCTOR.getParameterCount()) {
                case 6: {
                    return (Expression)STATIC_INVOKE_CONSTRUCTOR.newInstance(cls, type, fun, ScalaInterop.seqOf(args), propagateNull, true);
                }
                case 8: {
                    return (Expression)STATIC_INVOKE_CONSTRUCTOR.newInstance(cls, type, fun, ScalaInterop.seqOf(args), ScalaInterop.emptyList(), propagateNull, true, true);
                }
            }
            throw new RuntimeException("Unsupported version of Spark");
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    static @UnknownKeyFor @NonNull @Initialized Expression invoke(@UnknownKeyFor @NonNull @Initialized Expression obj, @UnknownKeyFor @NonNull @Initialized String fun, @UnknownKeyFor @NonNull @Initialized DataType type, @UnknownKeyFor @NonNull @Initialized boolean nullable, Expression ... args) {
        try {
            switch (STATIC_INVOKE_CONSTRUCTOR.getParameterCount()) {
                case 6: {
                    return (Expression)INVOKE_CONSTRUCTOR.newInstance(obj, fun, type, ScalaInterop.seqOf(args), false, nullable);
                }
                case 8: {
                    return (Expression)INVOKE_CONSTRUCTOR.newInstance(obj, fun, type, ScalaInterop.seqOf(args), ScalaInterop.emptyList(), false, nullable, true);
                }
            }
            throw new RuntimeException("Unsupported version of Spark");
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    static @UnknownKeyFor @NonNull @Initialized Expression newInstance(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> cls, @UnknownKeyFor @NonNull @Initialized DataType type, Expression ... args) {
        try {
            switch (NEW_INSTANCE_CONSTRUCTOR.getParameterCount()) {
                case 5: {
                    return (Expression)NEW_INSTANCE_CONSTRUCTOR.newInstance(cls, ScalaInterop.seqOf(args), true, type, Option.empty());
                }
                case 6: {
                    return (Expression)NEW_INSTANCE_CONSTRUCTOR.newInstance(cls, ScalaInterop.seqOf(args), ScalaInterop.emptyList(), true, type, Option.empty());
                }
            }
            throw new RuntimeException("Unsupported version of Spark");
        }
        catch (IllegalArgumentException | ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

