/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.h2;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;

@DatabaseMetaPlugin(type="H2", typeDescription="H2", documentationUrl="/database/databases/h2.html")
@GuiPlugin(id="GUI-H2DatabaseMeta")
public class H2DatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getNotFoundTK(boolean useAutoinc) {
        return super.getNotFoundTK(useAutoinc);
    }

    public String getDriverClass() {
        return "org.h2.Driver";
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 8082;
        }
        return -1;
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (databaseName != null && databaseName.startsWith("mem:") || (Utils.isEmpty((CharSequence)port) || "-1".equals(port)) && Utils.isEmpty((CharSequence)hostname)) {
            return "jdbc:h2:" + databaseName;
        }
        return "jdbc:h2:tcp://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean isFetchSizeSupported() {
        return true;
    }

    public boolean isSupportsBitmapIndex() {
        return false;
    }

    public boolean isSupportsAutoInc() {
        return true;
    }

    public boolean isSupportsGetBlob() {
        return true;
    }

    public boolean isSupportsSetCharacterStream() {
        return false;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    retval = (String)retval + "BOOLEAN";
                    break;
                }
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = (String)retval + "IDENTITY";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 18) {
                        retval = (String)retval + "DECIMAL(" + length + ", " + precision + ")";
                        break;
                    }
                    if (length > 9) {
                        retval = (String)retval + "BIGINT";
                        break;
                    }
                    if (length < 5) {
                        if (length < 3) {
                            retval = (String)retval + "TINYINT";
                            break;
                        }
                        retval = (String)retval + "SMALLINT";
                        break;
                    }
                    retval = (String)retval + "INTEGER";
                    break;
                }
                retval = (String)retval + "DOUBLE";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = (String)retval + "TEXT";
                    break;
                }
                retval = (String)retval + "VARCHAR";
                retval = length > 0 ? (String)retval + "(" + length : (String)retval + "(2147483647";
                retval = (String)retval + ")";
                break;
            }
            case 8: {
                retval = (String)retval + "BLOB";
                break;
            }
            default: {
                retval = (String)retval + "UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String[] getReservedWords() {
        return new String[]{"CURRENT_TIMESTAMP", "CURRENT_TIME", "CURRENT_DATE", "CROSS", "DISTINCT", "EXCEPT", "EXISTS", "FROM", "FOR", "FALSE", "FULL", "GROUP", "HAVING", "INNER", "INTERSECT", "IS", "JOIN", "LIKE", "MINUS", "NATURAL", "NOT", "NULL", "ON", "ORDER", "PRIMARY", "ROWNUM", "SELECT", "SYSDATE", "SYSTIME", "SYSTIMESTAMP", "TODAY", "TRUE", "UNION", "WHERE"};
    }

    public boolean isSupportsPreparedStatementMetadataRetrieval() {
        return false;
    }
}

