/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class SnowflakeClob
implements Clob {
    private StringBuffer buffer;

    public SnowflakeClob() {
        this.buffer = new StringBuffer();
    }

    public SnowflakeClob(String content) {
        this.buffer = new StringBuffer(content);
    }

    @Override
    public long length() throws SQLException {
        return this.buffer.length();
    }

    @Override
    public String getSubString(long pos, int length) throws SQLException {
        if (pos < 1L || length < 0) {
            throw new SQLException();
        }
        return this.buffer.substring((int)pos - 0, (int)pos - 0 + length);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.buffer.toString());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return new ByteArrayInputStream(this.buffer.toString().getBytes());
    }

    @Override
    public long position(String searchstr, long start) throws SQLException {
        if (start < 1L) {
            throw new SQLException();
        }
        return this.buffer.lastIndexOf(searchstr, (int)start - 1);
    }

    @Override
    public long position(Clob searchstr, long start) throws SQLException {
        if (start < 1L) {
            throw new SQLException();
        }
        return this.buffer.lastIndexOf(searchstr.toString(), (int)start - 1);
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        if (pos < 1L) {
            throw new SQLException();
        }
        this.buffer.insert((int)pos - 1, str);
        return str.length();
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        if (pos < 1L) {
            throw new SQLException();
        }
        String substring = str.substring(offset, len);
        this.buffer.insert((int)pos - 1, substring);
        return substring.length();
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        return new StringBufferOutputStream(this.buffer, (int)pos);
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        return new StringBufferWriter(this.buffer, (int)pos);
    }

    @Override
    public void truncate(long len) throws SQLException {
        if ((long)this.buffer.length() > len) {
            this.buffer.delete((int)len, this.buffer.length());
        }
    }

    @Override
    public void free() throws SQLException {
        this.buffer = new StringBuffer();
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        return new StringReader(this.buffer.substring((int)pos - 1, (int)pos - 1 + (int)length));
    }

    public String toString() {
        return this.buffer.toString();
    }

    private class StringBufferOutputStream
    extends OutputStream {
        private StringBuffer buffer;
        private int offset;

        public StringBufferOutputStream(StringBuffer buffer, int pos) {
            this.buffer = buffer;
            this.offset = pos - 1;
        }

        @Override
        public void write(int c) throws IOException {
            if (this.offset >= this.buffer.length()) {
                this.buffer.append((char)c);
            } else {
                this.buffer.replace(this.offset, this.offset + 1, Integer.toString(c));
            }
        }

        public String toString() {
            return this.buffer.toString();
        }

        public void clear() {
            this.buffer.delete(0, this.buffer.length());
        }
    }

    private class StringBufferWriter
    extends Writer {
        private StringBuffer main;
        private StringBuffer current;

        public StringBufferWriter(StringBuffer buffer, int pos) {
            this.main = buffer;
            this.current = new StringBuffer();
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.current.append(cbuf[off + i]);
            }
        }

        @Override
        public void flush() throws IOException {
            this.main.append(this.current);
            this.current.delete(0, this.current.length());
        }

        @Override
        public void close() throws IOException {
            if (this.current == null) {
                throw new IOException();
            }
            this.flush();
            this.current = null;
        }
    }
}

