/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class MetaSelectionLine<T extends IHopMetadata>
extends Composite {
    private static final Class<?> PKG = MetaSelectionLine.class;
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "MetaSelectionLine-Toolbar";
    public static final String TOOLBAR_ITEM_EDIT = "10010-metadata-edit";
    public static final String TOOLBAR_ITEM_NEW = "10020-metadata-new";
    public static final String TOOLBAR_ITEM_META = "10030-metadata-perspective";
    private Composite parentComposite;
    private IHopMetadataProvider metadataProvider;
    private IVariables variables;
    private MetadataManager<T> manager;
    private Class<T> managedClass;
    private PropsUi props;
    private final Label wLabel;
    private ComboVar wCombo = null;
    private final ToolBar wToolBar;

    public MetaSelectionLine(IVariables variables, IHopMetadataProvider metadataProvider, Class<T> managedClass, Composite parentComposite, int flags, String labelText, String toolTipText) {
        this(variables, metadataProvider, managedClass, parentComposite, flags, labelText, toolTipText, false);
    }

    public MetaSelectionLine(IVariables variables, IHopMetadataProvider metadataProvider, Class<T> managedClass, Composite parentComposite, int flags, String labelText, String toolTipText, boolean leftAlignedLabel) {
        this(variables, metadataProvider, managedClass, parentComposite, flags, labelText, toolTipText, leftAlignedLabel, true);
    }

    public MetaSelectionLine(IVariables variables, IHopMetadataProvider metadataProvider, Class<T> managedClass, Composite parentComposite, int flags, String labelText, String toolTipText, boolean leftAlignedLabel, boolean negativeMargin) {
        super(parentComposite, 0);
        this.parentComposite = parentComposite;
        this.variables = variables;
        this.metadataProvider = metadataProvider;
        this.managedClass = managedClass;
        this.props = PropsUi.getInstance();
        this.manager = new MetadataManager<T>(variables, metadataProvider, managedClass, parentComposite.getShell());
        PropsUi.setLook((Widget)this);
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginLeft = 0;
        formLayout.marginRight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        int labelFlags = leftAlignedLabel ? 4 : 131076;
        this.wLabel = new Label((Composite)this, labelFlags);
        PropsUi.setLook((Widget)this.wLabel);
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        if (!leftAlignedLabel) {
            fdLabel.right = new FormAttachment(middle, negativeMargin ? -margin : 0);
        }
        fdLabel.top = new FormAttachment(0, margin + (EnvironmentUtils.getInstance().isWeb() ? 3 : 0));
        this.wLabel.setLayoutData((Object)fdLabel);
        if (labelText != null) {
            this.wLabel.setText(labelText);
        }
        this.wLabel.setToolTipText(toolTipText);
        this.wLabel.requestLayout();
        HopMetadata metadata = HopMetadataUtil.getHopMetadataAnnotation(managedClass);
        Image editImage = SwtSvgImageUtil.getImage(this.getDisplay(), managedClass.getClassLoader(), metadata.image(), (int)(16.0 * this.props.getZoomFactor()), (int)(16.0 * this.props.getZoomFactor()));
        this.addListener(12, e -> editImage.dispose());
        this.wToolBar = new ToolBar((Composite)this, 0x800100);
        PropsUi.setLook((Widget)this.wToolBar, 0);
        FormData fdToolBar = new FormData();
        fdToolBar.right = new FormAttachment(100, 0);
        fdToolBar.top = new FormAttachment(0, 0);
        this.wToolBar.setLayoutData((Object)fdToolBar);
        GuiToolbarWidgets toolbarWidgets = new GuiToolbarWidgets();
        toolbarWidgets.registerGuiPluginObject((Object)this);
        toolbarWidgets.createToolbarWidgets((Composite)this.wToolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        int textFlags = 18436;
        if (flags != 0) {
            textFlags = flags;
        }
        this.wCombo = new ComboVar(this.variables, this, textFlags, toolTipText);
        FormData fdCombo = new FormData();
        fdCombo.left = leftAlignedLabel ? (labelText == null ? new FormAttachment(0, 0) : new FormAttachment((Control)this.wLabel, margin, 131072)) : new FormAttachment(middle, 0);
        fdCombo.right = new FormAttachment((Control)this.wToolBar, -margin);
        fdCombo.top = new FormAttachment((Control)this.wLabel, 0, 0x1000000);
        this.wCombo.setLayoutData(fdCombo);
        this.wCombo.setToolTipText(toolTipText);
        PropsUi.setLook((Widget)this.wCombo);
        this.layout(true, true);
    }

    @GuiToolbarElement(root="MetaSelectionLine-Toolbar", id="10010-metadata-edit", toolTip="i18n::MetadataElement.Edit.Tooltip", imageMethod="getEditIcon")
    public void editMetadataElement() {
        if (Utils.isEmpty((CharSequence)this.wCombo.getText())) {
            this.newMetadata();
        } else {
            this.editMetadata();
        }
    }

    public static String getEditIcon(Object guiPluginObject) {
        MetaSelectionLine line = (MetaSelectionLine)((Object)guiPluginObject);
        return line.getManagedClass().getAnnotation(HopMetadata.class).image();
    }

    @GuiToolbarElement(root="MetaSelectionLine-Toolbar", id="10020-metadata-new", toolTip="i18n::MetadataElement.New.Tooltip", image="ui/images/new.svg")
    public void newMetadataElement() {
        T element = this.newMetadata();
        if (element != null) {
            this.wCombo.setText(Const.NVL((String)element.getName(), (String)""));
        }
    }

    @GuiToolbarElement(root="MetaSelectionLine-Toolbar", id="10030-metadata-perspective", toolTip="i18n::MetadataElement.View.Tooltip", image="ui/images/metadata.svg")
    public void viewInPerspective() {
        MetadataPerspective perspective = HopGui.getMetadataPerspective();
        perspective.activate();
        String elementName = this.variables.resolve(this.wCombo.getText());
        if (StringUtils.isEmpty((String)elementName)) {
            perspective.goToType(this.managedClass);
        } else {
            perspective.goToElement(this.managedClass, elementName);
        }
    }

    private String getMetadataDescription() {
        return this.managedClass.getAnnotation(HopMetadata.class).name();
    }

    protected void manageMetadata() {
    }

    protected boolean editMetadata() {
        String selected = this.wCombo.getText();
        if (StringUtils.isEmpty((String)selected)) {
            return false;
        }
        return this.manager.editMetadata(selected);
    }

    private T newMetadata() {
        T element = this.manager.newMetadata();
        if (element != null) {
            try {
                this.fillItems();
                this.getComboWidget().setText(Const.NVL((String)element.getName(), (String)""));
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error updating list of element names from the metadata", (Throwable)e);
            }
        }
        return element;
    }

    public void fillItems() throws HopException {
        List elementNames = this.manager.getSerializer().listObjectNames();
        Collections.sort(elementNames);
        this.wCombo.setItems(elementNames.toArray(new String[0]));
    }

    public T loadSelectedElement() {
        String selectedItem = this.wCombo.getText();
        if (StringUtils.isEmpty((String)selectedItem)) {
            return null;
        }
        try {
            return this.manager.loadElement(selectedItem);
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error loading element '" + selectedItem + "'", (Throwable)e);
            return null;
        }
    }

    public void addToConnectionLine(Composite parent, Control previous, T selected, ModifyListener lsMod) {
        try {
            this.fillItems();
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting list of element names from the metadata", (Throwable)e);
        }
        if (lsMod != null) {
            this.addModifyListener(lsMod);
        }
        if (selected == null) {
            if (this.getItemCount() == 1) {
                this.select(0);
            }
        } else {
            this.setText(Const.NVL((String)selected.getName(), (String)""));
        }
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        if (previous != null) {
            MetaSelectionLine metaSelectionLine = this;
            fdConnection.top = new FormAttachment(previous, metaSelectionLine.props.getMargin());
        } else {
            MetaSelectionLine metaSelectionLine = this;
            fdConnection.top = new FormAttachment(0, metaSelectionLine.props.getMargin());
        }
        this.setLayoutData(fdConnection);
    }

    public void addModifyListener(ModifyListener lsMod) {
        this.wCombo.addModifyListener(lsMod);
    }

    public void addSelectionListener(SelectionListener lsDef) {
        this.wCombo.addSelectionListener(lsDef);
    }

    public void setText(String name) {
        this.wCombo.setText(name);
    }

    public String getText() {
        return this.wCombo.getText();
    }

    public void setItems(String[] items) {
        this.wCombo.setItems(items);
    }

    public void add(String item) {
        this.wCombo.add(item);
    }

    public String[] getItems() {
        return this.wCombo.getItems();
    }

    public int getItemCount() {
        return this.wCombo.getItemCount();
    }

    public void removeAll() {
        this.wCombo.removeAll();
    }

    public void remove(int index) {
        this.wCombo.remove(index);
    }

    public void select(int index) {
        this.wCombo.select(index);
    }

    public int getSelectionIndex() {
        return this.wCombo.getSelectionIndex();
    }

    public void setEnabled(boolean flag) {
        this.wLabel.setEnabled(flag);
        this.wCombo.setEnabled(flag);
        this.wToolBar.setEnabled(flag);
    }

    public boolean setFocus() {
        return this.wCombo.setFocus();
    }

    public void addTraverseListener(TraverseListener tl) {
        this.wCombo.addTraverseListener(tl);
    }

    public CCombo getComboWidget() {
        return this.wCombo.getCComboWidget();
    }

    public Label getLabelWidget() {
        return this.wLabel;
    }

    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public IVariables getSpace() {
        return this.variables;
    }

    public Class<T> getManagedClass() {
        return this.managedClass;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public MetadataManager<T> getManager() {
        return this.manager;
    }

    public Label getwLabel() {
        return this.wLabel;
    }

    public ComboVar getwCombo() {
        return this.wCombo;
    }

    public ToolBar getwToolBar() {
        return this.wToolBar;
    }
}

