/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao;

import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.TimestampConverter;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.restriction.StreamProgress;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

@Internal
public class ChangeStreamDao {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(ChangeStreamDao.class);
    private final @UnknownKeyFor @NonNull @Initialized BigtableDataClient dataClient;
    private final @UnknownKeyFor @NonNull @Initialized String tableId;

    public ChangeStreamDao(@UnknownKeyFor @NonNull @Initialized BigtableDataClient dataClient, @UnknownKeyFor @NonNull @Initialized String tableId) {
        this.dataClient = dataClient;
        this.tableId = tableId;
    }

    public @UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> generateInitialChangeStreamPartitions() {
        return (List)this.dataClient.generateInitialChangeStreamPartitionsCallable().all().call((Object)this.tableId);
    }

    public @UnknownKeyFor @NonNull @Initialized ServerStream<@UnknownKeyFor @NonNull @Initialized ChangeStreamRecord> readChangeStreamPartition(@UnknownKeyFor @NonNull @Initialized PartitionRecord partition, @UnknownKeyFor @NonNull @Initialized StreamProgress streamProgress, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Instant endTime, @UnknownKeyFor @NonNull @Initialized org.joda.time.Duration heartbeatDuration, @UnknownKeyFor @NonNull @Initialized boolean shouldDebug) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ReadChangeStreamQuery query = ReadChangeStreamQuery.create((String)this.tableId).streamPartition(partition.getPartition());
        ChangeStreamContinuationToken currentToken = streamProgress.getCurrentToken();
        Instant startTime = partition.getStartTime();
        List<ChangeStreamContinuationToken> changeStreamContinuationTokenList = partition.getChangeStreamContinuationTokens();
        if (currentToken != null) {
            query.continuationTokens(Collections.singletonList(currentToken));
        } else if (startTime != null) {
            query.startTime(TimestampConverter.toThreetenInstant(startTime));
        } else if (changeStreamContinuationTokenList != null) {
            query.continuationTokens(changeStreamContinuationTokenList);
        } else {
            throw new IOException("Something went wrong");
        }
        if (endTime != null) {
            query.endTime(TimestampConverter.toThreetenInstant(endTime));
        }
        query.heartbeatDuration(Duration.ofMillis((long)heartbeatDuration.getMillis()));
        if (shouldDebug) {
            LOG.info("RCSP {} ReadChangeStreamRequest: {}", (Object)ByteStringRangeHelper.formatByteStringRange(partition.getPartition()), (Object)query);
        }
        return this.dataClient.readChangeStream(query);
    }
}

