/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.pubsub.v1.PushConfig;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.function.ThrowingRunnable;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.io.gcp.pubsub.TestPubsub;
import org.apache.beam.sdk.io.gcp.pubsub.TestPubsubOptions;
import org.apache.beam.sdk.state.BagState;
import org.apache.beam.sdk.state.StateSpec;
import org.apache.beam.sdk.state.StateSpecs;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPubsubSignal
implements TestRule {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TestPubsubSignal.class);
    private static final @UnknownKeyFor @NonNull @Initialized String RESULT_TOPIC_NAME = "result";
    private static final @UnknownKeyFor @NonNull @Initialized String RESULT_SUCCESS_MESSAGE = "SUCCESS";
    private static final @UnknownKeyFor @NonNull @Initialized String START_TOPIC_NAME = "start";
    private static final @UnknownKeyFor @NonNull @Initialized String START_SIGNAL_MESSAGE = "START SIGNAL";
    private final @UnknownKeyFor @NonNull @Initialized TestPubsubOptions pipelineOptions;
    private final @UnknownKeyFor @NonNull @Initialized String pubsubEndpoint;
    private @Nullable @UnknownKeyFor @Initialized TopicAdminClient topicAdmin = null;
    private @Nullable @UnknownKeyFor @Initialized SubscriptionAdminClient subscriptionAdmin = null;
    private @Nullable @UnknownKeyFor @Initialized PubsubClient.TopicPath resultTopicPath = null;
    private @Nullable @UnknownKeyFor @Initialized PubsubClient.TopicPath startTopicPath = null;
    private @Nullable @UnknownKeyFor @Initialized PubsubClient.SubscriptionPath resultSubscriptionPath = null;
    private @Nullable @UnknownKeyFor @Initialized PubsubClient.SubscriptionPath startSubscriptionPath = null;

    public static @UnknownKeyFor @NonNull @Initialized TestPubsubSignal create() {
        TestPubsubOptions options = (TestPubsubOptions)TestPipeline.testingPipelineOptions().as(TestPubsubOptions.class);
        return new TestPubsubSignal(options);
    }

    private TestPubsubSignal(@UnknownKeyFor @NonNull @Initialized TestPubsubOptions pipelineOptions) {
        this.pipelineOptions = pipelineOptions;
        this.pubsubEndpoint = PubsubOptions.targetForRootUrl(this.pipelineOptions.getPubsubRootUrl());
    }

    public @UnknownKeyFor @NonNull @Initialized Statement apply(final @UnknownKeyFor @NonNull @Initialized Statement base, final @UnknownKeyFor @NonNull @Initialized Description description) {
        return new Statement(){

            public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                if (TestPubsubSignal.this.topicAdmin != null || TestPubsubSignal.this.subscriptionAdmin != null) {
                    throw new AssertionError((Object)("Pubsub client was not shutdown in previous test. Topic path is'" + TestPubsubSignal.this.resultTopicPath + "'. Current test: " + description.getDisplayName()));
                }
                try {
                    TestPubsubSignal.this.initializePubsub(description);
                    base.evaluate();
                }
                finally {
                    TestPubsubSignal.this.tearDown();
                }
            }
        };
    }

    private void initializePubsub(@UnknownKeyFor @NonNull @Initialized Description description) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.topicAdmin = TopicAdminClient.create((TopicAdminSettings)((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(() -> ((TestPubsubOptions)this.pipelineOptions).getGcpCredential())).setEndpoint(this.pubsubEndpoint)).build());
        this.subscriptionAdmin = SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(() -> ((TestPubsubOptions)this.pipelineOptions).getGcpCredential())).setEndpoint(this.pubsubEndpoint)).build());
        PubsubClient.TopicPath resultTopicPathTmp = PubsubClient.topicPathFromName(this.pipelineOptions.getProject(), TestPubsub.createTopicName(description, RESULT_TOPIC_NAME));
        PubsubClient.TopicPath startTopicPathTmp = PubsubClient.topicPathFromName(this.pipelineOptions.getProject(), TestPubsub.createTopicName(description, START_TOPIC_NAME));
        PubsubClient.SubscriptionPath resultSubscriptionPathTmp = PubsubClient.subscriptionPathFromName(this.pipelineOptions.getProject(), "result-subscription-" + String.valueOf(ThreadLocalRandom.current().nextLong()));
        PubsubClient.SubscriptionPath startSubscriptionPathTmp = PubsubClient.subscriptionPathFromName(this.pipelineOptions.getProject(), "start-subscription-" + String.valueOf(ThreadLocalRandom.current().nextLong()));
        this.topicAdmin.createTopic(resultTopicPathTmp.getPath());
        this.resultTopicPath = resultTopicPathTmp;
        this.topicAdmin.createTopic(startTopicPathTmp.getPath());
        this.startTopicPath = startTopicPathTmp;
        this.subscriptionAdmin.createSubscription(resultSubscriptionPathTmp.getPath(), this.resultTopicPath.getPath(), PushConfig.getDefaultInstance(), 600);
        this.resultSubscriptionPath = resultSubscriptionPathTmp;
        this.subscriptionAdmin.createSubscription(startSubscriptionPathTmp.getPath(), this.startTopicPath.getPath(), PushConfig.getDefaultInstance(), 600);
        this.startSubscriptionPath = startSubscriptionPathTmp;
    }

    private static void logIfThrows(@UnknownKeyFor @NonNull @Initialized ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            LOG.error("Failed to clean up resource.", (Throwable)e);
        }
    }

    private void tearDown() {
        if (this.subscriptionAdmin == null || this.topicAdmin == null) {
            return;
        }
        if (this.resultSubscriptionPath != null) {
            TestPubsubSignal.logIfThrows(() -> this.subscriptionAdmin.deleteSubscription(this.resultSubscriptionPath.getPath()));
        }
        if (this.startSubscriptionPath != null) {
            TestPubsubSignal.logIfThrows(() -> this.subscriptionAdmin.deleteSubscription(this.startSubscriptionPath.getPath()));
        }
        if (this.resultTopicPath != null) {
            TestPubsubSignal.logIfThrows(() -> this.topicAdmin.deleteTopic(this.resultTopicPath.getPath()));
        }
        if (this.startTopicPath != null) {
            TestPubsubSignal.logIfThrows(() -> this.topicAdmin.deleteTopic(this.startTopicPath.getPath()));
        }
        TestPubsubSignal.logIfThrows(() -> ((SubscriptionAdminClient)this.subscriptionAdmin).close());
        TestPubsubSignal.logIfThrows(() -> ((TopicAdminClient)this.topicAdmin).close());
        this.subscriptionAdmin = null;
        this.topicAdmin = null;
        this.resultTopicPath = null;
        this.startTopicPath = null;
        this.resultSubscriptionPath = null;
        this.startSubscriptionPath = null;
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PDone> signalStart() {
        return new PublishStart(this.startTopicPath);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends T>, @UnknownKeyFor @NonNull @Initialized POutput> signalSuccessWhen(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized String> formatter, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Set<T>, @UnknownKeyFor @NonNull @Initialized Boolean> successPredicate) {
        return new PublishSuccessWhen<T>(coder, formatter, successPredicate, this.resultTopicPath);
    }

    public <T> @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends T>, @UnknownKeyFor @NonNull @Initialized POutput> signalSuccessWhen(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Set<T>, @UnknownKeyFor @NonNull @Initialized Boolean> successPredicate) {
        return this.signalSuccessWhen(coder, Object::toString, successPredicate);
    }

    public @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @Nullable @Initialized Void> waitForStart(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        return Suppliers.memoize(() -> {
            try {
                String result = this.pollForResultForDuration(this.startSubscriptionPath, duration);
                Preconditions.checkState((boolean)START_SIGNAL_MESSAGE.equals(result));
                return null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void waitForSuccess(@UnknownKeyFor @NonNull @Initialized Duration duration) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String result = this.pollForResultForDuration(this.resultSubscriptionPath, duration);
        if (!RESULT_SUCCESS_MESSAGE.equals(result)) {
            throw new AssertionError((Object)result);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String pollForResultForDuration(@UnknownKeyFor @NonNull @Initialized PubsubClient.SubscriptionPath signalSubscriptionPath, @UnknownKeyFor @NonNull @Initialized Duration timeoutDuration) throws @UnknownKeyFor @NonNull @Initialized IOException {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        MessageReceiver receiver = (message, replyConsumer) -> {
            LOG.info("Received message: {}", (Object)message.getData().toStringUtf8());
            if (message.getData().isEmpty()) {
                replyConsumer.ack();
            }
            if (result.compareAndSet(null, message.getData().toStringUtf8())) {
                replyConsumer.ack();
            } else {
                replyConsumer.nack();
            }
        };
        Subscriber subscriber = Subscriber.newBuilder((String)signalSubscriptionPath.getPath(), (MessageReceiver)receiver).setCredentialsProvider(() -> ((TestPubsubOptions)this.pipelineOptions).getGcpCredential()).setEndpoint(this.pubsubEndpoint).build();
        subscriber.startAsync();
        DateTime startTime = new DateTime();
        int timeoutSeconds = timeoutDuration.toStandardSeconds().getSeconds();
        while (result.get() == null && Seconds.secondsBetween((ReadableInstant)startTime, (ReadableInstant)new DateTime()).getSeconds() < timeoutSeconds) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        subscriber.stopAsync();
        subscriber.awaitTerminated();
        if (result.get() == null) {
            throw new AssertionError((Object)String.format("Did not receive signal on %s in %ss", signalSubscriptionPath, timeoutDuration.getStandardSeconds()));
        }
        return result.get();
    }

    static class StatefulPredicateCheck<@UnknownKeyFor T>
    extends DoFn<KV<String, ? extends T>, String> {
        private @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Set<T>, @UnknownKeyFor @NonNull @Initialized Boolean> successPredicate;
        private static final @UnknownKeyFor @NonNull @Initialized String SEEN_EVENTS = "seenEvents";
        @DoFn.StateId(value="seenEvents")
        private final @UnknownKeyFor @NonNull @Initialized StateSpec<@UnknownKeyFor @NonNull @Initialized BagState<T>> seenEvents;

        StatefulPredicateCheck(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized String> formatter, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Set<T>, @UnknownKeyFor @NonNull @Initialized Boolean> successPredicate) {
            this.seenEvents = StateSpecs.bag(coder);
            this.successPredicate = successPredicate;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @DoFn.StateId(value="seenEvents") @UnknownKeyFor @NonNull @Initialized BagState<T> seenEvents) {
            seenEvents.add(((KV)context.element()).getValue());
            ImmutableSet eventsSoFar = ImmutableSet.copyOf((Iterable)seenEvents.read());
            try {
                if (((Boolean)this.successPredicate.apply((Object)eventsSoFar)).booleanValue()) {
                    LOG.info("Predicate has been satisfied. Sending SUCCESS message.");
                    context.output((Object)TestPubsubSignal.RESULT_SUCCESS_MESSAGE);
                }
            }
            catch (Throwable e) {
                LOG.error("Error while applying predicate.", e);
                context.output((Object)("FAILURE: " + e.getMessage()));
            }
        }
    }

    static class PublishSuccessWhen<@UnknownKeyFor T>
    extends PTransform<PCollection<? extends T>, POutput> {
        private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized String> formatter;
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Set<T>, @UnknownKeyFor @NonNull @Initialized Boolean> successPredicate;
        private final @UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath resultTopicPath;

        PublishSuccessWhen(@UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized String> formatter, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Set<T>, @UnknownKeyFor @NonNull @Initialized Boolean> successPredicate, @UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath resultTopicPath) {
            this.coder = coder;
            this.formatter = formatter;
            this.successPredicate = successPredicate;
            this.resultTopicPath = resultTopicPath;
        }

        public @UnknownKeyFor @NonNull @Initialized POutput expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ? extends T> input) {
            return ((PCollection)((PCollection)((PCollection)input.apply((PTransform)Window.into((WindowFn)new GlobalWindows()))).apply((PTransform)WithKeys.of((Object)"dummyKey"))).apply("checkAllEventsForSuccess", (PTransform)ParDo.of(new StatefulPredicateCheck<T>(this.coder, this.formatter, this.successPredicate)))).apply("publishSuccess", PubsubIO.writeStrings().to(this.resultTopicPath.getPath()));
        }
    }

    static class PublishStart
    extends PTransform<PBegin, PDone> {
        private final @UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath startTopicPath;

        PublishStart(@UnknownKeyFor @NonNull @Initialized PubsubClient.TopicPath startTopicPath) {
            this.startTopicPath = startTopicPath;
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return (PDone)((PCollection)input.apply("Start signal", (PTransform)Create.of((Object)TestPubsubSignal.START_SIGNAL_MESSAGE, (Object[])new String[0]))).apply(PubsubIO.writeStrings().to(this.startTopicPath.getPath()));
        }
    }
}

