/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class JobQueue
implements Serializable {
    static final long serialVersionUID = 4L;
    private AS400 system_;
    private String name_;
    private String library_;
    private transient boolean loaded_;
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private String jobQueueName_;
    private String jobQueueLibrary_;
    private int numberOfJobs_;
    private String jobQueueStatus_;
    private String subsystemName_;
    private String subsystemLibrary_;
    private String textDescription_;
    private int sequenceNumber_;
    private int maxActive_;
    private int currentActive_;
    private String authorityCheck_;
    private String operatorControlled_;
    private String format_ = "JOBQ0100";
    private transient ObjectDescription objectDescription_;

    public JobQueue(AS400 aS400, String string, String string2) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("library");
        }
        if (string2 == null) {
            throw new NullPointerException("name");
        }
        this.system_ = aS400;
        this.name_ = string2;
        this.library_ = string;
    }

    public JobQueue(AS400 aS400, QSYSObjectPathName qSYSObjectPathName) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (qSYSObjectPathName == null) {
            throw new NullPointerException("path");
        }
        this.system_ = aS400;
        this.name_ = qSYSObjectPathName.getObjectName();
        this.library_ = qSYSObjectPathName.getLibraryName();
    }

    public void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, ObjectDoesNotExistException, IOException {
        int n;
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.name_ == null) {
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.library_ == null) {
            throw new ExtendedIllegalStateException("library", 4);
        }
        int n2 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n2, null);
        AS400Text aS400Text = new AS400Text(20, n2);
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(this.name_);
        for (int i = 0; i < 10 - this.name_.length(); ++i) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(this.library_);
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        int n3 = 2048;
        programParameterArray[0] = new ProgramParameter(n3);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n3));
        programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray(this.format_));
        programParameterArray[3] = new ProgramParameter(aS400Text.toBytes(stringBuffer.toString().trim().toUpperCase()));
        programParameterArray[4] = errorCode_;
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QSPRJOBQ.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray = programParameterArray[0].getOutputData();
        int n4 = BinaryConverter.byteArrayToInt(byArray, 0);
        if (n4 < (n = BinaryConverter.byteArrayToInt(byArray, 4))) {
            if (Trace.traceOn_) {
                Trace.log(1, "JobQueue: Not enough bytes, trying again. Bytes returned = " + n4 + "; bytes available = " + n);
            }
            n3 = n;
            try {
                programParameterArray[0].setOutputDataLength(n3);
                programParameterArray[1].setInputData(BinaryConverter.intToByteArray(n3));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!programCall.run()) {
                throw new AS400Exception(programCall.getMessageList());
            }
            byArray = programParameterArray[0].getOutputData();
        }
        this.jobQueueName_ = convTable.byteArrayToString(byArray, 8, 10).trim();
        this.jobQueueLibrary_ = convTable.byteArrayToString(byArray, 18, 10).trim();
        this.operatorControlled_ = convTable.byteArrayToString(byArray, 28, 10).trim();
        this.authorityCheck_ = convTable.byteArrayToString(byArray, 38, 10).trim();
        this.numberOfJobs_ = BinaryConverter.byteArrayToInt(byArray, 48);
        this.jobQueueStatus_ = convTable.byteArrayToString(byArray, 52, 10).trim();
        this.subsystemName_ = convTable.byteArrayToString(byArray, 62, 10).trim();
        this.textDescription_ = convTable.byteArrayToString(byArray, 72, 50).trim();
        this.subsystemLibrary_ = convTable.byteArrayToString(byArray, 122, 10).trim();
        this.sequenceNumber_ = BinaryConverter.byteArrayToInt(byArray, 132);
        this.maxActive_ = BinaryConverter.byteArrayToInt(byArray, 136);
        this.currentActive_ = BinaryConverter.byteArrayToInt(byArray, 140);
        this.loaded_ = true;
    }

    private void loadInformation() throws RuntimeException {
        try {
            this.refresh();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            Trace.log(2, "Exception rethrown by loadInformation():", (Throwable)exception);
            IllegalStateException illegalStateException = new IllegalStateException(exception.getMessage());
            try {
                illegalStateException.initCause(exception);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw illegalStateException;
        }
    }

    public String getJobQName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobQueueName_;
    }

    public String getJobQLibrary() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobQueueLibrary_;
    }

    public String getSubsystemName() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.subsystemName_;
    }

    public String getSubsystemLibrary() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.subsystemLibrary_;
    }

    public String getOperatorControlled() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.operatorControlled_;
    }

    public String getAuthorityCheck() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.authorityCheck_;
    }

    public int getNumberOfJobs() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.numberOfJobs_;
    }

    public String getJobQueueStatus() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.jobQueueStatus_;
    }

    public String getTextDescription() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.textDescription_;
    }

    public int getSequenceNumber() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.sequenceNumber_;
    }

    public int getMaxActive() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.maxActive_;
    }

    public int getCurrentActive() {
        if (!this.loaded_) {
            this.loadInformation();
        }
        return this.currentActive_;
    }

    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.system_ = aS400;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("name", 5);
        }
        this.name_ = string;
    }

    public void setLibraryName(String string) {
        if (string == null) {
            throw new NullPointerException("library");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("library", 5);
        }
        this.library_ = string;
    }

    public void setFormat(String string) {
        if (string == null) {
            throw new NullPointerException("format");
        }
        if (this.loaded_) {
            throw new ExtendedIllegalStateException("library", 5);
        }
        if (string.equalsIgnoreCase("JOBQ0100") || string.equalsIgnoreCase("JOBQ0200")) {
            this.format_ = string;
        }
    }

    public boolean exists() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_.exists();
    }

    public ObjectDescription getObjectDescription() {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_;
    }

    private ObjectDescription getObjDesc() {
        return new ObjectDescription(this.system_, this.library_, this.name_, "JOBQ");
    }
}

