/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.SystemValue;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VSystemValueDetailsPropertiesPane;
import com.ibm.as400.vaccess.VSystemValueModifyAction;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import javax.swing.Icon;

class VSystemValue
implements VObject {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private SystemValue systemValue_;
    private VObject[] detailsChildren_;
    private VObject[] children_;
    private VAction[] actions_;
    VPropertiesPane propertiesPane_;
    ErrorEventSupport errorEventSupport_;
    VObjectEventSupport objectEventSupport_;
    WorkingEventSupport workingEventSupport_;
    private static final Icon icon16_ = ResourceLoader.getIcon("VSystemValue16.gif", "System Values");
    private static final Icon icon32_ = ResourceLoader.getIcon("VSystemValue32.gif", "System Values");
    public static final String VALUE_PROPERTY = "Value";

    public VSystemValue(SystemValue systemValue) {
        this.systemValue_ = systemValue;
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.actions_ = new VAction[1];
        this.actions_[0] = new VSystemValueModifyAction(this);
        if (this.systemValue_.isReadOnly()) {
            this.actions_[0].setEnabled(false);
        }
        this.actions_[0].addErrorListener(this.errorEventSupport_);
        this.actions_[0].addVObjectListener(this.objectEventSupport_);
        this.actions_[0].addWorkingListener(this.workingEventSupport_);
        this.propertiesPane_ = new VSystemValueDetailsPropertiesPane(this, this.systemValue_);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectEventSupport_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public VAction[] getActions() {
        return this.actions_;
    }

    public VAction getDefaultAction() {
        return null;
    }

    public String getDescription() {
        return this.systemValue_.getDescription();
    }

    public Icon getIcon(int n, boolean bl) {
        if (n != 32) {
            return icon16_;
        }
        return icon32_;
    }

    public String getName() {
        return this.systemValue_.getName();
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        if (object == VObject.NAME_PROPERTY) {
            return this;
        }
        if (object == VObject.DESCRIPTION_PROPERTY) {
            return this.systemValue_.getDescription();
        }
        if (object == VALUE_PROPERTY) {
            Object object2 = null;
            try {
                object2 = this.systemValue_.getValue();
            }
            catch (Exception exception) {
                this.errorEventSupport_.fireError(exception);
            }
            if (object2 != null && this.systemValue_.getType() == 4) {
                String[] stringArray = (String[])object2;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i].trim();
                    if (string.length() <= 0) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(string);
                }
                return stringBuffer.toString();
            }
            return object2;
        }
        return null;
    }

    public String getText() {
        return this.systemValue_.getName();
    }

    public int getType() {
        return this.systemValue_.getType();
    }

    public Object getValue() {
        Object object = null;
        try {
            object = this.systemValue_.getValue();
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        return object;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.systemValue_.clear();
            this.systemValue_.getValue();
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
        this.workingEventSupport_.fireStopWorking();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setValue(Object object) {
        try {
            this.systemValue_.setValue(object);
            this.objectEventSupport_.fireObjectChanged(this);
        }
        catch (Exception exception) {
            this.errorEventSupport_.fireError(exception);
        }
    }
}

