/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.svg;

import java.awt.font.TextLayout;
import java.io.StringWriter;
import java.text.DecimalFormat;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.DOMGroupManager;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HopSvgGraphics2D
extends SVGGraphics2D {
    private static final String W3_URL = "http://www.w3.org/2000/xmlns/";

    public HopSvgGraphics2D(Document domFactory) {
        super(domFactory);
    }

    public DOMGroupManager getDomGroupManager() {
        return super.getDOMGroupManager();
    }

    public void drawString(String str, int x, int y) {
        if (str.contains("\\n")) {
            String[] lines = str.split("\\n");
            int lineX = x;
            int lineY = y;
            for (String line : lines) {
                TextLayout tl = new TextLayout(line, this.getFont(), this.getFontRenderContext());
                this.drawString(line, lineX, lineY);
                lineY = (int)((double)lineY + (tl.getBounds().getHeight() + (double)tl.getDescent()));
            }
        } else {
            super.drawString(str, x, y);
        }
    }

    public static HopSvgGraphics2D newDocument() {
        DOMImplementation domImplementation = GenericDOMImplementation.getDOMImplementation();
        Document document = domImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
        return new HopSvgGraphics2D(document);
    }

    public String toXml() throws TransformerException {
        Transformer transformer = XmlHandler.createSecureTransformerFactory().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult streamResult = new StreamResult(new StringWriter());
        DOMSource domSource = new DOMSource(this.getRoot());
        transformer.transform(domSource, streamResult);
        return streamResult.getWriter().toString();
    }

    private String format(double d) {
        return new DecimalFormat("0.###").format(d);
    }

    public void embedSvg(Node svgNode, String filename, int x, int y, float width, float height, float xMagnification, float yMagnification, double angleDegrees) {
        Document domFactory = this.getDOMFactory();
        float centreX = width / 2.0f;
        float centreY = height / 2.0f;
        Element svgG = domFactory.createElementNS("http://www.w3.org/2000/svg", "g");
        this.getDomGroupManager().addElement(svgG, (short)17);
        svgG.setAttributeNS(null, "stroke", "none");
        svgG.removeAttributeNS(null, "fill");
        String transformString = "translate(" + x + " " + y + ") ";
        transformString = transformString + "scale(" + this.format(xMagnification) + " " + this.format(yMagnification) + ") ";
        transformString = transformString + "rotate(" + this.format(angleDegrees) + " " + this.format(centreX) + " " + this.format(centreY) + ")";
        svgG.setAttributeNS(null, "transform", transformString);
        if (filename != null) {
            svgG.setAttributeNS(null, "filename", filename);
        }
        svgG.setAttributeNS(W3_URL, "xmlns:dc", "http://purl.org/dc/elements/1.1/");
        svgG.setAttributeNS(W3_URL, "xmlns:cc", "http://creativecommons.org/ns#");
        svgG.setAttributeNS(W3_URL, "xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        svgG.setAttributeNS(W3_URL, "xmlns:sodipodi", "http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd");
        svgG.setAttributeNS(W3_URL, "xmlns:inkscape", "http://www.inkscape.org/namespaces/inkscape");
        this.copyChildren(domFactory, svgG, svgNode);
    }

    private void copyChildren(Document domFactory, Node target, Node svgImage) {
        NodeList childNodes = svgImage.getChildNodes();
        for (int c = 0; c < childNodes.getLength(); ++c) {
            Node childNode = childNodes.item(c);
            Node childNodeCopy = domFactory.importNode(childNode, true);
            target.appendChild(childNodeCopy);
        }
    }
}

