/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.webservices.wsdl;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOpFaultList;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOpParameterList;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOpReturnType;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlTypes;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlUtils;

public final class WsdlOperation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SOAPBindingStyle _bindingStyle;
    private final SOAPBindingUse _bindingUse;
    private final WsdlOpFaultList _faults;
    private final QName _operationQName;
    private final WsdlOpParameterList _params;
    private final SOAPParameterStyle _parameterStyle;
    private final String _soapAction;
    private final WsdlOpReturnType _returnType;
    private boolean _oneway;

    protected WsdlOperation(Binding binding, Operation op, WsdlTypes wsdlTypes) throws HopException {
        this._operationQName = new QName(wsdlTypes.getTargetNamespace(), op.getName());
        this._oneway = true;
        String soapBindingStyle = WsdlUtils.getSOAPBindingStyle(binding);
        this._bindingStyle = "rpc".equals(soapBindingStyle) ? SOAPBindingStyle.RPC : SOAPBindingStyle.DOCUMENT;
        String soapBindingUse = WsdlUtils.getSOAPBindingUse(binding, op.getName());
        this._bindingUse = "encoded".equals(soapBindingUse) ? SOAPBindingUse.ENCODED : SOAPBindingUse.LITERAL;
        this._soapAction = WsdlUtils.getSOAPAction(binding.getBindingOperation(op.getName(), null, null));
        this._params = new WsdlOpParameterList(op, binding, wsdlTypes);
        this.loadParameters(op);
        this._faults = new WsdlOpFaultList(wsdlTypes);
        this.loadFaults(op);
        this._returnType = this._params.getReturnType();
        this._parameterStyle = this._params.getParameterStyle();
    }

    public WsdlOpFaultList getFaults() {
        return this._faults;
    }

    public QName getOperationQName() {
        return this._operationQName;
    }

    public String getSOAPAction() {
        return this._soapAction;
    }

    public SOAPBindingStyle getSOAPBindingStyle() {
        return this._bindingStyle;
    }

    public SOAPBindingUse getSOAPBindingUse() {
        return this._bindingUse;
    }

    public SOAPParameterStyle getSOAPParameterStyle() {
        return this._parameterStyle;
    }

    public WsdlOpParameterList getParameters() {
        return this._params;
    }

    public WsdlOpReturnType getReturnType() {
        return this._returnType;
    }

    public boolean isOneway() {
        return this._oneway;
    }

    private void loadFaults(Operation op) throws HopTransformException {
        Map faultMap = op.getFaults();
        for (Fault fault : faultMap.values()) {
            this._faults.add(fault);
        }
    }

    private void loadParameters(Operation op) throws HopTransformException {
        Output output;
        Input input = op.getInput();
        if (input != null) {
            Message in = input.getMessage();
            List paramOrdering = op.getParameterOrdering();
            List inParts = in.getOrderedParts(paramOrdering);
            for (Part part : inParts) {
                this._params.add(part, true);
            }
        }
        if ((output = op.getOutput()) != null) {
            Message out = output.getMessage();
            List outParts = out.getOrderedParts(null);
            for (Part part : outParts) {
                this._oneway = false;
                this._params.add(part, false);
            }
        }
    }

    public static enum SOAPBindingUse {
        LITERAL,
        ENCODED;

    }

    public static enum SOAPBindingStyle {
        DOCUMENT,
        RPC;

    }

    public static enum SOAPParameterStyle {
        BARE,
        WRAPPED;

    }
}

