/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.changestream;

import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecordAdapter;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.common.base.Preconditions;
import org.threeten.bp.Instant;

final class ChangeStreamStateMachine<ChangeStreamRecordT> {
    private final ChangeStreamRecordAdapter.ChangeStreamRecordBuilder<ChangeStreamRecordT> builder;
    private State currentState;
    private int numHeartbeats = 0;
    private int numCloseStreams = 0;
    private int numDataChanges = 0;
    private int numNonCellMods = 0;
    private int numCellChunks = 0;
    private int expectedTotalSizeOfChunkedSetCell = 0;
    private int actualTotalSizeOfChunkedSetCell = 0;
    private ChangeStreamRecordT completeChangeStreamRecord;
    private final State AWAITING_NEW_STREAM_RECORD = new State(){

        @Override
        State handleHeartbeat(ReadChangeStreamResponse.Heartbeat heartbeat) {
            ChangeStreamStateMachine.this.validate(ChangeStreamStateMachine.this.completeChangeStreamRecord == null, "AWAITING_NEW_STREAM_RECORD: Existing ChangeStreamRecord not consumed yet.");
            ChangeStreamStateMachine.this.completeChangeStreamRecord = ChangeStreamStateMachine.this.builder.onHeartbeat(heartbeat);
            return ChangeStreamStateMachine.this.AWAITING_STREAM_RECORD_CONSUME;
        }

        @Override
        State handleCloseStream(ReadChangeStreamResponse.CloseStream closeStream) {
            ChangeStreamStateMachine.this.validate(ChangeStreamStateMachine.this.completeChangeStreamRecord == null, "AWAITING_NEW_STREAM_RECORD: Existing ChangeStreamRecord not consumed yet.");
            ChangeStreamStateMachine.this.completeChangeStreamRecord = ChangeStreamStateMachine.this.builder.onCloseStream(closeStream);
            return ChangeStreamStateMachine.this.AWAITING_STREAM_RECORD_CONSUME;
        }

        @Override
        State handleDataChange(ReadChangeStreamResponse.DataChange dataChange) {
            ChangeStreamStateMachine.this.validate(ChangeStreamStateMachine.this.completeChangeStreamRecord == null, "AWAITING_NEW_STREAM_RECORD: Existing ChangeStreamRecord not consumed yet.");
            ChangeStreamStateMachine.this.validate(!dataChange.getRowKey().isEmpty(), "AWAITING_NEW_STREAM_RECORD: First data change missing rowKey.");
            ChangeStreamStateMachine.this.validate(dataChange.hasCommitTimestamp(), "AWAITING_NEW_STREAM_RECORD: First data change missing commit timestamp.");
            ChangeStreamStateMachine.this.validate(dataChange.getChunksCount() > 0, "AWAITING_NEW_STREAM_RECORD: First data change missing mods.");
            if (dataChange.getType() == ReadChangeStreamResponse.DataChange.Type.GARBAGE_COLLECTION) {
                ChangeStreamStateMachine.this.validate(dataChange.getSourceClusterId().isEmpty(), "AWAITING_NEW_STREAM_RECORD: GC mutation shouldn't have source cluster id.");
                ChangeStreamStateMachine.this.builder.startGcMutation(dataChange.getRowKey(), Instant.ofEpochSecond((long)dataChange.getCommitTimestamp().getSeconds(), (long)dataChange.getCommitTimestamp().getNanos()), dataChange.getTiebreaker());
            } else if (dataChange.getType() == ReadChangeStreamResponse.DataChange.Type.USER) {
                ChangeStreamStateMachine.this.validate(!dataChange.getSourceClusterId().isEmpty(), "AWAITING_NEW_STREAM_RECORD: User initiated data change missing source cluster id.");
                ChangeStreamStateMachine.this.builder.startUserMutation(dataChange.getRowKey(), dataChange.getSourceClusterId(), Instant.ofEpochSecond((long)dataChange.getCommitTimestamp().getSeconds(), (long)dataChange.getCommitTimestamp().getNanos()), dataChange.getTiebreaker());
            } else {
                ChangeStreamStateMachine.this.validate(false, "AWAITING_NEW_STREAM_RECORD: Unexpected type: " + dataChange.getType());
            }
            return ChangeStreamStateMachine.this.AWAITING_NEW_DATA_CHANGE.handleDataChange(dataChange);
        }
    };
    private final State AWAITING_NEW_DATA_CHANGE = new State(){

        @Override
        State handleHeartbeat(ReadChangeStreamResponse.Heartbeat heartbeat) {
            throw new IllegalStateException("AWAITING_NEW_DATA_CHANGE: Can't handle a Heartbeat in the middle of building a ChangeStreamMutation.");
        }

        @Override
        State handleCloseStream(ReadChangeStreamResponse.CloseStream closeStream) {
            throw new IllegalStateException("AWAITING_NEW_DATA_CHANGE: Can't handle a CloseStream in the middle of building a ChangeStreamMutation.");
        }

        @Override
        State handleDataChange(ReadChangeStreamResponse.DataChange dataChange) {
            for (int index = 0; index < dataChange.getChunksCount(); ++index) {
                ReadChangeStreamResponse.MutationChunk chunk = dataChange.getChunks(index);
                Mutation mod = chunk.getMutation();
                if (mod.hasSetCell()) {
                    Mutation.SetCell setCell = chunk.getMutation().getSetCell();
                    if (!chunk.hasChunkInfo()) {
                        ChangeStreamStateMachine.this.builder.startCell(setCell.getFamilyName(), setCell.getColumnQualifier(), setCell.getTimestampMicros());
                        ChangeStreamStateMachine.this.numCellChunks++;
                        ChangeStreamStateMachine.this.builder.cellValue(setCell.getValue());
                        ChangeStreamStateMachine.this.builder.finishCell();
                        continue;
                    }
                    if (chunk.getChunkInfo().getChunkedValueOffset() == 0) {
                        ChangeStreamStateMachine.this.validate(chunk.getChunkInfo().getChunkedValueSize() > 0, "AWAITING_NEW_DATA_CHANGE: First chunk of a chunked cell must have a positive chunked value size.");
                        ChangeStreamStateMachine.this.expectedTotalSizeOfChunkedSetCell = chunk.getChunkInfo().getChunkedValueSize();
                        ChangeStreamStateMachine.this.actualTotalSizeOfChunkedSetCell = 0;
                        ChangeStreamStateMachine.this.builder.startCell(setCell.getFamilyName(), setCell.getColumnQualifier(), setCell.getTimestampMicros());
                    } else {
                        ChangeStreamStateMachine.this.validate(index == 0, "AWAITING_NEW_DATA_CHANGE: Non-first chunked SetCell must be the first mod of a DataChange.");
                    }
                    ChangeStreamStateMachine.this.validate(chunk.getChunkInfo().getChunkedValueSize() == ChangeStreamStateMachine.this.expectedTotalSizeOfChunkedSetCell, "AWAITING_NEW_DATA_CHANGE: Chunked cell value size must be the same for all chunks.");
                    ChangeStreamStateMachine.this.numCellChunks++;
                    ChangeStreamStateMachine.this.builder.cellValue(setCell.getValue());
                    ChangeStreamStateMachine.this.actualTotalSizeOfChunkedSetCell = ChangeStreamStateMachine.this.actualTotalSizeOfChunkedSetCell + setCell.getValue().size();
                    if (chunk.getChunkInfo().getLastChunk()) {
                        ChangeStreamStateMachine.this.builder.finishCell();
                        ChangeStreamStateMachine.this.validate(ChangeStreamStateMachine.this.actualTotalSizeOfChunkedSetCell == ChangeStreamStateMachine.this.expectedTotalSizeOfChunkedSetCell, "Chunked value size in ChunkInfo doesn't match the actual total size. Expected total size: " + ChangeStreamStateMachine.this.expectedTotalSizeOfChunkedSetCell + "; actual total size: " + ChangeStreamStateMachine.this.actualTotalSizeOfChunkedSetCell);
                        continue;
                    }
                    ChangeStreamStateMachine.this.validate(index == dataChange.getChunksCount() - 1, "AWAITING_NEW_DATA_CHANGE: Current mod is a chunked SetCell but not the last chunk, but it's not the last mod of the current response.");
                    return ChangeStreamStateMachine.this.AWAITING_NEW_DATA_CHANGE;
                }
                if (mod.hasDeleteFromFamily()) {
                    ChangeStreamStateMachine.this.numNonCellMods++;
                    ChangeStreamStateMachine.this.builder.deleteFamily(mod.getDeleteFromFamily().getFamilyName());
                    continue;
                }
                if (mod.hasDeleteFromColumn()) {
                    ChangeStreamStateMachine.this.numNonCellMods++;
                    ChangeStreamStateMachine.this.builder.deleteCells(mod.getDeleteFromColumn().getFamilyName(), mod.getDeleteFromColumn().getColumnQualifier(), Range.TimestampRange.create(mod.getDeleteFromColumn().getTimeRange().getStartTimestampMicros(), mod.getDeleteFromColumn().getTimeRange().getEndTimestampMicros()));
                    continue;
                }
                throw new IllegalStateException("AWAITING_NEW_DATA_CHANGE: Unexpected mod type");
            }
            return ChangeStreamStateMachine.this.checkAndFinishMutationIfNeeded(dataChange);
        }
    };
    private final State AWAITING_STREAM_RECORD_CONSUME = new State(){

        @Override
        State handleHeartbeat(ReadChangeStreamResponse.Heartbeat heartbeat) {
            throw new IllegalStateException("AWAITING_STREAM_RECORD_CONSUME: Skipping completed change stream record.");
        }

        @Override
        State handleCloseStream(ReadChangeStreamResponse.CloseStream closeStream) {
            throw new IllegalStateException("AWAITING_STREAM_RECORD_CONSUME: Skipping completed change stream record.");
        }

        @Override
        State handleDataChange(ReadChangeStreamResponse.DataChange dataChange) {
            throw new IllegalStateException("AWAITING_STREAM_RECORD_CONSUME: Skipping completed change stream record.");
        }
    };
    private final State ERROR = new State(){

        @Override
        State handleHeartbeat(ReadChangeStreamResponse.Heartbeat heartbeat) {
            throw new IllegalStateException("ERROR: Failed to handle Heartbeat.");
        }

        @Override
        State handleCloseStream(ReadChangeStreamResponse.CloseStream closeStream) {
            throw new IllegalStateException("ERROR: Failed to handle CloseStream.");
        }

        @Override
        State handleDataChange(ReadChangeStreamResponse.DataChange dataChange) {
            throw new IllegalStateException("ERROR: Failed to handle DataChange.");
        }
    };

    ChangeStreamStateMachine(ChangeStreamRecordAdapter.ChangeStreamRecordBuilder<ChangeStreamRecordT> builder) {
        this.builder = builder;
        this.reset();
    }

    void handleHeartbeat(ReadChangeStreamResponse.Heartbeat heartbeat) {
        try {
            ++this.numHeartbeats;
            this.currentState = this.currentState.handleHeartbeat(heartbeat);
        }
        catch (RuntimeException e) {
            this.currentState = this.ERROR;
            throw e;
        }
    }

    void handleCloseStream(ReadChangeStreamResponse.CloseStream closeStream) {
        try {
            ++this.numCloseStreams;
            this.currentState = this.currentState.handleCloseStream(closeStream);
        }
        catch (RuntimeException e) {
            this.currentState = this.ERROR;
            throw e;
        }
    }

    void handleDataChange(ReadChangeStreamResponse.DataChange dataChange) {
        try {
            ++this.numDataChanges;
            this.currentState = this.currentState.handleDataChange(dataChange);
        }
        catch (RuntimeException e) {
            this.currentState = this.ERROR;
            throw e;
        }
    }

    ChangeStreamRecordT consumeChangeStreamRecord() {
        Preconditions.checkState((this.completeChangeStreamRecord != null ? 1 : 0) != 0, (Object)"No change stream record to consume.");
        Preconditions.checkState((this.currentState == this.AWAITING_STREAM_RECORD_CONSUME ? 1 : 0) != 0, (Object)("Change stream record is not ready to consume: " + this.currentState));
        ChangeStreamRecordT changeStreamRecord = this.completeChangeStreamRecord;
        this.reset();
        return changeStreamRecord;
    }

    boolean hasCompleteChangeStreamRecord() {
        return this.completeChangeStreamRecord != null && this.currentState == this.AWAITING_STREAM_RECORD_CONSUME;
    }

    boolean isChangeStreamRecordInProgress() {
        return this.currentState != this.AWAITING_NEW_STREAM_RECORD;
    }

    private void reset() {
        this.currentState = this.AWAITING_NEW_STREAM_RECORD;
        this.numHeartbeats = 0;
        this.numCloseStreams = 0;
        this.numDataChanges = 0;
        this.numNonCellMods = 0;
        this.numCellChunks = 0;
        this.expectedTotalSizeOfChunkedSetCell = 0;
        this.actualTotalSizeOfChunkedSetCell = 0;
        this.completeChangeStreamRecord = null;
        this.builder.reset();
    }

    private State checkAndFinishMutationIfNeeded(ReadChangeStreamResponse.DataChange dataChange) {
        if (dataChange.getDone()) {
            this.validate(!dataChange.getToken().isEmpty(), "Last data change missing token");
            this.validate(dataChange.hasEstimatedLowWatermark(), "Last data change missing lowWatermark");
            this.completeChangeStreamRecord = this.builder.finishChangeStreamMutation(dataChange.getToken(), Instant.ofEpochSecond((long)dataChange.getEstimatedLowWatermark().getSeconds(), (long)dataChange.getEstimatedLowWatermark().getNanos()));
            return this.AWAITING_STREAM_RECORD_CONSUME;
        }
        return this.AWAITING_NEW_DATA_CHANGE;
    }

    private void validate(boolean condition, String message) {
        if (!condition) {
            throw new InvalidInputException(message + ". numHeartbeats: " + this.numHeartbeats + ", numCloseStreams: " + this.numCloseStreams + ", numDataChanges: " + this.numDataChanges + ", numNonCellMods: " + this.numNonCellMods + ", numCellChunks: " + this.numCellChunks + ", expectedTotalSizeOfChunkedSetCell: " + this.expectedTotalSizeOfChunkedSetCell + ", actualTotalSizeOfChunkedSetCell: " + this.actualTotalSizeOfChunkedSetCell);
        }
    }

    static class InvalidInputException
    extends RuntimeException {
        InvalidInputException(String message) {
            super(message);
        }
    }

    static abstract class State {
        State() {
        }

        State handleHeartbeat(ReadChangeStreamResponse.Heartbeat heartbeat) {
            throw new IllegalStateException();
        }

        State handleCloseStream(ReadChangeStreamResponse.CloseStream closeStream) {
            throw new IllegalStateException();
        }

        State handleDataChange(ReadChangeStreamResponse.DataChange dataChange) {
            throw new IllegalStateException();
        }
    }
}

