/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.reservoirsampling;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;

public class ReservoirSamplingData
extends BaseTransformData
implements ITransformData {
    protected IRowMeta outputRowMeta;
    protected List<Object[]> samples = null;
    protected int sampleSize;
    protected int currentInputRow;
    protected Random random;
    protected PROC_MODE state;

    public void setOutputRowMeta(IRowMeta rmi) {
        this.outputRowMeta = rmi;
    }

    public IRowMeta getOutputRowMeta() {
        return this.outputRowMeta;
    }

    public List<Object[]> getSamples() {
        return this.samples;
    }

    public void initialize(int sampleSize, int seed) {
        this.sampleSize = sampleSize;
        this.state = this.sampleSize == 0 ? PROC_MODE.PASS_THROUGH : (this.sampleSize < 0 ? PROC_MODE.DISABLED : PROC_MODE.SAMPLING);
        this.samples = this.sampleSize > 0 ? new ArrayList(this.sampleSize) : new ArrayList();
        this.currentInputRow = 0;
        this.random = new Random(seed);
        for (int i = 0; i < 100; ++i) {
            this.random.nextDouble();
        }
    }

    public PROC_MODE getProcessingMode() {
        return this.state;
    }

    public void setProcessingMode(PROC_MODE state) {
        this.state = state;
    }

    public void addRowToSamples(Object[] row) {
        double r;
        if (this.currentInputRow < this.sampleSize) {
            this.setElement(this.samples, this.currentInputRow, row);
        } else if (this.sampleSize > 0 && (r = this.random.nextDouble()) < (double)this.sampleSize / (double)this.currentInputRow) {
            r = this.random.nextDouble();
            int replace = (int)((double)this.sampleSize * r);
            this.setElement(this.samples, replace, row);
        }
        ++this.currentInputRow;
    }

    private void setElement(List<Object[]> list, int idx, Object item) {
        int size = list.size();
        if (size <= idx) {
            int buff = size == 0 ? 100 : size * 2;
            for (int i = 0; i < buff; ++i) {
                list.add(null);
            }
        }
        list.set(idx, (Object[])item);
    }

    public void cleanUp() {
        this.samples = null;
    }

    public static enum PROC_MODE {
        SAMPLING,
        PASS_THROUGH,
        DISABLED;

    }
}

