/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.except;

import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import ru.yandex.clickhouse.except.ClickHouseErrorCode;
import ru.yandex.clickhouse.except.ClickHouseException;
import ru.yandex.clickhouse.except.ClickHouseUnknownException;
import ru.yandex.clickhouse.util.Utils;

public final class ClickHouseExceptionSpecifier {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseExceptionSpecifier.class);

    private ClickHouseExceptionSpecifier() {
    }

    public static ClickHouseException specify(Throwable cause, String host, int port) {
        return ClickHouseExceptionSpecifier.specify(cause != null ? cause.getMessage() : null, cause, host, port);
    }

    public static ClickHouseException specify(String clickHouseMessage, String host, int port) {
        return ClickHouseExceptionSpecifier.specify(clickHouseMessage, null, host, port);
    }

    public static ClickHouseException specify(String clickHouseMessage) {
        return ClickHouseExceptionSpecifier.specify(clickHouseMessage, "unknown", -1);
    }

    private static ClickHouseException specify(String clickHouseMessage, Throwable cause, String host, int port) {
        if (Utils.isNullOrEmptyString(clickHouseMessage) && cause != null) {
            return ClickHouseExceptionSpecifier.getException(cause, host, port);
        }
        try {
            Throwable messageHolder;
            int code = clickHouseMessage.startsWith("Poco::Exception. Code: 1000, ") ? 1000 : ClickHouseExceptionSpecifier.getErrorCode(clickHouseMessage);
            Throwable throwable = messageHolder = cause != null ? cause : new Throwable(clickHouseMessage);
            if (code == -1) {
                return ClickHouseExceptionSpecifier.getException(messageHolder, host, port);
            }
            return new ClickHouseException(code, messageHolder, host, port);
        }
        catch (Exception e) {
            log.error((Object)"Unsupported ClickHouse error format, please fix ClickHouseExceptionSpecifier, message: %s, error: %s", clickHouseMessage, e.getMessage());
            return new ClickHouseUnknownException(clickHouseMessage, cause, host, port);
        }
    }

    private static int getErrorCode(String errorMessage) {
        int startIndex = errorMessage.indexOf(32);
        if (startIndex >= 0) {
            int len = errorMessage.length();
            for (int i = ++startIndex; i < len; ++i) {
                char ch = errorMessage.charAt(i);
                if (ch != '.' && ch != ',' && !Character.isWhitespace(ch)) continue;
                try {
                    return Integer.parseInt(errorMessage.substring(startIndex, i));
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
        }
        return -1;
    }

    private static ClickHouseException getException(Throwable cause, String host, int port) {
        if (cause instanceof SocketTimeoutException) {
            return new ClickHouseException(ClickHouseErrorCode.TIMEOUT_EXCEEDED.code, cause, host, port);
        }
        if (cause instanceof ConnectTimeoutException || cause instanceof ConnectException) {
            return new ClickHouseException(ClickHouseErrorCode.NETWORK_ERROR.code, cause, host, port);
        }
        return new ClickHouseUnknownException(cause, host, port);
    }
}

