/*
 * Decompiled with CFR 0.152.
 */
package com.google.datastore.v1.client;

import com.google.datastore.v1.AllocateIdsRequest;
import com.google.datastore.v1.AllocateIdsResponse;
import com.google.datastore.v1.BeginTransactionRequest;
import com.google.datastore.v1.BeginTransactionResponse;
import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.LookupRequest;
import com.google.datastore.v1.LookupResponse;
import com.google.datastore.v1.ReserveIdsRequest;
import com.google.datastore.v1.ReserveIdsResponse;
import com.google.datastore.v1.RollbackRequest;
import com.google.datastore.v1.RollbackResponse;
import com.google.datastore.v1.RunAggregationQueryRequest;
import com.google.datastore.v1.RunAggregationQueryResponse;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.RemoteRpc;
import com.google.protobuf.MessageLite;
import com.google.rpc.Code;
import java.io.IOException;
import java.io.InputStream;

public class Datastore {
    final RemoteRpc remoteRpc;

    Datastore(RemoteRpc remoteRpc) {
        this.remoteRpc = remoteRpc;
    }

    public void resetRpcCount() {
        this.remoteRpc.resetRpcCount();
    }

    public int getRpcCount() {
        return this.remoteRpc.getRpcCount();
    }

    private DatastoreException invalidResponseException(String method, IOException exception) {
        return RemoteRpc.makeException(this.remoteRpc.getUrl(), method, Code.UNAVAILABLE, "Invalid response", exception);
    }

    public AllocateIdsResponse allocateIds(AllocateIdsRequest request) throws DatastoreException {
        AllocateIdsResponse allocateIdsResponse;
        block8: {
            InputStream is = this.remoteRpc.call("allocateIds", (MessageLite)request, request.getProjectId(), request.getDatabaseId());
            try {
                allocateIdsResponse = AllocateIdsResponse.parseFrom((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("allocateIds", exception);
                }
            }
            is.close();
        }
        return allocateIdsResponse;
    }

    public BeginTransactionResponse beginTransaction(BeginTransactionRequest request) throws DatastoreException {
        BeginTransactionResponse beginTransactionResponse;
        block8: {
            InputStream is = this.remoteRpc.call("beginTransaction", (MessageLite)request, request.getProjectId(), request.getDatabaseId());
            try {
                beginTransactionResponse = BeginTransactionResponse.parseFrom((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("beginTransaction", exception);
                }
            }
            is.close();
        }
        return beginTransactionResponse;
    }

    public CommitResponse commit(CommitRequest request) throws DatastoreException {
        CommitResponse commitResponse;
        block8: {
            InputStream is = this.remoteRpc.call("commit", (MessageLite)request, request.getProjectId(), request.getDatabaseId());
            try {
                commitResponse = CommitResponse.parseFrom((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("commit", exception);
                }
            }
            is.close();
        }
        return commitResponse;
    }

    public LookupResponse lookup(LookupRequest request) throws DatastoreException {
        LookupResponse lookupResponse;
        block8: {
            InputStream is = this.remoteRpc.call("lookup", (MessageLite)request, request.getProjectId(), request.getDatabaseId());
            try {
                lookupResponse = LookupResponse.parseFrom((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("lookup", exception);
                }
            }
            is.close();
        }
        return lookupResponse;
    }

    public ReserveIdsResponse reserveIds(ReserveIdsRequest request) throws DatastoreException {
        ReserveIdsResponse reserveIdsResponse;
        block8: {
            InputStream is = this.remoteRpc.call("reserveIds", (MessageLite)request, request.getProjectId(), request.getDatabaseId());
            try {
                reserveIdsResponse = ReserveIdsResponse.parseFrom((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("reserveIds", exception);
                }
            }
            is.close();
        }
        return reserveIdsResponse;
    }

    public RollbackResponse rollback(RollbackRequest request) throws DatastoreException {
        RollbackResponse rollbackResponse;
        block8: {
            InputStream is = this.remoteRpc.call("rollback", (MessageLite)request, request.getProjectId(), request.getDatabaseId());
            try {
                rollbackResponse = RollbackResponse.parseFrom((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("rollback", exception);
                }
            }
            is.close();
        }
        return rollbackResponse;
    }

    public RunQueryResponse runQuery(RunQueryRequest request) throws DatastoreException {
        RunQueryResponse runQueryResponse;
        block8: {
            InputStream is = this.remoteRpc.call("runQuery", (MessageLite)request, request.getProjectId(), request.getDatabaseId());
            try {
                runQueryResponse = RunQueryResponse.parseFrom((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("runQuery", exception);
                }
            }
            is.close();
        }
        return runQueryResponse;
    }

    public RunAggregationQueryResponse runAggregationQuery(RunAggregationQueryRequest request) throws DatastoreException {
        RunAggregationQueryResponse runAggregationQueryResponse;
        block8: {
            InputStream is = this.remoteRpc.call("runAggregationQuery", (MessageLite)request, request.getProjectId(), request.getDatabaseId());
            try {
                runAggregationQueryResponse = RunAggregationQueryResponse.parseFrom((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw this.invalidResponseException("runAggregationQuery", exception);
                }
            }
            is.close();
        }
        return runAggregationQueryResponse;
    }
}

