/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.flink.runtime.messages.ThreadInfoSample;
import org.apache.flink.runtime.taskexecutor.SampleableTask;
import org.apache.flink.runtime.util.JvmUtils;
import org.apache.flink.runtime.webmonitor.threadinfo.ThreadInfoSamplesRequest;
import org.apache.flink.util.Preconditions;

class ThreadInfoSampleService
implements Closeable {
    private final ScheduledExecutorService scheduledExecutor;

    ThreadInfoSampleService(ScheduledExecutorService scheduledExecutor) {
        this.scheduledExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutor, (String)"scheduledExecutor must not be null");
    }

    public CompletableFuture<Collection<ThreadInfoSample>> requestThreadInfoSamples(Collection<? extends SampleableTask> tasks, ThreadInfoSamplesRequest requestParams) {
        Preconditions.checkNotNull(tasks, (String)"task must not be null");
        Preconditions.checkNotNull((Object)requestParams, (String)"requestParams must not be null");
        CompletableFuture<Collection<ThreadInfoSample>> resultFuture = new CompletableFuture<Collection<ThreadInfoSample>>();
        this.scheduledExecutor.execute(() -> this.requestThreadInfoSamples(tasks, requestParams.getNumSamples(), requestParams.getDelayBetweenSamples(), requestParams.getMaxStackTraceDepth(), new ArrayList<ThreadInfoSample>(requestParams.getNumSamples()), resultFuture));
        return resultFuture;
    }

    private void requestThreadInfoSamples(Collection<? extends SampleableTask> tasks, int numSamples, Duration delayBetweenSamples, int maxStackTraceDepth, Collection<ThreadInfoSample> currentTraces, CompletableFuture<Collection<ThreadInfoSample>> resultFuture) {
        Collection threadIds = tasks.stream().map(t -> t.getExecutingThread().getId()).collect(Collectors.toList());
        Collection<ThreadInfoSample> threadInfoSample = JvmUtils.createThreadInfoSample(threadIds, maxStackTraceDepth);
        if (!threadInfoSample.isEmpty()) {
            currentTraces.addAll(threadInfoSample);
            if (numSamples > 1) {
                this.scheduledExecutor.schedule(() -> this.requestThreadInfoSamples(tasks, numSamples - 1, delayBetweenSamples, maxStackTraceDepth, currentTraces, resultFuture), delayBetweenSamples.toMillis(), TimeUnit.MILLISECONDS);
            } else {
                resultFuture.complete(currentTraces);
            }
        } else if (!currentTraces.isEmpty()) {
            resultFuture.complete(currentTraces);
        } else {
            String ids = tasks.stream().map(SampleableTask::getExecutionId).map(e -> e == null ? "unknown" : e.toString()).collect(Collectors.joining(", ", "[", "]"));
            resultFuture.completeExceptionally(new IllegalStateException(String.format("Cannot sample tasks %s. The tasks are not running.", ids)));
        }
    }

    @Override
    public void close() throws IOException {
        this.scheduledExecutor.shutdownNow();
    }
}

