/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.engines.local;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.config.IPipelineEngineRunConfiguration;
import org.apache.hop.pipeline.engines.EmptyPipelineRunConfiguration;

@GuiPlugin(description="Local pipeline run configuration widgets")
public class LocalPipelineRunConfiguration
extends EmptyPipelineRunConfiguration
implements IPipelineEngineRunConfiguration {
    @GuiWidgetElement(id="rowSetSize", order="010", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.RowSetSize.Label")
    @HopMetadataProperty(key="rowset_size")
    protected String rowSetSize;
    @GuiWidgetElement(id="safeModeEnabled", order="020", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.SafeModeEnabled.Label")
    @HopMetadataProperty(key="safe_mode")
    protected boolean safeModeEnabled;
    @GuiWidgetElement(id="gatheringMetrics", order="030", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.GatheringMetrics.Label")
    @HopMetadataProperty(key="gather_metrics")
    protected boolean gatheringMetrics;
    @GuiWidgetElement(id="sortTransformsTopologically", order="040", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.SortTransformsTopologically.Label")
    @HopMetadataProperty(key="topo_sort")
    protected boolean sortingTransformsTopologically;
    @GuiWidgetElement(id="feedbackShown", order="050", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.FeedbackShown.Label")
    @HopMetadataProperty(key="show_feedback")
    protected boolean feedbackShown;
    @GuiWidgetElement(id="feedbackSize", order="060", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.FeedbackSize.Label")
    @HopMetadataProperty(key="feedback_size")
    protected String feedbackSize;
    @GuiWidgetElement(id="waitTime", order="070", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.WaitTime.Label")
    @HopMetadataProperty(key="wait_time")
    protected String waitTime;
    @GuiWidgetElement(id="sampleTypeInGui", order="080", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.COMBO, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.SampleTypeInGui.Label", comboValuesMethod="getSampleTypes")
    @HopMetadataProperty(key="sample_type_in_gui")
    protected String sampleTypeInGui;
    @GuiWidgetElement(id="sampleSize", order="090", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.SampleSize.Label")
    @HopMetadataProperty(key="sample_size")
    protected String sampleSize;
    @GuiWidgetElement(id="transactional", order="100", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.Transactional.Label", toolTip="i18n:org.apache.hop.ui.pipeline.config:PipelineRunConfigurationDialog.Transactional.ToolTip")
    @HopMetadataProperty(key="transactional")
    protected boolean transactional;

    public LocalPipelineRunConfiguration() {
        this.rowSetSize = Integer.toString(10000);
        this.feedbackShown = false;
        this.feedbackSize = Integer.toString(50000);
        this.waitTime = EnvUtil.getSystemProperty((String)"HOP_DEFAULT_BUFFER_POLLING_WAITTIME", (String)"20");
        this.sampleTypeInGui = SampleType.Last.name();
        this.sampleSize = "100";
        this.transactional = false;
    }

    public LocalPipelineRunConfiguration(LocalPipelineRunConfiguration config) {
        super(config);
        this.rowSetSize = config.rowSetSize;
        this.feedbackShown = config.feedbackShown;
        this.feedbackSize = config.feedbackSize;
        this.waitTime = config.waitTime;
        this.safeModeEnabled = config.safeModeEnabled;
        this.gatheringMetrics = config.gatheringMetrics;
        this.sortingTransformsTopologically = config.sortingTransformsTopologically;
        this.sampleTypeInGui = config.sampleTypeInGui;
        this.sampleSize = config.sampleSize;
        this.transactional = config.transactional;
    }

    @Override
    public LocalPipelineRunConfiguration clone() {
        return new LocalPipelineRunConfiguration(this);
    }

    public List<String> getSampleTypes(ILogChannel log, IHopMetadataProvider metadataProvider) {
        ArrayList<String> list = new ArrayList<String>();
        for (SampleType type : SampleType.values()) {
            list.add(type.name());
        }
        return list;
    }

    public String getRowSetSize() {
        return this.rowSetSize;
    }

    public void setRowSetSize(String rowSetSize) {
        this.rowSetSize = rowSetSize;
    }

    public boolean isSafeModeEnabled() {
        return this.safeModeEnabled;
    }

    public void setSafeModeEnabled(boolean safeModeEnabled) {
        this.safeModeEnabled = safeModeEnabled;
    }

    public boolean isGatheringMetrics() {
        return this.gatheringMetrics;
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        this.gatheringMetrics = gatheringMetrics;
    }

    public boolean isSortingTransformsTopologically() {
        return this.sortingTransformsTopologically;
    }

    public void setSortingTransformsTopologically(boolean sortingTransformsTopologically) {
        this.sortingTransformsTopologically = sortingTransformsTopologically;
    }

    public boolean isFeedbackShown() {
        return this.feedbackShown;
    }

    public void setFeedbackShown(boolean feedbackShown) {
        this.feedbackShown = feedbackShown;
    }

    public String getFeedbackSize() {
        return this.feedbackSize;
    }

    public void setFeedbackSize(String feedbackSize) {
        this.feedbackSize = feedbackSize;
    }

    public String getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(String waitTime) {
        this.waitTime = waitTime;
    }

    public String getSampleTypeInGui() {
        return this.sampleTypeInGui;
    }

    public void setSampleTypeInGui(String sampleTypeInGui) {
        this.sampleTypeInGui = sampleTypeInGui;
    }

    public String getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(String sampleSize) {
        this.sampleSize = sampleSize;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public static enum SampleType {
        None,
        First,
        Last,
        Random;

    }
}

