/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkRunner;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.PipelineRunner;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.UserCodeException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TestFlinkRunner
extends PipelineRunner<PipelineResult> {
    private @UnknownKeyFor @NonNull @Initialized FlinkRunner delegate;

    private TestFlinkRunner(@UnknownKeyFor @NonNull @Initialized FlinkPipelineOptions options) {
        options.setRunner(TestFlinkRunner.class);
        if (options.getParallelism() == -1) {
            options.setParallelism(1);
        }
        this.delegate = FlinkRunner.fromOptions(options);
    }

    public static @UnknownKeyFor @NonNull @Initialized TestFlinkRunner fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        FlinkPipelineOptions flinkOptions = (FlinkPipelineOptions)options.as(FlinkPipelineOptions.class);
        return new TestFlinkRunner(flinkOptions);
    }

    public static @UnknownKeyFor @NonNull @Initialized TestFlinkRunner create(@UnknownKeyFor @NonNull @Initialized boolean streaming) {
        FlinkPipelineOptions flinkOptions = FlinkPipelineOptions.defaults();
        flinkOptions.setStreaming(streaming);
        return TestFlinkRunner.fromOptions(flinkOptions);
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        try {
            return this.delegate.run(pipeline);
        }
        catch (Throwable t) {
            UserCodeException innermostUserCodeException = null;
            Throwable current = t;
            while (current.getCause() != null) {
                if (current instanceof UserCodeException) {
                    innermostUserCodeException = (UserCodeException)current;
                }
                current = current.getCause();
            }
            if (innermostUserCodeException != null) {
                current = innermostUserCodeException.getCause();
            }
            if (current instanceof AssertionError) {
                throw (AssertionError)((Object)current);
            }
            throw new Pipeline.PipelineExecutionException(current);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineOptions getPipelineOptions() {
        return this.delegate.getPipelineOptions();
    }
}

