/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;

final class AutoValue_PubsubLiteWriteSchemaTransformProvider_PubsubLiteWriteSchemaTransformConfiguration
extends PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration {
    private final String project;
    private final String location;
    private final String topicName;
    private final String format;

    private AutoValue_PubsubLiteWriteSchemaTransformProvider_PubsubLiteWriteSchemaTransformConfiguration(String project, String location, String topicName, String format) {
        this.project = project;
        this.location = location;
        this.topicName = topicName;
        this.format = format;
    }

    @Override
    @SchemaFieldDescription(value="The GCP project where the Pubsub Lite reservation resides. This can be a project number of a project ID.")
    public String getProject() {
        return this.project;
    }

    @Override
    @SchemaFieldDescription(value="The region or zone where the Pubsub Lite reservation resides.")
    public String getLocation() {
        return this.location;
    }

    @Override
    @SchemaFieldDescription(value="The name of the topic to publish data into. This will be concatenated with the project and location parameters to build a full topic path.")
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub Lite. Valid options are: JSON,AVRO")
    public String getFormat() {
        return this.format;
    }

    public String toString() {
        return "PubsubLiteWriteSchemaTransformConfiguration{project=" + this.project + ", location=" + this.location + ", topicName=" + this.topicName + ", format=" + this.format + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration) {
            PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration that = (PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration)o;
            return this.project.equals(that.getProject()) && this.location.equals(that.getLocation()) && this.topicName.equals(that.getTopicName()) && this.format.equals(that.getFormat());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.project.hashCode();
        h$ *= 1000003;
        h$ ^= this.location.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        return h$ ^= this.format.hashCode();
    }

    static final class Builder
    extends PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder {
        private String project;
        private String location;
        private String topicName;
        private String format;

        Builder() {
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setProject(String project) {
            if (project == null) {
                throw new NullPointerException("Null project");
            }
            this.project = project;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setLocation(String location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration build() {
            if (this.project == null || this.location == null || this.topicName == null || this.format == null) {
                StringBuilder missing = new StringBuilder();
                if (this.project == null) {
                    missing.append(" project");
                }
                if (this.location == null) {
                    missing.append(" location");
                }
                if (this.topicName == null) {
                    missing.append(" topicName");
                }
                if (this.format == null) {
                    missing.append(" format");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubLiteWriteSchemaTransformProvider_PubsubLiteWriteSchemaTransformConfiguration(this.project, this.location, this.topicName, this.format);
        }
    }
}

