/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.avro.schemas.io.payloads;

import com.google.auto.service.AutoService;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializerProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@AutoService(value={PayloadSerializerProvider.class})
public class AvroPayloadSerializerProvider
implements PayloadSerializerProvider {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "avro";
    }

    public @UnknownKeyFor @NonNull @Initialized PayloadSerializer getSerializer(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> tableParams) {
        return PayloadSerializer.of(AvroUtils.getRowToAvroBytesFunction(schema), AvroUtils.getAvroBytesToRowFunction(schema));
    }
}

