/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.spark.InternalAccumulator$;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskFailedReason;
import org.apache.spark.TaskKilled;
import org.apache.spark.TaskKilled$;
import org.apache.spark.TaskResultLost$;
import org.apache.spark.TaskState$;
import org.apache.spark.UnknownReason$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.DirectTaskResult;
import org.apache.spark.scheduler.IndirectTaskResult;
import org.apache.spark.scheduler.TaskResult;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.TaskSetManager;
import org.apache.spark.serializer.SerializerHelper$;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BlockId;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ua!\u0002\t\u0012\u0001MI\u0002\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u0011I\u0001!\u0011!Q\u0001\n1BQ\u0001\r\u0001\u0005\u0002EBq!\u000e\u0001C\u0002\u0013%a\u0007\u0003\u0004;\u0001\u0001\u0006Ia\u000e\u0005\bw\u0001\u0011\r\u0011\"\u0005=\u0011\u00199\u0005\u0001)A\u0005{!9\u0001\n\u0001b\u0001\n#I\u0005BB+\u0001A\u0003%!\nC\u0004W\u0001\t\u0007I\u0011C%\t\r]\u0003\u0001\u0015!\u0003K\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\u0007\u0001\t\u0003\tYB\u0001\tUCN\\'+Z:vYR<U\r\u001e;fe*\u0011!cE\u0001\ng\u000eDW\rZ;mKJT!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\n\u0004\u0001i\u0001\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\"I5\t!E\u0003\u0002$'\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002&E\t9Aj\\4hS:<\u0017\u0001C:qCJ\\WI\u001c<\u0004\u0001A\u0011\u0011FK\u0007\u0002'%\u00111f\u0005\u0002\t'B\f'o[#omB\u0011QFL\u0007\u0002#%\u0011q&\u0005\u0002\u0012)\u0006\u001c8nU2iK\u0012,H.\u001a:J[Bd\u0017A\u0002\u001fj]&$h\bF\u00023gQ\u0002\"!\f\u0001\t\u000b\u0019\u001a\u0001\u0019\u0001\u0015\t\u000bI\u0019\u0001\u0019\u0001\u0017\u0002\u000fQC%+R!E'V\tq\u0007\u0005\u0002\u001cq%\u0011\u0011\b\b\u0002\u0004\u0013:$\u0018\u0001\u0003+I%\u0016\u000bEi\u0015\u0011\u0002+\u001d,G\u000fV1tWJ+7/\u001e7u\u000bb,7-\u001e;peV\tQ\b\u0005\u0002?\u000b6\tqH\u0003\u0002A\u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\t\u001b\u0015\u0001B;uS2T\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u007f\tyQ\t_3dkR|'oU3sm&\u001cW-\u0001\fhKR$\u0016m]6SKN,H\u000e^#yK\u000e,Ho\u001c:!\u0003)\u0019XM]5bY&TXM]\u000b\u0002\u0015B\u00191J\u0014)\u000e\u00031S!!T\"\u0002\t1\fgnZ\u0005\u0003\u001f2\u00131\u0002\u00165sK\u0006$Gj\\2bYB\u0011\u0011kU\u0007\u0002%*\u0011\u0001jE\u0005\u0003)J\u0013!cU3sS\u0006d\u0017N_3s\u0013:\u001cH/\u00198dK\u0006Y1/\u001a:jC2L'0\u001a:!\u0003Q!\u0018m]6SKN,H\u000e^*fe&\fG.\u001b>fe\u0006)B/Y:l%\u0016\u001cX\u000f\u001c;TKJL\u0017\r\\5{KJ\u0004\u0013!F3ocV,W/Z*vG\u000e,7o\u001d4vYR\u000b7o\u001b\u000b\u00055v\u0013w\r\u0005\u0002\u001c7&\u0011A\f\b\u0002\u0005+:LG\u000fC\u0003_\u0019\u0001\u0007q,\u0001\buCN\\7+\u001a;NC:\fw-\u001a:\u0011\u00055\u0002\u0017BA1\u0012\u00059!\u0016m]6TKRl\u0015M\\1hKJDQa\u0019\u0007A\u0002\u0011\f1\u0001^5e!\tYR-\u0003\u0002g9\t!Aj\u001c8h\u0011\u0015AG\u00021\u0001j\u00039\u0019XM]5bY&TX\r\u001a#bi\u0006\u0004\"A[7\u000e\u0003-T!\u0001\\\"\u0002\u00079Lw.\u0003\u0002oW\nQ!)\u001f;f\u0005V4g-\u001a:\u0002#\u0015t\u0017/^3vK\u001a\u000b\u0017\u000e\\3e)\u0006\u001c8\u000e\u0006\u0004[cJ\u001c\u00181\u0002\u0005\u0006=6\u0001\ra\u0018\u0005\u0006G6\u0001\r\u0001\u001a\u0005\u0006i6\u0001\r!^\u0001\ni\u0006\u001c8n\u0015;bi\u0016\u00042A^A\u0003\u001d\r9\u0018\u0011\u0001\b\u0003q~t!!\u001f@\u000f\u0005ilX\"A>\u000b\u0005q<\u0013A\u0002\u001fs_>$h(C\u0001\u0019\u0013\t1r#\u0003\u0002\u0015+%\u0019\u00111A\n\u0002\u0013Q\u000b7o[*uCR,\u0017\u0002BA\u0004\u0003\u0013\u0011\u0011\u0002V1tWN#\u0018\r^3\u000b\u0007\u0005\r1\u0003C\u0003i\u001b\u0001\u0007\u0011.\u0001\u0014f]F,X-^3QCJ$\u0018\u000e^5p]\u000e{W\u000e\u001d7fi&|gNT8uS\u001aL7-\u0019;j_:$RAWA\t\u0003+Aa!a\u0005\u000f\u0001\u00049\u0014aB:uC\u001e,\u0017\n\u001a\u0005\u0007\u0003/q\u0001\u0019A\u001c\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\u0005gR|\u0007\u000fF\u0001[\u0001")
public class TaskResultGetter
implements Logging {
    public final SparkEnv org$apache$spark$scheduler$TaskResultGetter$$sparkEnv;
    public final TaskSchedulerImpl org$apache$spark$scheduler$TaskResultGetter$$scheduler;
    private final int THREADS;
    private final ExecutorService getTaskResultExecutor;
    private final ThreadLocal<SerializerInstance> serializer;
    private final ThreadLocal<SerializerInstance> taskResultSerializer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int THREADS() {
        return this.THREADS;
    }

    public ExecutorService getTaskResultExecutor() {
        return this.getTaskResultExecutor;
    }

    public ThreadLocal<SerializerInstance> serializer() {
        return this.serializer;
    }

    public ThreadLocal<SerializerInstance> taskResultSerializer() {
        return this.taskResultSerializer;
    }

    public void enqueueSuccessfulTask(TaskSetManager taskSetManager, long tid, ByteBuffer serializedData) {
        this.getTaskResultExecutor().execute(new Runnable(this, serializedData, taskSetManager, tid){
            private final /* synthetic */ TaskResultGetter $outer;
            private final ByteBuffer serializedData$1;
            private final TaskSetManager taskSetManager$1;
            private final long tid$1;

            public void run() {
                Object object = new Object();
                try {
                    Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        try {
                            Tuple2 tuple2;
                            TaskResult taskResult = (TaskResult)$this.$outer.serializer().get().deserialize($this.serializedData$1, ClassTag$.MODULE$.apply(TaskResult.class));
                            if (taskResult instanceof DirectTaskResult) {
                                DirectTaskResult directTaskResult = (DirectTaskResult)taskResult;
                                if (!$this.taskSetManager$1.canFetchMoreResults(directTaskResult.valueByteBuffer().size())) {
                                    $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask($this.taskSetManager$1, $this.tid$1, TaskState$.MODULE$.KILLED(), new TaskKilled("Tasks result size has exceeded maxResultSize", TaskKilled$.MODULE$.apply$default$2(), TaskKilled$.MODULE$.apply$default$3(), TaskKilled$.MODULE$.apply$default$4()));
                                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                                }
                                directTaskResult.value($this.$outer.taskResultSerializer().get());
                                tuple2 = new Tuple2((Object)directTaskResult, (Object)BoxesRunTime.boxToLong((long)$this.serializedData$1.limit()));
                            } else if (taskResult instanceof IndirectTaskResult) {
                                IndirectTaskResult indirectTaskResult = (IndirectTaskResult)taskResult;
                                BlockId blockId = indirectTaskResult.blockId();
                                long size = indirectTaskResult.size();
                                if (!$this.taskSetManager$1.canFetchMoreResults(size)) {
                                    $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().master().removeBlock(blockId);
                                    $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask($this.taskSetManager$1, $this.tid$1, TaskState$.MODULE$.KILLED(), new TaskKilled("Tasks result size has exceeded maxResultSize", TaskKilled$.MODULE$.apply$default$2(), TaskKilled$.MODULE$.apply$default$3(), TaskKilled$.MODULE$.apply$default$4()));
                                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                                }
                                $this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Fetching indirect task result for ").append($this.taskSetManager$1.taskName($this.tid$1)).toString());
                                $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleTaskGettingResult($this.taskSetManager$1, $this.tid$1);
                                Option<ChunkedByteBuffer> serializedTaskResult = $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().getRemoteBytes(blockId);
                                if (serializedTaskResult.isEmpty()) {
                                    $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask($this.taskSetManager$1, $this.tid$1, TaskState$.MODULE$.FINISHED(), TaskResultLost$.MODULE$);
                                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                                }
                                DirectTaskResult deserializedResult = (DirectTaskResult)SerializerHelper$.MODULE$.deserializeFromChunkedBuffer($this.$outer.serializer().get(), (ChunkedByteBuffer)serializedTaskResult.get(), ClassTag$.MODULE$.apply(DirectTaskResult.class));
                                deserializedResult.value($this.$outer.taskResultSerializer().get());
                                $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.blockManager().master().removeBlock(blockId);
                                tuple2 = new Tuple2((Object)deserializedResult, (Object)BoxesRunTime.boxToLong((long)size));
                            } else {
                                throw new MatchError((Object)taskResult);
                            }
                            Tuple2 tuple22 = tuple2;
                            if (tuple22 == null) {
                                throw new MatchError((Object)tuple22);
                            }
                            DirectTaskResult result = (DirectTaskResult)tuple22._1();
                            long size = tuple22._2$mcJ$sp();
                            Tuple2 tuple23 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToLong((long)size));
                            DirectTaskResult result2 = (DirectTaskResult)tuple23._1();
                            long size2 = tuple23._2$mcJ$sp();
                            result2.accumUpdates_$eq((Seq)result2.accumUpdates().map((Function1 & Serializable & scala.Serializable)a -> {
                                Option<String> option = a.name();
                                Some some = new Some((Object)InternalAccumulator$.MODULE$.RESULT_SIZE());
                                if (!(option != null ? !option.equals((Object)some) : some != null)) {
                                    LongAccumulator acc = (LongAccumulator)a;
                                    Predef$.MODULE$.assert(acc.sum() == 0L, (Function0 & Serializable & scala.Serializable)() -> "task result size should not have been set on the executors");
                                    acc.setValue(size2);
                                    return acc;
                                }
                                return a;
                            }, Seq$.MODULE$.canBuildFrom()));
                            $this.$outer.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleSuccessfulTask($this.taskSetManager$1, $this.tid$1, result2);
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof ClassNotFoundException) {
                                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                                $this.taskSetManager$1.abort(new StringBuilder(32).append("ClassNotFound with classloader: ").append(loader).toString(), $this.taskSetManager$1.abort$default$2());
                            }
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable ex = (Throwable)option.get();
                                $this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while getting task result", ex);
                                $this.taskSetManager$1.abort(new StringOps(Predef$.MODULE$.augmentString("Exception while getting task result: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ex})), $this.taskSetManager$1.abort$default$2());
                            }
                            throw throwable;
                        }
                    });
                }
                catch (NonLocalReturnControl ex) {
                    if (ex.key() == object) {
                        ex.value$mcV$sp();
                    }
                    throw ex;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.serializedData$1 = serializedData$1;
                this.taskSetManager$1 = taskSetManager$1;
                this.tid$1 = tid$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.scheduler.TaskResultGetter$$anon$3 java.lang.Object ), $anonfun$run$4(), $anonfun$run$2(org.apache.spark.scheduler.TaskResultGetter$$anon$3 ), $anonfun$run$3(long org.apache.spark.util.AccumulatorV2 ), $anonfun$run$5()}, serializedLambda);
            }
        });
    }

    public void enqueueFailedTask(TaskSetManager taskSetManager, long tid, Enumeration.Value taskState, ByteBuffer serializedData) {
        ObjectRef reason = ObjectRef.create((Object)UnknownReason$.MODULE$);
        try {
            this.getTaskResultExecutor().execute(() -> Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
                try {
                    try {
                        if (serializedData != null && serializedData.limit() > 0) {
                            reason$1.elem = (TaskFailedReason)this.serializer().get().deserialize(serializedData, loader, ClassTag$.MODULE$.apply(TaskFailedReason.class));
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Could not deserialize TaskEndReason: ClassNotFound with classloader ").append(loader).toString());
                    }
                    catch (Exception exception) {}
                }
                finally {
                    $this.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handleFailedTask(taskSetManager, tid, taskState, (TaskFailedReason)reason$1.elem);
                }
            }));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RejectedExecutionException && this.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.isStopped()) {
            }
            throw throwable;
        }
    }

    public void enqueuePartitionCompletionNotification(int stageId, int partitionId) {
        this.getTaskResultExecutor().execute(() -> Utils$.MODULE$.logUncaughtExceptions((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.org$apache$spark$scheduler$TaskResultGetter$$scheduler.handlePartitionCompleted(stageId, partitionId)));
    }

    public void stop() {
        this.getTaskResultExecutor().shutdownNow();
    }

    public TaskResultGetter(SparkEnv sparkEnv, TaskSchedulerImpl scheduler) {
        this.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv = sparkEnv;
        this.org$apache$spark$scheduler$TaskResultGetter$$scheduler = scheduler;
        Logging.$init$(this);
        this.THREADS = sparkEnv.conf().getInt("spark.resultGetter.threads", 4);
        this.getTaskResultExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(this.THREADS(), "task-result-getter");
        this.serializer = new ThreadLocal<SerializerInstance>(this){
            private final /* synthetic */ TaskResultGetter $outer;

            public SerializerInstance initialValue() {
                return this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.closureSerializer().newInstance();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.taskResultSerializer = new ThreadLocal<SerializerInstance>(this){
            private final /* synthetic */ TaskResultGetter $outer;

            public SerializerInstance initialValue() {
                return this.$outer.org$apache$spark$scheduler$TaskResultGetter$$sparkEnv.serializer().newInstance();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

