/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sasinput;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sasinput.SasInput;
import org.apache.hop.pipeline.transforms.sasinput.SasInputData;
import org.apache.hop.pipeline.transforms.sasinput.SasInputField;
import org.w3c.dom.Node;

@Transform(id="SASInput", image="sasinput.svg", name="i18n::SasInput.Transform.Name", description="i18n::SasInput.Transform.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::SasInputMeta.keyword"}, documentationUrl="/pipeline/transforms/sasinput.html")
public class SasInputMeta
extends BaseTransformMeta<SasInput, SasInputData> {
    private static final Class<?> PKG = SasInputMeta.class;
    public static final String Xml_TAG_FIELD = "field";
    private String acceptingField;
    private List<SasInputField> outputFields;

    public void setDefault() {
        this.outputFields = new ArrayList<SasInputField>();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.acceptingField = XmlHandler.getTagValue((Node)transformNode, (String)"accept_field");
            int nrFields = XmlHandler.countNodes((Node)transformNode, (String)Xml_TAG_FIELD);
            this.outputFields = new ArrayList<SasInputField>();
            for (int i = 0; i < nrFields; ++i) {
                Node fieldNode = XmlHandler.getSubNodeByNr((Node)transformNode, (String)Xml_TAG_FIELD, (int)i);
                this.outputFields.add(new SasInputField(fieldNode));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"SASInputMeta.Exception.UnableToReadTransformInformationFromXml", (String[])new String[0]), (Throwable)e);
        }
    }

    public Object clone() {
        SasInputMeta retval = (SasInputMeta)((Object)super.clone());
        retval.setOutputFields(new ArrayList<SasInputField>());
        for (SasInputField field : this.outputFields) {
            retval.getOutputFields().add(field.clone());
        }
        return retval;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (SasInputField field : this.outputFields) {
            try {
                IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)field.getRename(), (int)field.getType());
                valueMeta.setLength(field.getLength(), field.getPrecision());
                valueMeta.setDecimalSymbol(field.getDecimalSymbol());
                valueMeta.setGroupingSymbol(field.getGroupingSymbol());
                valueMeta.setConversionMask(field.getConversionMask());
                valueMeta.setTrimType(field.getTrimType());
                valueMeta.setOrigin(name);
                inputRowMeta.addValueMeta(valueMeta);
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)"accept_field", (String)this.acceptingField));
        for (SasInputField field : this.outputFields) {
            retval.append(XmlHandler.openTag((String)Xml_TAG_FIELD));
            retval.append(field.getXml());
            retval.append(XmlHandler.closeTag((String)Xml_TAG_FIELD));
        }
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (Utils.isEmpty((CharSequence)this.getAcceptingField())) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SASInput.Log.Error.InvalidAcceptingFieldName", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getAcceptingField() {
        return this.acceptingField;
    }

    public void setAcceptingField(String acceptingField) {
        this.acceptingField = acceptingField;
    }

    public List<SasInputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<SasInputField> outputFields) {
        this.outputFields = outputFields;
    }
}

