/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AFPResource;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.PrintObjectInputStreamImpl;
import com.ibm.as400.access.PrintParameterList;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SpooledFile;
import com.ibm.as400.access.SpooledFileImpl;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

public class PrintObjectInputStream
extends InputStream {
    private transient AS400 system_;
    private transient PrintObjectInputStreamImpl impl_;

    PrintObjectInputStream(SpooledFile sf, PrintParameterList openOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.system_ = sf.getSystem();
        this.chooseImpl();
        this.system_.connectService(1);
        if (sf.getImpl() == null) {
            sf.chooseImpl();
        }
        this.impl_.createPrintObjectInputStream((SpooledFileImpl)sf.getImpl(), openOptions);
    }

    PrintObjectInputStream(SpooledFile sf, PrintParameterList openOptions, String acifProcess) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.system_ = sf.getSystem();
        this.chooseImpl();
        this.system_.connectService(1);
        if (sf.getImpl() == null) {
            sf.chooseImpl();
        }
        this.impl_.createPrintObjectInputStream((SpooledFileImpl)sf.getImpl(), openOptions, acifProcess);
    }

    PrintObjectInputStream(AFPResource resource, PrintParameterList openOptions) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, RequestNotSupportedException {
        this.system_ = resource.getSystem();
        this.chooseImpl();
        this.system_.connectService(1);
        if (resource.getImpl() == null) {
            resource.chooseImpl();
        }
        this.impl_.createPrintObjectInputStream(resource.getImpl(), openOptions);
    }

    @Override
    public int available() throws IOException {
        return this.impl_.available();
    }

    private void chooseImpl() {
        if (this.system_ == null) {
            Trace.log(2, "Attempt to use PrintObjectInputStream before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        this.impl_ = (PrintObjectInputStreamImpl)this.system_.loadImpl2("com.ibm.as400.access.PrintObjectInputStreamImplRemote", "com.ibm.as400.access.PrintObjectInputStreamImplProxy");
    }

    @Override
    public void close() throws IOException {
        this.impl_.close();
    }

    @Override
    public void mark(int readLimit) {
        this.impl_.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int iRC = -1;
        byte[] byteBuffer = new byte[1];
        int rc = this.read(byteBuffer);
        if (rc == 1) {
            iRC = byteBuffer[0];
        }
        return iRC;
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int dataOffset, int length) throws IOException {
        return this.impl_.read(data, dataOffset, length);
    }

    @Override
    public void reset() throws IOException {
        this.impl_.reset();
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        return this.impl_.skip(bytesToSkip);
    }
}

