/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCSQLXML;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.HexReaderInputStream;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLDate;
import com.ibm.as400.access.SQLTime;
import com.ibm.as400.access.SQLTimestamp;
import java.io.CharConversionException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

final class SQLGraphic
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private int maxLength_;
    private String value_;
    private String originalValue_;
    private int ccsid_;

    SQLGraphic(int maxLength, SQLConversionSettings settings, int ccsid) {
        super(settings);
        this.maxLength_ = maxLength;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.value_ = "";
        this.originalValue_ = "";
        this.ccsid_ = ccsid;
    }

    @Override
    public Object clone() {
        return new SQLGraphic(this.maxLength_, this.settings_, this.ccsid_);
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        int bidiStringType = this.settings_.getBidiStringType();
        if (bidiStringType == -1) {
            bidiStringType = ccsidConverter.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        this.originalValue_ = this.value_ = ccsidConverter.byteArrayToString(rawBytes, offset, this.maxLength_, bidiConversionProperties);
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        int bidiStringType;
        int exactLength;
        int valueLength;
        int ccsid = ccsidConverter.getCcsid();
        if (ccsid != 13488 && ccsid != 1200 && (valueLength = this.originalValue_.length()) < (exactLength = this.getDisplaySize())) {
            StringBuffer buffer = new StringBuffer(this.originalValue_);
            char c = '\u3000';
            for (int i = valueLength; i < exactLength; ++i) {
                buffer.append(c);
            }
            this.value_ = buffer.toString();
        }
        if ((bidiStringType = this.settings_.getBidiStringType()) == -1) {
            bidiStringType = ccsidConverter.bidiStringType_;
        }
        BidiConversionProperties bidiConversionProperties = new BidiConversionProperties(bidiStringType);
        bidiConversionProperties.setBidiImplicitReordering(this.settings_.getBidiImplicitReordering());
        bidiConversionProperties.setBidiNumericOrderingRoundTrip(this.settings_.getBidiNumericOrdering());
        try {
            ccsidConverter.stringToByteArray(this.value_, rawBytes, offset, this.maxLength_, bidiConversionProperties);
        }
        catch (CharConversionException e) {
            this.maxLength_ = ccsidConverter.stringToByteArray(this.value_, bidiConversionProperties).length;
            JDError.throwSQLException((Object)this, "HY000", e);
        }
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        int exactLength;
        String value = null;
        if (object instanceof String) {
            value = (String)object;
        } else if (object instanceof Character) {
            value = object.toString();
        } else if (object instanceof Number) {
            value = object.toString();
        } else if (object instanceof Boolean) {
            value = this.settings_.getTranslateBoolean() ? object.toString() : ((Boolean)object == true ? "1" : "0");
        } else if (object instanceof Time) {
            value = SQLTime.timeToString((Time)object, this.settings_, calendar);
        } else if (object instanceof Timestamp) {
            value = SQLTimestamp.timestampToStringTrimTrailingZeros((Timestamp)object, calendar, this.settings_);
        } else if (object instanceof Date) {
            value = SQLDate.dateToString((Date)object, this.settings_, calendar);
        } else if (object instanceof URL) {
            value = object.toString();
        } else if (object instanceof Clob) {
            Clob clob = (Clob)object;
            value = clob.getSubString(1L, (int)clob.length());
        } else if (object instanceof Reader) {
            value = SQLGraphic.getStringFromReader((Reader)object, -2, this);
        } else if (object instanceof SQLXML) {
            SQLXML xml = (SQLXML)object;
            value = xml.getString();
        }
        if (value == null) {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            JDError.throwSQLException((Object)this, "07006");
        }
        this.value_ = value;
        this.originalValue_ = value;
        int valueLength = this.value_.length();
        if (valueLength < (exactLength = this.getDisplaySize())) {
            StringBuffer buffer = new StringBuffer(this.value_);
            char c = ' ';
            for (int i = valueLength; i < exactLength; ++i) {
                buffer.append(c);
            }
            this.value_ = buffer.toString();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
        } else if (valueLength > exactLength) {
            this.originalValue_ = this.value_ = this.value_.substring(0, exactLength);
            this.truncated_ = valueLength - exactLength;
            this.outOfBounds_ = false;
        } else {
            this.truncated_ = 0;
        }
        this.outOfBounds_ = false;
    }

    @Override
    public int getSQLType() {
        return 17;
    }

    @Override
    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    @Override
    public int getDisplaySize() {
        if (this.ccsid_ == 65535) {
            return this.maxLength_;
        }
        return this.maxLength_ / 2;
    }

    @Override
    public String getJavaClassName() {
        return "java.lang.String";
    }

    @Override
    public String getLiteralPrefix() {
        return "'";
    }

    @Override
    public String getLiteralSuffix() {
        return "'";
    }

    @Override
    public String getLocalName() {
        return "GRAPHIC";
    }

    @Override
    public int getMaximumPrecision() {
        return 16382;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 468;
    }

    @Override
    public int getPrecision() {
        return this.maxLength_ / 2;
    }

    @Override
    public int getRadix() {
        return 0;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        if (this.ccsid_ == 1200) {
            return -15;
        }
        return 1;
    }

    @Override
    public String getTypeName() {
        if (this.ccsid_ == 1200) {
            return "NCHAR";
        }
        return "GRAPHIC";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public int getActualSize() {
        return this.value_.length();
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new HexReaderInputStream(new StringReader(this.getString()));
    }

    @Override
    public Blob getBlob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return new AS400JDBCBlob(BinaryConverter.stringToBytes(this.getString()), this.maxLength_);
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            return BinaryConverter.stringToBytes(this.getString());
        }
        catch (NumberFormatException nfe) {
            JDError.throwSQLException((Object)this, "07006", nfe);
            return null;
        }
    }

    @Override
    public Object getBatchableObject() throws SQLException {
        return this.originalValue_;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.getString();
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length() > maxFieldSize && maxFieldSize > 0) {
            return this.value_.substring(0, maxFieldSize);
        }
        return this.value_;
    }

    public void trim() {
        this.originalValue_ = this.value_ = this.value_.trim();
    }

    @Override
    public String getNString() throws SQLException {
        int maxFieldSize = this.settings_.getMaxFieldSize();
        if (this.value_.length() > maxFieldSize && maxFieldSize > 0) {
            return this.value_.substring(0, maxFieldSize);
        }
        return this.value_;
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCSQLXML(this.getString());
    }

    @Override
    public void saveValue() {
        this.savedValue_ = this.value_;
    }
}

